Scriptname dou_artifact_ground_hunt_quest extends Quest

FormList Property artifactlist Auto Const mandatory
FormList Property GangMembers Auto Const mandatory
Int Property MinGangMembers Auto Const mandatory
Int Property MaxGangMembers Auto Const mandatory

int CONST_Aggression_VeryAggressive = 2 Const
int CONST_Suspicious_DetectedActor = 2 Const

ReferenceAlias property BountyTarget auto const mandatory

Actor[] SpawnedCreatures

Event OnQuestStarted()
    Self.SetObjectiveDisplayed(10, True, False)
    ObjectReference enemyActor = BountyTarget.getRef()

    Int hostilenpcs = Utility.RandomInt(MinGangMembers, MaxGangMembers)
    ActorValue Suspicious = Game.GetFormFromFile(748, "Starfield.esm") as ActorValue;Suspicious [AVIF:000002EC]
    ActorValue Aggression = Game.GetFormFromFile(700, "Starfield.esm") as ActorValue;Aggression [AVIF:000002BC]
    bool artifactplaced = false
    bool boss = false
    SpawnedCreatures = new Actor[0]

    Form creature = GangMembers.GetAt(Utility.RandomInt(0, GangMembers.GetSize() - 1))
    While hostilenpcs > 0
      Float[] placePosition = new Float[6]
      placePosition[0] = (Utility.RandomFloat(-50, 50))
      placePosition[1] = (Utility.RandomFloat(-50, 50))
      placePosition[2] = 0

      Actor enemy = enemyActor.PlaceAtMe(creature, 1, True, False, True, placePosition, None, True) as Actor
      enemy.SetValue(Suspicious, CONST_Suspicious_DetectedActor)
      enemy.SetValue(Aggression, CONST_Aggression_VeryAggressive)
      SpawnedCreatures.add(enemy, 1)

      if boss == false
        enemyActor.Disable(false)
        BountyTarget.ForceRefTo(enemy)
        enemyActor = BountyTarget.getRef()
        RegisterForRemoteEvent(enemyActor As Actor, "OnDeath")
        boss = true
      endif 
      ;Artifacts
      if Utility.RandomInt(0, 100) > 75
        enemy.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
      endif
      ;We want one artifact per bounty
      ;if artifactplaced == false && hostilenpcs == 1
      ;  enemy.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
      ;  artifactplaced = true
      ;endif

      hostilenpcs -= 1 ; #DEBUG_LINE_NO:803
    EndWhile
    Parent.OnQuestStarted()
endEvent

Event Actor.OnDeath(Actor akSource, ObjectReference akKiller)
  bool alive = false
  int index = 0
  While (index < SpawnedCreatures.Length && alive == false)
    if SpawnedCreatures[index].IsDead() == false
      BountyTarget.ForceRefTo(SpawnedCreatures[index])
      RegisterForRemoteEvent(BountyTarget.getRef() As Actor, "OnDeath")
      alive = true
    endif
    index += 1
  EndWhile
  if alive == false    
    Self.SetObjectiveCompleted(10, True)
    Self.SetStage(100)
    Parent.CompleteQuest()
  endif
EndEvent

Event OnQuestRejected()
  Self.SetObjectiveDisplayed(10, False, False)
  Self.Stop()
EndEvent