Scriptname duo_bountyscript_named extends missionquestscript
{for bounty missions that need to select enemy type}
Form Property TargetNpc Auto Const mandatory
FormList Property GangMembers Auto Const mandatory
FormList Property artifactlist Auto Const mandatory
FormList Property NameList Auto Const mandatory

Int Property MinGangMembers Auto Const mandatory
Int Property MaxGangMembers Auto Const mandatory


group Bounty
    ReferenceAlias property EnemyType auto Const Mandatory
EndGroup

int CONST_Aggression_VeryAggressive = 2 Const
int CONST_Suspicious_DetectedActor = 2 Const

Event OnQuestStarted()  
    
    Parent.OnQuestStarted()
endEvent

Function MissionAccepted(Bool bAccepted)
  Parent.MissionAccepted(bAccepted)
  ObjectReference enemyActor = PrimaryRef.getRef()
    
  ;Spawn and rename the boss
  ObjectReference newboss = enemyActor.PlaceAtMe(TargetNpc, 1, False, False, False, None, None, false)
  Message name = NameList.GetAt(Utility.RandomInt(0, NameList.GetSize() - 1)) As Message
  newboss.SetOverrideName(name)
  PrimaryRef.ForceRefTo(newboss)

  Int hostilenpcs = Utility.RandomInt(MinGangMembers, MaxGangMembers)
  ActorValue Suspicious = Game.GetFormFromFile(748, "Starfield.esm") as ActorValue;Suspicious [AVIF:000002EC]
  ActorValue Aggression = Game.GetFormFromFile(700, "Starfield.esm") as ActorValue;Aggression [AVIF:000002BC]

  bool artifactplaced = false
  While hostilenpcs > 0
    Float[] placePosition = new Float[6]
    placePosition[0] = (Utility.RandomFloat(-50, 50))
    placePosition[1] = (Utility.RandomFloat(-50, 50))
    placePosition[2] = 0

    Actor enemy = enemyActor.PlaceAtMe(GangMembers.GetAt(Utility.RandomInt(0, GangMembers.GetSize() - 1)), 1, True, False, True, placePosition, None, True) as Actor
    enemy.SetValue(Suspicious, CONST_Suspicious_DetectedActor)
    enemy.SetValue(Aggression, CONST_Aggression_VeryAggressive)

    ;Artifacts
    if Utility.RandomInt(0, 100) > 75
      enemy.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
      artifactplaced = true
    endif
    ;We want one artifact per bounty
    ;if artifactplaced == false && hostilenpcs == 1
    ;  enemy.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
    ;  artifactplaced = true
    ;endif

    hostilenpcs -= 1 ; #DEBUG_LINE_NO:803
  EndWhile
  
EndFunction