ScriptName ccs_planet_activator_act_delivery Extends ObjectReference
;-- Variables ---------------------------------------

;-- Properties --------------------------------------
Quest Property questobjective Auto Const mandatory
Form Property Cargo Auto
Int Property CargoAmount Auto Const mandatory
Message Property FailMessage Auto Const mandatory
Message Property SuccessMessage Auto Const mandatory
Message Property StartMessage Auto Const mandatory
Form Property ShipToSpawn Auto Const mandatory

;-- Functions ---------------------------------------

Event OnActivate(ObjectReference akActionRef)
  Bool repaired = false
  Actor myPlayer = Game.GetPlayer()
  ccs_planet_activator_qst kmyQuest = questobjective as ccs_planet_activator_qst ; #DEBUG_LINE_NO:25

  Cargo = kmyQuest.Cargo

  spaceshipreference myShip = myPlayer.GetCurrentShipRef()
  If repaired == false
    If myPlayer.GetItemCount(Cargo) >= CargoAmount
      myPlayer.RemoveItem(Cargo, CargoAmount, False, None)
      repaired = true
    EndIf
  EndIf
  If repaired == true
    Self.BlockActivation(True,True)
    ;StartMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
    ;Utility.wait(Utility.RandomInt(3, 5))
    questobjective.SetObjectiveCompleted(10, True)
    ;SuccessMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
    kmyQuest.MissionComplete()
  Else
    FailMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
  EndIf
EndEvent