Scriptname dou_artifact_ground_activator_quest extends Quest

FormList Property artifactlist Auto Const mandatory
FormList Property GangMembers Auto Const mandatory
Int Property MinGangMembers Auto Const mandatory
Int Property MaxGangMembers Auto Const mandatory
Int Property HostileChance Auto Const mandatory

Int Property DisableAfterActivate Auto Const mandatory

int CONST_Aggression_VeryAggressive = 2 Const
int CONST_Suspicious_DetectedActor = 2 Const

ReferenceAlias property ActivatorTarget auto const mandatory


Event OnQuestStarted()
    Self.SetObjectiveDisplayed(10, True, False)
    ObjectReference Target = ActivatorTarget.getRef()
    RegisterForRemoteEvent(Target, "OnActivate")
    if Utility.RandomInt(0, 100) > HostileChance
      ;Hostile Presence
      Int hostilenpcs = Utility.RandomInt(MinGangMembers, MaxGangMembers)
      ActorValue Suspicious = Game.GetFormFromFile(748, "Starfield.esm") as ActorValue;Suspicious [AVIF:000002EC]
      ActorValue Aggression = Game.GetFormFromFile(700, "Starfield.esm") as ActorValue;Aggression [AVIF:000002BC]
      bool artifactplaced = false
      bool boss = false
      While hostilenpcs > 0
        Float[] placePosition = new Float[6]
        placePosition[0] = (Utility.RandomFloat(-50, 50))
        placePosition[1] = (Utility.RandomFloat(-50, 50))
        placePosition[2] = 0

        Actor enemy = Target.PlaceAtMe(GangMembers.GetAt(Utility.RandomInt(0, GangMembers.GetSize() - 1)), 1, True, False, True, placePosition, None, True) as Actor
        enemy.SetValue(Suspicious, CONST_Suspicious_DetectedActor)
        enemy.SetValue(Aggression, CONST_Aggression_VeryAggressive)

        ;Artifacts
        if Utility.RandomInt(0, 100) > 75
          enemy.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
        endif
        ;We want one artifact per bounty
        ;if artifactplaced == false && hostilenpcs == 1
        ;  enemy.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
        ;  artifactplaced = true
        ;endif

        hostilenpcs -= 1 ; #DEBUG_LINE_NO:803
      EndWhile
    endif
    Parent.OnQuestStarted()
endEvent

Event ObjectReference.OnActivate(ObjectReference akSender, ObjectReference akActionRef)
  ObjectReference Target = ActivatorTarget.getRef()
  Target.BlockActivation(True,True)
  if DisableAfterActivate > 0
    Target.DisableNoWait(false)
  endif
  Self.SetObjectiveCompleted(10, True)
  Self.SetStage(100)
  Parent.CompleteQuest()
EndEvent


Event OnQuestRejected()
  Self.SetObjectiveDisplayed(10, False, False)
  Self.Stop()
EndEvent