Scriptname dou_artifact_ground_quest extends SQ_TreasureMapQuestScript

Int Property CredRewardMax Auto Const mandatory

FormList Property artifactlist Auto Const mandatory
FormList Property GangMembers Auto Const mandatory
Int Property MinGangMembers Auto Const mandatory
Int Property MaxGangMembers Auto Const mandatory
int CONST_Aggression_VeryAggressive = 2 Const
int CONST_Suspicious_DetectedActor = 2 Const

ReferenceAlias property TreasureContainer auto const mandatory
{ Treasure container }

LocationAlias property dungeonLocation auto const mandatory
{ treasure location }

MissionParentScript property MB_Parent auto const mandatory
{ holds array of resource AVs }

LegendaryItem property legendtype auto const mandatory

Event OnQuestStarted()
    ObjectReference enemyActor = TreasureContainer.getRef()

    Int hostilenpcs = Utility.RandomInt(MinGangMembers, MaxGangMembers)
    ActorValue Suspicious = Game.GetFormFromFile(748, "Starfield.esm") as ActorValue;Suspicious [AVIF:000002EC]
    ActorValue Aggression = Game.GetFormFromFile(700, "Starfield.esm") as ActorValue;Aggression [AVIF:000002BC]
    bool artifactplaced = false
    While hostilenpcs > 0
      Float[] placePosition = new Float[6]
      placePosition[0] = (Utility.RandomFloat(-50, 50))
      placePosition[1] = (Utility.RandomFloat(-50, 50))
      placePosition[2] = 0

      Actor enemy = enemyActor.PlaceAtMe(GangMembers.GetAt(Utility.RandomInt(0, GangMembers.GetSize() - 1)), 1, True, False, True, placePosition, None, True) as Actor
      enemy.SetValue(Suspicious, CONST_Suspicious_DetectedActor)
      enemy.SetValue(Aggression, CONST_Aggression_VeryAggressive)

      ;Artifacts
      if Utility.RandomInt(0, 100) > 75
        enemy.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
        artifactplaced = true
      endif
      ;We want one artifact per bounty
      ;if artifactplaced == false && hostilenpcs == 1
      ;  enemy.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
      ;  artifactplaced = true
      ;endif

      hostilenpcs -= 1 ; #DEBUG_LINE_NO:803
    EndWhile
    Parent.OnQuestStarted()
endEvent


bool Function CreateTreasure()
    ObjectReference container = TreasureContainer.GetRef()
    container.AddItem(Game.GetCredits() as Form, Utility.RandomInt(1000, CredRewardMax), False)
    ObjectReference treasureRef = Treasure.GetRef()
    treasureRef.PromoteToLegendary(Utility.RandomInt(1, 3),legendtype)
    ;Debug.TraceAndBox("dou_artifact_ground_quest CreateTreasure()", 1)
    return true
endFunction

Event Actor.OnLocationChange(Actor akSource, Location akOldLoc, Location akNewLoc)
;    if myDungeonLocation
;        if akNewLoc == myDungeonLocation || akOldLoc == myDungeonLocation
;            ; entering or leaving the location - update tracking
;            UpdateItemTracking()
;        endif
;    endif
endEvent

Event ObjectReference.OnItemAdded(ObjectReference akSource, Form akBaseItem, int aiItemCount, ObjectReference akItemReference, ObjectReference akSourceContainer, int aiTransferReason)
    ; only count this if it comes from valid transfer reasons
;    if aiTransferReason == 4 || aiTransferReason == 7 || aiTransferReason == 12 || aiTransferReason == 42
;        SetStage(ObjectiveStage)
;        UnregisterForRemoteEvent(Game.GetPlayer(), "OnItemAdded")
;    endif
EndEvent

Function UpdateItemTracking()
;        Actor playerRef = Game.GetPlayer()
        ; if player is currently in location, watch for item added
;        if playerRef.GetCurrentLocation() == myDungeonLocation
;            AddInventoryEventFilter(myResource)
;            RegisterForRemoteEvent(playerRef, "OnItemAdded")
;        else
        ; otherwise stop tracking item added
;            UnregisterForRemoteEvent(playerRef, "OnItemAdded")
;        endif
endFunction
