ScriptName duo_citydelivery_qst Extends MissionQuestScript

;-- Variables ---------------------------------------
Form Property PickupActivator Auto Const mandatory
Form Property DropoffActivator Auto Const mandatory

float Property NudgeX Auto Const mandatory
float Property NudgeY Auto Const mandatory
float Property NudgeZ Auto Const mandatory

Form Property Heatleech Auto Const mandatory
ObjectReference[] Property SpawnedNests Auto
Int Property NestCount Auto Const mandatory

ReferenceAlias Property Alias_PrimaryRef Auto Const mandatory
ReferenceAlias Property Alias_FinalRef Auto Const mandatory
FormList Property replacelist Auto Const mandatory

FormList Property artifactlist Auto Const mandatory

Form Property Cargo Auto

ReferenceAlias Property ResourceName Auto Const
;-- Properties --------------------------------------
Group PlantEvidenceMissionData
  ReferenceAlias Property HoldingContainer Auto Const mandatory
  { alias where data disk ref will be created }
  ReferenceAlias Property Evidence Auto Const mandatory
  { evidence to plant }
  Float Property CooldownDays = 2.0 Auto Const
  { how long before the same target location can be picked again? }
  ActorValue Property CooldownAV Auto Const mandatory
  { AV to use for cooldown timestamp }
EndGroup

GlobalVariable Property RewardGlobal Auto Const mandatory
GlobalVariable Property RI_CreditsReward Auto mandatory
Int Property iCompletionStage Auto Const mandatory

int CONST_Aggression_VeryAggressive = 2 Const
int CONST_Suspicious_DetectedActor = 2 Const
;-- Functions ---------------------------------------

Event OnQuestStarted()
  Cargo = Evidence.getRef().getBaseObject()
  ResourceName.ForceRefTo(Evidence.getRef())
  Parent.OnQuestStarted()
EndEvent

Function SetRewardValues()
  RI_CreditsReward.SetValue(RewardGlobal.GetValue()) ; #DEBUG_LINE_NO:43
EndFunction

Function AddFinalValues()
  RI_CreditsReward.SetValue(RewardGlobal.GetValue()) ; #DEBUG_LINE_NO:95
  Self.SetStage(iCompletionStage) ; #DEBUG_LINE_NO:100
EndFunction

;-- Functions ---------------------------------------

Function MissionAccepted(Bool bAccepted)
  Parent.MissionAccepted(bAccepted) ; #DEBUG_LINE_NO:23  
EndFunction

Function HandleOnQuestRejected()
  Self.CleanupMission() ; #DEBUG_LINE_NO:28
  Self.MissionFailed() ; #DEBUG_LINE_NO:29
EndFunction

Function MissionComplete()
  Self.SetStage(95)
  Self.CleanupMission() ; #DEBUG_LINE_NO:33
  Parent.MissionComplete() ; #DEBUG_LINE_NO:34
EndFunction

Function CleanupMission()
  ;PrimaryRef.GetRef().RemoveItem(Evidence.GetRef() as Form, 1, False, None) ; #DEBUG_LINE_NO:39
  ;Location targetLoc = TargetLocation.GetLocation() ; #DEBUG_LINE_NO:42
  ;targetLoc.SetValue(CooldownAV, Utility.GetCurrentGameTime() + CooldownDays) ; #DEBUG_LINE_NO:43
EndFunction

Function SetupMisson()
  ObjectReference PickupContainerRef = Alias_PrimaryRef.GetRef()  
  Alias_PrimaryRef.ForceRefTo(PickupContainerRef.PlaceAtMe(PickupActivator, 1, True, False, True, None, None, True))
  PickupContainerRef.Disable(False)

  if Utility.RandomInt(0, 100) > 90
    ;Hostile Presence
    Int hostilenpcs = Utility.RandomInt(3, 10)
    Form hostile = GetEnemyForm()
    ActorValue Suspicious = Game.GetFormFromFile(748, "Starfield.esm") as ActorValue;Suspicious [AVIF:000002EC]
    ActorValue Aggression = Game.GetFormFromFile(700, "Starfield.esm") as ActorValue;Aggression [AVIF:000002BC]
    While hostilenpcs > 0
      Float[] placePosition = new Float[6]
      placePosition[0] = (Utility.RandomFloat(-50, 50))
      placePosition[1] = (Utility.RandomFloat(-50, 50))
      placePosition[2] = 0
      Actor enemy = PickupContainerRef.PlaceAtMe(hostile, 1, True, False, True, placePosition, None, True) as Actor
      enemy.SetValue(Suspicious, CONST_Suspicious_DetectedActor)
      enemy.SetValue(Aggression, CONST_Aggression_VeryAggressive)

      ;Artifacts
      if Utility.RandomInt(0, 100) > 75
        enemy.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
      endif

      hostilenpcs -= 1 ; #DEBUG_LINE_NO:803
    EndWhile
  Else
    Int npcs = Utility.RandomInt(3, 10)
    While npcs > 0
      Float[] placePosition = new Float[6]
      placePosition[0] = (Utility.RandomFloat(-50, 50))
      placePosition[1] = (Utility.RandomFloat(-50, 50))
      placePosition[2] = 0
      ;Some missions use the heatleechs as badguys, so allow them to have artifacts
      Actor friendly = PickupContainerRef.PlaceAtMe(Heatleech, 1, True, False, True, placePosition, None, True) as Actor
      ;Artifacts
      if Utility.RandomInt(0, 100) > 75
        friendly.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
      endif
      
      npcs -= 1 ; #DEBUG_LINE_NO:803
    EndWhile
  EndIf

EndFunction

Function SetupDestination()
  ObjectReference DropoffContainerRef = Alias_FinalRef.GetRef()

  Float[] placePosition = new Float[6]
  placePosition[0] = NudgeX
  placePosition[1] = NudgeY
  placePosition[2] = NudgeZ
  
  
  ObjectReference dropoff = DropoffContainerRef.PlaceAtMe(DropoffActivator, 1, True, False, True, placePosition, None, True)
  Alias_FinalRef.ForceRefTo(dropoff)
  ;DropoffContainerRef.Disable(False)
  SetObjectiveDisplayed(20,True,False)

EndFunction

Form Function GetEnemyForm()
  Int chance = Utility.RandomInt(0, 100)
  if chance > 1 && chance <= 33
    return Game.GetFormFromFile(68409, "Starfield.esm");LCharCrimsonFleet [LVLN:00010B39]
  ElseIf chance > 33 && chance <= 66
    return Game.GetFormFromFile(2603901, "Starfield.esm");LCharSpacer [LVLN:0027BB7D]
  Else
    return Game.GetFormFromFile(2556551, "Starfield.esm");LCharEcliptic [LVLN:00270287]
  EndIf
EndFunction
