ScriptName ccs_missioninfestation01 Extends MissionQuestScript

;-- Variables ---------------------------------------
Form Property Nest Auto Const mandatory
Form Property Heatleech Auto Const mandatory
ObjectReference[] Property SpawnedNests Auto
Int Property NestCount Auto Const mandatory
ReferenceAlias Property Alias_PrimaryRef Auto Const mandatory
FormList Property replacelist Auto Const mandatory
FormList Property artifactlist Auto Const mandatory
;-- Properties --------------------------------------
Group PlantEvidenceMissionData
  ReferenceAlias Property HoldingContainer Auto Const mandatory
  { alias where data disk ref will be created }
  ReferenceAlias Property Evidence Auto Const mandatory
  { evidence to plant }
  Float Property CooldownDays = 2.0 Auto Const
  { how long before the same target location can be picked again? }
  ActorValue Property CooldownAV Auto Const mandatory
  { AV to use for cooldown timestamp }
EndGroup

GlobalVariable Property RewardGlobal Auto Const mandatory
GlobalVariable Property RI_CreditsReward Auto mandatory
Int Property iCompletionStage Auto Const mandatory
;-- Functions ---------------------------------------

Function SetRewardValues()
  RI_CreditsReward.SetValue(RewardGlobal.GetValue()) ; #DEBUG_LINE_NO:43
EndFunction

Function AddFinalValues()
  RI_CreditsReward.SetValue(RewardGlobal.GetValue()) ; #DEBUG_LINE_NO:95
  Self.SetStage(iCompletionStage) ; #DEBUG_LINE_NO:100
EndFunction

;-- Functions ---------------------------------------

Function MissionAccepted(Bool bAccepted)
  Parent.MissionAccepted(bAccepted) ; #DEBUG_LINE_NO:23
EndFunction

Function HandleOnQuestRejected()
  Self.CleanupMission() ; #DEBUG_LINE_NO:28
  Self.MissionFailed() ; #DEBUG_LINE_NO:29
EndFunction

Function MissionComplete()
  Self.CleanupMission() ; #DEBUG_LINE_NO:33
  Parent.MissionComplete() ; #DEBUG_LINE_NO:34
EndFunction

Function CleanupMission()
  ;PrimaryRef.GetRef().RemoveItem(Evidence.GetRef() as Form, 1, False, None) ; #DEBUG_LINE_NO:39
  ;Location targetLoc = TargetLocation.GetLocation() ; #DEBUG_LINE_NO:42
  ;targetLoc.SetValue(CooldownAV, Utility.GetCurrentGameTime() + CooldownDays) ; #DEBUG_LINE_NO:43
EndFunction

Function SetupMisson()
  ;Logic
  ;1. Replace container with a target
  ;2. OnCellLoad of target spawn the rest of the objectives ( this is needed so that other targets load)

  ObjectReference ContainerRef = Alias_PrimaryRef.GetRef()  
  Alias_PrimaryRef.ForceRefTo(ContainerRef.PlaceAtMe(Nest, 1, True, False, True, None, None, True))
  ContainerRef.PlaceAtMe(Heatleech, 2, True, False, True, None, None, True)
  ContainerRef.Disable(False)

  SpawnedNests = new ObjectReference[0]
  SpawnedNests.add(ContainerRef, 1)
EndFunction

Function SetupNests()
  ;Debug.TraceAndBox("SetupNests() " +  SpawnedNests.Length,1)
  if SpawnedNests.Length < 2
    Int i = NestCount
    While i > 0
      SpawnedNests.add(Self.SpawnNest(), 1)
      Utility.wait(0.1)
      i -= 1 ; #DEBUG_LINE_NO:803
    EndWhile
  EndIf
EndFunction


Function HandleNestDistruction()
  ;Debug.TraceAndBox("HandleNestDistruction() Nestcount: " + SpawnedNests.Length ,1)
  Int i = SpawnedNests.Length - 1
  Bool foundtarget = False
  While i > 0
    if SpawnedNests[i].IsDisabled() == False
      ;Debug.TraceAndBox("Found Alive Nest" + i,1)
      Alias_PrimaryRef.ForceRefTo(SpawnedNests[i])
      foundtarget = True
    EndIf
    i -= 1 ; #DEBUG_LINE_NO:803
  EndWhile
  ;Debug.TraceAndBox("foundtarget:" + foundtarget,1)
  if foundtarget == False
    ;All dead
    ;Self.MissionComplete()
    Self.SetStage(95)
  EndIf
EndFunction


ObjectReference Function SpawnNest()
  ObjectReference ContainerRef = Alias_PrimaryRef.GetRef()
  ObjectReference replace = Game.FindRandomReferenceOfAnyTypeInList(replacelist,ContainerRef.GetPositionX(),ContainerRef.GetPositionY(),ContainerRef.GetPositionZ(),300)
  If replace == None
    ;Debug.TraceAndBox("SpawnNest() replace == None",1)
    Float[] placePosition = new Float[6]
    placePosition[0] = (Utility.RandomFloat(-100, 100))
    placePosition[1] = (Utility.RandomFloat(-100, 100))
    placePosition[2] = 0
    ;Place an npc, then place the nest on top of it. This makes it stick to the navmesh
    Actor Leech = ContainerRef.PlaceAtMe(Heatleech, 1, True, False, True, placePosition, None, True) as Actor
    ;Artifacts
    if Utility.RandomInt(0, 100) > 95
      Leech.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
    endif
    ObjectReference NestRef = Leech.PlaceAtMe(Nest, 1, True, False, True, None, None, True)
    return NestRef
  Else
    replace.Disable(false)
    ObjectReference NestRef = replace.PlaceAtMe(Nest, 1, True, False, True, None, None, True)
    Actor Leech =  NestRef.PlaceAtMe(Heatleech, 3, True, False, True, None, None, True) as Actor
    if Utility.RandomInt(0, 100) > 95
      Leech.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
    endif

    return NestRef
  EndIf
EndFunction