Scriptname dou_artifact_space_bountyrename_quest extends Quest

FormList Property artifactlist Auto Const mandatory
FormList Property GangMembers Auto Const mandatory
Int Property MinGangMembers Auto Const mandatory
Int Property MaxGangMembers Auto Const mandatory

ReferenceAlias property BountyTarget auto const mandatory

FormList Property NameList Auto Const mandatory

Int Property ForceHostile Auto Const mandatory
Form Property ShipFaction Auto Const mandatory

Int RunOnce


Event OnQuestStarted()
    Self.SetObjectiveDisplayed(10, True, False)
    ObjectReference enemyShip = BountyTarget.getRef()

    RunOnce = 1
    RegisterForRemoteEvent(BountyTarget.GetShipRef(), "OnCellLoad")
    RegisterForRemoteEvent(BountyTarget, "OnDeath")
    Parent.OnQuestStarted()
endEvent

Event ObjectReference.OnCellLoad(ObjectReference akSource)
  if RunOnce == 1
    RunOnce = 0
    ObjectReference enemyShip = BountyTarget.getRef()
    spaceshipreference enemyShipRef = enemyShip as spaceshipreference
    if ForceHostile > 0
      enemyShipRef.RemoveFromAllFactions()
      enemyShipRef.AddToFaction(ShipFaction as Faction)
    endif

    Message name = NameList.GetAt(Utility.RandomInt(0, NameList.GetSize() - 1)) As Message
    enemyShipRef.SetOverrideName(name)

    Int hostilenpcs = Utility.RandomInt(MinGangMembers, MaxGangMembers)
    ActorValue Suspicious = Game.GetFormFromFile(748, "Starfield.esm") as ActorValue;Suspicious [AVIF:000002EC]
    ActorValue Aggression = Game.GetFormFromFile(700, "Starfield.esm") as ActorValue;Aggression [AVIF:000002BC]
    bool artifactplaced = false
    While hostilenpcs > 0
      Float[] placePosition = new Float[6]
      placePosition[0] = (Utility.RandomFloat(-10, 10) * 250)
      placePosition[1] = (Utility.RandomFloat(-10, 10) * 250)
      placePosition[2] = (Utility.RandomFloat(-10, 10) * 200)

      spaceshipreference enemy = enemyShip.PlaceShipAtMe(GangMembers.GetAt(Utility.RandomInt(0, GangMembers.GetSize() - 1)), 1, False, False, False, True, placePosition, None, None, True)

      name = NameList.GetAt(Utility.RandomInt(0, NameList.GetSize() - 1)) As Message
      enemy.SetOverrideName(name)


      enemy.SetValue(Aggression, 1)
      enemy.SetForwardVelocity(0.5)

      if ForceHostile > 0
        enemy.RemoveFromAllFactions()
        enemy.AddToFaction(ShipFaction as Faction)
      endif

      ;Artifacts
      ;Target has 50% change of additional artifact
      if Utility.RandomInt(0, 100) > 50
        enemyShip.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
      endif

      if Utility.RandomInt(0, 100) > 75
        enemy.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
        artifactplaced = true
      endif
      ;We want one artifact per bounty
      ;if artifactplaced == false && hostilenpcs == 1
      ;  enemy.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
      ;  artifactplaced = true
      ;endif

      hostilenpcs -= 1 ; #DEBUG_LINE_NO:803
    EndWhile
  endif
EndEvent

Event ReferenceAlias.OnDeath(ReferenceAlias akSource, ObjectReference akKiller)
  Self.SetObjectiveCompleted(10, True)
  Self.SetStage(100)
  Parent.CompleteQuest()
EndEvent

Event OnQuestRejected()
  Self.SetObjectiveDisplayed(10, False, False)
  Self.Stop()
EndEvent