ScriptName duo_citydelivery_act_dropoff Extends ObjectReference
;-- Variables ---------------------------------------

;-- Properties --------------------------------------
Quest Property questobjective Auto Const mandatory
Form Property Cargo Auto
Int Property CargoAmount Auto Const mandatory
Message Property FailMessage Auto Const mandatory
Message Property SuccessMessage Auto Const mandatory
Message Property StartMessage Auto Const mandatory
Form Property ShipToSpawn Auto Const mandatory

;-- Functions ---------------------------------------

Event OnActivate(ObjectReference akActionRef)
  duo_citydelivery_qst kmyQuest = questobjective as duo_citydelivery_qst ; #DEBUG_LINE_NO:25
  Bool repaired = false
  Actor myPlayer = Game.GetPlayer()
  Cargo = kmyQuest.Cargo
  If myPlayer.GetItemCount(Cargo) >= CargoAmount
    myPlayer.RemoveItem(Cargo, CargoAmount, False, None)
    repaired = true
    Self.BlockActivation(True,True)
    questobjective.SetObjectiveCompleted(20, True)
    kmyQuest.MissionComplete()
    Self.Disable(False)  
  Else
    FailMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
  EndIf
EndEvent