ScriptName duo_missioninfestation_lists Extends MissionQuestScript

;-- Variables ---------------------------------------
;Form Property Nest Auto Const mandatory
Form Property Heatleech Auto

FormList Property GangMembers Auto Const mandatory
Int Property MinGangMembers Auto Const mandatory
Int Property MaxGangMembers Auto Const mandatory


Actor[] Property SpawnedCreatures Auto
;Int Property NestCount Auto Const mandatory
ReferenceAlias Property Alias_PrimaryRef Auto Const mandatory
FormList Property replacelist Auto Const mandatory
FormList Property artifactlist Auto Const mandatory
;-- Properties --------------------------------------
Group PlantEvidenceMissionData
  ReferenceAlias Property HoldingContainer Auto Const mandatory
  { alias where data disk ref will be created }
  ReferenceAlias Property Evidence Auto Const mandatory
  { evidence to plant }
  Float Property CooldownDays = 2.0 Auto Const
  { how long before the same target location can be picked again? }
  ActorValue Property CooldownAV Auto Const mandatory
  { AV to use for cooldown timestamp }
EndGroup

GlobalVariable Property RewardGlobal Auto Const mandatory
GlobalVariable Property RI_CreditsReward Auto mandatory
Int Property iCompletionStage Auto Const mandatory

int CONST_Aggression_VeryAggressive = 2 Const
int CONST_Suspicious_DetectedActor = 2 Const

bool countdowntimer = false

;-- Functions ---------------------------------------
Function MissionAccepted(Bool bAccepted)
  Heatleech = GangMembers.GetAt(Utility.RandomInt(0, GangMembers.GetSize() - 1))
  ObjectReference ContainerRef = Alias_PrimaryRef.GetRef()  
  Actor creature = ContainerRef.PlaceAtMe(Heatleech, 1, True, False, True, None, None, True) as Actor

  Alias_PrimaryRef.ForceRefTo(creature)
  RegisterForRemoteEvent(creature, "OnDeath")
  SpawnedCreatures = new Actor[0]
  SpawnedCreatures.add(creature, 1)

  Int hostilenpcs = Utility.RandomInt(MinGangMembers, MaxGangMembers)
  ActorValue Suspicious = Game.GetFormFromFile(748, "Starfield.esm") as ActorValue;Suspicious [AVIF:000002EC]
  ActorValue Aggression = Game.GetFormFromFile(700, "Starfield.esm") as ActorValue;Aggression [AVIF:000002BC]
  bool artifactplaced = false
  While hostilenpcs > 0
    Float[] placePosition = new Float[6]
    placePosition[0] = (Utility.RandomFloat(-40, 40))
    placePosition[1] = (Utility.RandomFloat(-40, 40))
    placePosition[2] = 0

    Actor enemy = creature.PlaceAtMe(Heatleech, 1, True, False, True, placePosition, None, True) as Actor
    enemy.SetValue(Suspicious, CONST_Suspicious_DetectedActor)
    enemy.SetValue(Aggression, CONST_Aggression_VeryAggressive)
    SpawnedCreatures.add(enemy, 1)
    ;Artifacts
    if Utility.RandomInt(0, 100) > 75
      enemy.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
    endif
    ;We want one artifact per bounty
    ;if artifactplaced == false && hostilenpcs == 1
    ;  enemy.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
    ;  artifactplaced = true
    ;endif

    hostilenpcs -= 1 ; #DEBUG_LINE_NO:803
  EndWhile
  Parent.MissionAccepted(bAccepted) ; #DEBUG_LINE_NO:23
EndFunction

Function HandleOnQuestRejected()
  Self.CleanupMission() ; #DEBUG_LINE_NO:28
  Self.MissionFailed() ; #DEBUG_LINE_NO:29
EndFunction

Function MissionComplete()
  Self.CleanupMission() ; #DEBUG_LINE_NO:33
  Parent.MissionComplete() ; #DEBUG_LINE_NO:34
EndFunction

Function CleanupMission()
  
EndFunction

Event OnQuestStarted()
  
  Parent.OnQuestStarted()
endEvent


Event Actor.OnDeath(Actor akSource, ObjectReference akKiller)
  bool alive = false
  int index = 0
  While (index < SpawnedCreatures.Length && alive == false)
    if SpawnedCreatures[index].IsDead() == false
      Alias_PrimaryRef.ForceRefTo(SpawnedCreatures[index])
      RegisterForRemoteEvent(Alias_PrimaryRef.getRef() As Actor, "OnDeath")
      alive = true
    endif
    index += 1
  EndWhile
  if countdowntimer == false
    ;There is a chance that we can't reach all targets. Add a pity timer
    StartTimer(180,1)
    countdowntimer = true
  endif
  if alive == false    
    Self.SetObjectiveCompleted(10, True)
    Self.SetStage(100)
    Parent.CompleteQuest()
  endif
EndEvent

Event OnTimer(int aiTimerID)
  Self.SetObjectiveCompleted(10, True)
  Self.SetStage(100)
  Parent.CompleteQuest()
EndEvent