ScriptName ccs_activaterepair Extends ObjectReference Const
;-- Variables ---------------------------------------

;-- Properties --------------------------------------
Quest Property questobjective Auto Const mandatory
Potion Property ShipRepairKit Auto Const mandatory
Message Property FailMessage Auto Const mandatory
Message Property SuccessMessage Auto Const mandatory
Message Property StartMessage Auto Const mandatory
Form Property ShipToSpawn Auto Const mandatory
FormList Property artifactlist Auto Const mandatory
FormList Property installationlist Auto Const mandatory

;-- Functions ---------------------------------------

Event OnLoad()
  Float[] placePosition = new Float[3] 
  placePosition[0] = Utility.RandomFloat(-30, 30) * 100
  placePosition[1] = Utility.RandomFloat(-7, 7) * 100
  placePosition[2] = Utility.RandomFloat(-30, 30) * 100
  self.PlaceAtMe(installationlist.GetAt(Utility.RandomInt(0, installationlist.GetSize() - 1)), 1, True, False, True, placePosition, None, True)
EndEvent

Event OnActivate(ObjectReference akActionRef)
  Bool repaired = false
  Actor myPlayer = Game.GetPlayer()
  spaceshipreference myShip = myPlayer.GetCurrentShipRef()
  If myPlayer.GetItemCount(ShipRepairKit as Form) >= 1
    myPlayer.RemoveItem(ShipRepairKit as Form, 1, False, None)
    repaired = true
  ElseIf myShip.GetItemCount(ShipRepairKit as Form) >= 1
    myShip.RemoveItem(ShipRepairKit as Form, 1, False, None)
    repaired = true
  EndIf
  If repaired == true
    Self.BlockActivation(True,True)
    StartMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
    ; Spawn attackers?
    if Utility.RandomInt(1, 10) > 5
      Utility.wait(Utility.RandomInt(2, 6))
      Int i = Utility.RandomInt(1, 3)
      While i > 0
        spaceshipreference playerShipRef = Game.GetPlayer().GetCurrentShipRef()
        Float[] placePosition = new Float[3] 
        placePosition[0] = Utility.RandomFloat(-3000, 3000)
        placePosition[1] = Utility.RandomFloat(-750, 750)
        placePosition[2] = Utility.RandomFloat(-3000, 3000)
        spaceshipreference myNewShip = playerShipRef.PlaceShipAtMe(ShipToSpawn, 4, True, False, False, True, placePosition, None, None, True)
        ;Artifacts
        if Utility.RandomInt(0, 100) > 50
          myNewShip.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
        endif
        i -= 1 ; #DEBUG_LINE_NO:803
      EndWhile
    EndIf
    Utility.wait(Utility.RandomInt(5, 15))
    questobjective.SetObjectiveCompleted(20, True)
    SuccessMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
    missionbountyspacescript kmyQuest = questobjective as missionbountyspacescript ; #DEBUG_LINE_NO:25
    kmyQuest.MissionComplete()
  Else
    FailMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
  EndIf
  ;Self.GetOwningQuest().SetStage(AllPowerBackOnStage)
EndEvent