ScriptName ccs_longdrive_qst Extends MissionQuestScript

;-- Variables ---------------------------------------
Form Property PickupActivator Auto Const mandatory
Form Property DropoffActivator Auto Const mandatory

Form Property Heatleech Auto Const mandatory
ObjectReference[] Property SpawnedNests Auto
Int Property NestCount Auto Const mandatory

ReferenceAlias Property Alias_PrimaryRef Auto Const mandatory
ReferenceAlias Property Alias_FinalRef Auto Const mandatory
FormList Property replacelist Auto Const mandatory

Form Property Cargo Auto

Quest Property HelperQuest Auto Const mandatory

ReferenceAlias Property ResourceName Auto Const
;-- Properties --------------------------------------
Group PlantEvidenceMissionData
  ReferenceAlias Property HoldingContainer Auto Const mandatory
  { alias where data disk ref will be created }
  ReferenceAlias Property Evidence Auto Const mandatory
  { evidence to plant }
  Float Property CooldownDays = 2.0 Auto Const
  { how long before the same target location can be picked again? }
  ActorValue Property CooldownAV Auto Const mandatory
  { AV to use for cooldown timestamp }
EndGroup

GlobalVariable Property RewardGlobal Auto Const mandatory
GlobalVariable Property RI_CreditsReward Auto mandatory
Int Property iCompletionStage Auto Const mandatory

int CONST_Aggression_VeryAggressive = 2 Const
int CONST_Suspicious_DetectedActor = 2 Const
;-- Functions ---------------------------------------

Event OnQuestStarted()
  Cargo = Evidence.getRef().getBaseObject()  
  ResourceName.ForceRefTo(Evidence.getRef())
  Parent.OnQuestStarted()
EndEvent

Function SetRewardValues()
  RI_CreditsReward.SetValue(RewardGlobal.GetValue()) ; #DEBUG_LINE_NO:43
EndFunction

Function AddFinalValues()
  RI_CreditsReward.SetValue(RewardGlobal.GetValue()) ; #DEBUG_LINE_NO:95
  Self.SetStage(iCompletionStage) ; #DEBUG_LINE_NO:100
EndFunction

;-- Functions ---------------------------------------

Function MissionAccepted(Bool bAccepted)
  Parent.MissionAccepted(bAccepted) ; #DEBUG_LINE_NO:23  
EndFunction

Function HandleOnQuestRejected()
  Self.CleanupMission() ; #DEBUG_LINE_NO:28
  Self.MissionFailed() ; #DEBUG_LINE_NO:29
EndFunction

Function MissionComplete()
  Self.SetStage(95)
  Self.CleanupMission() ; #DEBUG_LINE_NO:33
  Parent.MissionComplete() ; #DEBUG_LINE_NO:34
EndFunction

Function CleanupMission()
  ;PrimaryRef.GetRef().RemoveItem(Evidence.GetRef() as Form, 1, False, None) ; #DEBUG_LINE_NO:39
  ;Location targetLoc = TargetLocation.GetLocation() ; #DEBUG_LINE_NO:42
  ;targetLoc.SetValue(CooldownAV, Utility.GetCurrentGameTime() + CooldownDays) ; #DEBUG_LINE_NO:43
EndFunction

Function SetupMisson()
  ObjectReference PickupContainerRef = Alias_PrimaryRef.GetRef()  
  Alias_PrimaryRef.ForceRefTo(PickupContainerRef.PlaceAtMe(PickupActivator, 1, True, False, True, None, None, True))
  PickupContainerRef.Disable(False)
EndFunction

Function SetupDestination()
  HelperQuest.Start()
  locHelperQuest kmyQuest = HelperQuest as locHelperQuest

  kmyQuest.Refill()

  if kmyQuest.Alias_PrimaryRef == None
      Debug.TraceAndBox("kmyQuest.Alias_PrimaryRef == None", 1)
  endif

  ObjectReference DropoffContainerRef = kmyQuest.Alias_PrimaryRef.GetRef()
  ObjectReference placernpc = DropoffContainerRef.PlaceAtMe(GetEnemyForm(), 1, True, False, True, None, None, True)
  ObjectReference dropoff = placernpc.PlaceAtMe(DropoffActivator, 1, True, False, True, None, None, True)

  Alias_FinalRef.ForceRefTo(dropoff)
  DropoffContainerRef.Disable(False)
  SetObjectiveDisplayed(20,True,False)

EndFunction

Form Function GetEnemyForm()
  Int chance = Utility.RandomInt(0, 100)
  if chance > 1 && chance <= 33
    return Game.GetFormFromFile(68409, "Starfield.esm");LCharCrimsonFleet [LVLN:00010B39]
  ElseIf chance > 33 && chance <= 66
    return Game.GetFormFromFile(2603901, "Starfield.esm");LCharSpacer [LVLN:0027BB7D]
  Else
    return Game.GetFormFromFile(2556551, "Starfield.esm");LCharEcliptic [LVLN:00270287]
  EndIf
EndFunction
