Scriptname dou_artifact_ground_bounty_landingpadship_quest extends Quest

FormList Property artifactlist Auto Const mandatory
FormList Property GangMembers Auto Const mandatory
Int Property MinGangMembers Auto Const mandatory
Int Property MaxGangMembers Auto Const mandatory

int CONST_Aggression_VeryAggressive = 2 Const
int CONST_Suspicious_DetectedActor = 2 Const

ReferenceAlias property BountyTarget auto const mandatory

Form Property ShipForm Auto Const Mandatory


;Interior
int InteriorRunOnce
LocationAlias property EnemyShipInteriorLocation Auto Const Mandatory
ReferenceAlias property ShipTarget auto const mandatory
ReferenceAlias property LandingPadMarker auto const mandatory

RefCollectionAlias property CrewSpawnMarkers Auto Const Mandatory

spaceshipreference enemyShipRef


ObjectReference landingpad
ObjectReference support

Event OnQuestStarted()
    Self.SetObjectiveDisplayed(10, True, False)
    ObjectReference enemyActor = BountyTarget.getRef()
    RegisterForRemoteEvent(enemyActor As Actor, "OnDeath")

    Float[] padoffset = new Float[6]
    padoffset[0] = 0
    padoffset[1] = 0
    padoffset[2] = 5

    ;Place the landing pad here, we expect this place isn't good for landing.
    Form PavGenLandingPad80 = Game.GetFormFromFile(1604068, "Starfield.esm");PavGenLandingPad80 [STAT:001879E4]
    landingpad = LandingPadMarker.getRef().PlaceAtMe(PavGenLandingPad80, 1, False, False, True, padoffset, None, True)
    landingpad.SetScale(0.5)


    ;Place the landing marker here, this is what controlls the ship landing
    Furniture ShipLandingMarker_80m_Large = Game.GetFormFromFile(28997, "Starfield.esm") as Furniture;ShipLandingMarker_80m_Large [FURN:00007145]
    ObjectReference shipmarker = LandingPadMarker.getRef().PlaceAtMe(ShipLandingMarker_80m_Large, 1, False, False, True, padoffset, None, True)

    padoffset[2] = 4
    ;Support block
    Form PavGenDeckMid01 = Game.GetFormFromFile(2290284, "Starfield.esm");PavGenDeckMid01 [STAT:0022F26C]
    support = LandingPadMarker.getRef().PlaceAtMe(PavGenDeckMid01, 1, False, False, True, padoffset, None, True)
    support.SetScale(7)
    
    enemyActor.MoveTo(shipmarker,0,0,0,false,false)

    ;Spawn the ship on the landing marker
    enemyShipRef = shipmarker.PlaceShipAtMe(ShipForm, 4, true, false, false, true, none, None, None, true)
    enemyShipRef.SetExteriorLoadDoorInaccessible(False)
    ShipTarget.ForceRefTo(enemyShipRef)
    EnemyShipInteriorLocation.ClearAndRefillAlias()
    RegisterForRemoteEvent(Game.GetPlayer(), "OnLocationChange")
    CrewSpawnMarkers.RefillAlias()
    InteriorRunOnce = 1

    shipmarker.DisableNoWait(false)

    Int hostilenpcs = Utility.RandomInt(MinGangMembers, MaxGangMembers)
    ActorValue Suspicious = Game.GetFormFromFile(748, "Starfield.esm") as ActorValue;Suspicious [AVIF:000002EC]
    ActorValue Aggression = Game.GetFormFromFile(700, "Starfield.esm") as ActorValue;Aggression [AVIF:000002BC]
    bool artifactplaced = false
    bool boss = false
    While hostilenpcs > 0
      Float[] placePosition = new Float[6]
      placePosition[0] = (Utility.RandomFloat(-50, 50))
      placePosition[1] = (Utility.RandomFloat(-50, 50))
      placePosition[2] = 0

      Actor enemy = enemyActor.PlaceAtMe(GangMembers.GetAt(Utility.RandomInt(0, GangMembers.GetSize() - 1)), 1, True, False, True, placePosition, None, True) as Actor
      enemy.SetValue(Suspicious, CONST_Suspicious_DetectedActor)
      enemy.SetValue(Aggression, CONST_Aggression_VeryAggressive)

      ;Artifacts
      if Utility.RandomInt(0, 100) > 75
        enemy.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
      endif
      ;We want one artifact per bounty
      ;if artifactplaced == false && hostilenpcs == 1
      ;  enemy.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
      ;  artifactplaced = true
      ;endif

      hostilenpcs -= 1 ; #DEBUG_LINE_NO:803
    EndWhile
    Parent.OnQuestStarted()
endEvent

Event Actor.OnDeath(Actor akSource, ObjectReference akKiller)
    Self.SetObjectiveCompleted(10, True)
    Self.SetStage(100)
    ;We haven't boarded the ship, so the crew won't spawn. So just takeoff.
    if InteriorRunOnce == 1
      enemyShipRef.DisableWithTakeOffOrLandingNoWait()
    endIf
    Parent.CompleteQuest()
    ;Clean up the landing pad after a while. I'm worried about the map being littered with them.
    Utility.Wait(60)
    landingpad.DisableNoWait(false)
    support.DisableNoWait(false)
EndEvent

Event Actor.OnLocationChange(Actor akSource, Location akOldLoc, Location akNewLoc)
  Actor player = Game.GetPlayer()
  ActorValue Suspicious = Game.GetFormFromFile(748, "Starfield.esm") as ActorValue;Suspicious [AVIF:000002EC]
  ActorValue Aggression = Game.GetFormFromFile(700, "Starfield.esm") as ActorValue;Aggression [AVIF:000002BC]

	if (akSource == Game.GetPlayer())
		if (akNewLoc == EnemyShipInteriorLocation.GetLocation())
      if InteriorRunOnce == 1
        InteriorRunOnce = 0
            
        ;Self.SetObjectiveCompleted(10, True)
        ;Self.SetObjectiveDisplayed(20, True, False)
        ;Debug.TraceAndBox("akNewLoc == enemyShipInteriorLoc",1)
        
        bool artifactplaced = false

        ObjectReference[] allCrewSpawnPoints = CrewSpawnMarkers.GetArray()
        Int hostilenpcs = Utility.RandomInt(allCrewSpawnPoints.Length/2, allCrewSpawnPoints.Length)

        ;Artifacts

        While hostilenpcs > 0
          Actor enemy = allCrewSpawnPoints[Utility.RandomInt(0, allCrewSpawnPoints.Length)].PlaceAtMe(GangMembers.GetAt(Utility.RandomInt(0, GangMembers.GetSize() - 1)), 1, True, False, True, None, None, True) as Actor
          enemy.SetValue(Suspicious, CONST_Suspicious_DetectedActor)
          enemy.SetValue(Aggression, CONST_Aggression_VeryAggressive)

          ;Artifacts
          if Utility.RandomInt(0, 100) > 75
            enemy.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
          endif
          ;We want one artifact per bounty
          ;if artifactplaced == false && hostilenpcs == 1
          ;  enemy.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
          ;  artifactplaced = true
          ;endif
          hostilenpcs -= 1 ; #DEBUG_LINE_NO:803
        EndWhile
      endIf
    endIf
  endIf
endEvent

Event OnQuestRejected()
  Self.SetObjectiveDisplayed(10, False, False)
  Self.Stop()
EndEvent