Scriptname dou_artifact_ground_dualactivator_local_quest extends Quest

FormList Property artifactlist Auto Const mandatory
FormList Property GangMembers Auto Const mandatory
Int Property MinGangMembers Auto Const mandatory
Int Property MaxGangMembers Auto Const mandatory
Int Property HostileChance Auto Const mandatory

FormList Property SourceCivListMembers Auto Const mandatory
FormList Property TargetCivListMembers Auto Const mandatory

Form Property CargoObject Auto Const mandatory
Message Property FailMessage Auto Const mandatory

Int Property DisableAfterActivate Auto Const mandatory

int CONST_Aggression_VeryAggressive = 2 Const
int CONST_Suspicious_DetectedActor = 2 Const

ReferenceAlias property PrimaryActivatorTarget auto const mandatory
ReferenceAlias property SecondaryActivatorTarget auto const mandatory

Int MissionState

Event OnQuestStarted()
    Self.SetObjectiveDisplayed(10, True, False)
    ObjectReference Target = PrimaryActivatorTarget.getRef()
    RegisterForRemoteEvent(Target, "OnActivate")
    ; Spawn the civs
    Float[] placePosition = new Float[6]
    Int civnpcs = Utility.RandomInt(1, 5)
    While civnpcs > 0
      placePosition[0] = (Utility.RandomFloat(-25, 25))
      placePosition[1] = (Utility.RandomFloat(-25, 25))
      placePosition[2] = 0

      Actor civ = Target.PlaceAtMe(SourceCivListMembers.GetAt(Utility.RandomInt(0, SourceCivListMembers.GetSize() - 1)), 1, True, False, True, placePosition, None, True) as Actor
      civnpcs -= 1 ; #DEBUG_LINE_NO:803
    EndWhile  

    if Utility.RandomInt(0, 100) > HostileChance
      ;Hostile Presence
      Int hostilenpcs = Utility.RandomInt(MinGangMembers, MaxGangMembers)
      ActorValue Suspicious = Game.GetFormFromFile(748, "Starfield.esm") as ActorValue;Suspicious [AVIF:000002EC]
      ActorValue Aggression = Game.GetFormFromFile(700, "Starfield.esm") as ActorValue;Aggression [AVIF:000002BC]
      bool artifactplaced = false
      bool boss = false
      While hostilenpcs > 0
        placePosition[0] = (Utility.RandomFloat(-50, 50))
        placePosition[1] = (Utility.RandomFloat(-50, 50))
        placePosition[2] = 0

        Actor enemy = Target.PlaceAtMe(GangMembers.GetAt(Utility.RandomInt(0, GangMembers.GetSize() - 1)), 1, True, False, True, placePosition, None, True) as Actor
        enemy.SetValue(Suspicious, CONST_Suspicious_DetectedActor)
        enemy.SetValue(Aggression, CONST_Aggression_VeryAggressive)

        ;Artifacts
        if Utility.RandomInt(0, 100) > 75
          enemy.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
        endif
        ;We want one artifact per bounty
        ;if artifactplaced == false && hostilenpcs == 1
        ;  enemy.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
        ;  artifactplaced = true
        ;endif

        hostilenpcs -= 1 ; #DEBUG_LINE_NO:803
      EndWhile
    endif
    MissionState = 1
    Parent.OnQuestStarted()
endEvent

Event ObjectReference.OnActivate(ObjectReference akSender, ObjectReference akActionRef)
  ObjectReference player = Game.GetPlayer() as ObjectReference

  ;Second stage, this is first as we don't want to fall through
  if MissionState == 2
    If player.GetItemCount(CargoObject) >= 1
      player.RemoveItem(CargoObject, 1, False, None)
      ObjectReference NextTarget = SecondaryActivatorTarget.getRef()
      Self.SetObjectiveCompleted(20, True)
      Self.SetStage(100)
      Self.SetObjectiveDisplayed(20, True, False)
      Parent.CompleteQuest()
      MissionState = 3
    Else
      FailMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
    endIf
  endif

  ;First stage
  if MissionState == 1
    ObjectReference Target = PrimaryActivatorTarget.getRef()
    Target.BlockActivation(True,True)
    if DisableAfterActivate > 0
      Target.DisableNoWait(false)
    endif
    player.AddItem(CargoObject, 1, false)

    Self.SetObjectiveCompleted(10, True)
    Self.SetStage(50)
    Self.SetObjectiveDisplayed(20, True, False)
    ObjectReference NextTarget = SecondaryActivatorTarget.getRef()
    RegisterForRemoteEvent(NextTarget, "OnActivate")
    MissionState = 2
    ; Spawn the civs
    Float[] placePosition = new Float[6]
    Int civnpcs = Utility.RandomInt(1, 5)
    While civnpcs > 0
      placePosition[0] = (Utility.RandomFloat(-25, 25))
      placePosition[1] = (Utility.RandomFloat(-25, 25))
      placePosition[2] = 0

      Actor civ = NextTarget.PlaceAtMe(TargetCivListMembers.GetAt(Utility.RandomInt(0, TargetCivListMembers.GetSize() - 1)), 1, True, False, True, placePosition, None, True) as Actor
      civnpcs -= 1 ; #DEBUG_LINE_NO:803
    EndWhile
    ; Spawn the Artifact
    placePosition[0] = (Utility.RandomFloat(-1, 1))
    placePosition[1] = (Utility.RandomFloat(-1, 1))
    placePosition[2] = 5
    NextTarget.PlaceAtMe(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, True, False, True, placePosition, None, True)
  
  endif
EndEvent


Event OnQuestRejected()
  Self.SetObjectiveDisplayed(10, False, False)
  Self.Stop()
EndEvent