Scriptname dou_artifact_space_boardingrename_quest extends Quest

FormList Property artifactlist Auto Const mandatory
FormList Property GangMembers Auto Const mandatory
Int Property MinGangMembers Auto Const mandatory
Int Property MaxGangMembers Auto Const mandatory

FormList Property Boss Auto Const mandatory
FormList Property Crewmembers Auto Const mandatory
Form Property RecoverItem Auto Const mandatory

ReferenceAlias property BountyTarget auto const mandatory
ReferenceAlias property ShipBoss auto const mandatory
RefCollectionAlias property CrewSpawnMarkers Auto Const Mandatory

LocationAlias property EnemyShipInteriorLocation Auto Const Mandatory

FormList Property NameList Auto Const
FormList Property CrewmembersNameList Auto Const

Int Property ForceHostile Auto Const mandatory
Form Property ShipFaction Auto Const mandatory
Int Property ShipDisabled Auto Const mandatory

Int RunOnce
int InteriorRunOnce
int CONST_Aggression_VeryAggressive = 2 Const
int CONST_Suspicious_DetectedActor = 2 Const

Event OnQuestStarted()
    Self.SetObjectiveDisplayed(10, True, False)
    ObjectReference enemyShip = BountyTarget.getRef()

    RunOnce = 1
    InteriorRunOnce = 1
    RegisterForRemoteEvent(BountyTarget.GetShipRef(), "OnCellLoad")

    RegisterForRemoteEvent(Game.GetPlayer(), "OnLocationChange")

    RegisterForRemoteEvent(BountyTarget, "OnDeath")
    Parent.OnQuestStarted()
endEvent

Event ObjectReference.OnActivate(ObjectReference akSender, ObjectReference akActionRef)
  ObjectReference Target = ShipBoss.getRef()
  Target.BlockActivation(True,True)
  Target.DisableNoWait(false)
  Self.SetObjectiveCompleted(10, True)
  Self.SetStage(100)
  Parent.CompleteQuest()
EndEvent


Event Actor.OnLocationChange(Actor akSource, Location akOldLoc, Location akNewLoc)
  Actor player = Game.GetPlayer()
  ActorValue Suspicious = Game.GetFormFromFile(748, "Starfield.esm") as ActorValue;Suspicious [AVIF:000002EC]
  ActorValue Aggression = Game.GetFormFromFile(700, "Starfield.esm") as ActorValue;Aggression [AVIF:000002BC]

	if (akSource == Game.GetPlayer())
		if (akNewLoc == EnemyShipInteriorLocation.GetLocation())
      if InteriorRunOnce == 1
        InteriorRunOnce = 0
            
        if ShipDisabled == 1
          int gravstatus = Utility.RandomInt(0, 100)
          Cell currentCell = Game.GetPlayer().getParentCell()
          if gravstatus < 33
            currentCell.setGravityScale(0)
          elseif gravstatus < 66
            currentCell.setGravityScale(Utility.RandomFloat(0, 0.75))
          else
            currentCell.setGravityScale(1)        
          endIf
          ;LightKiller

        endIf

        Self.SetObjectiveCompleted(10, True)
        Self.SetObjectiveDisplayed(20, True, False)
        ;Debug.TraceAndBox("akNewLoc == enemyShipInteriorLoc",1)
        
        bool artifactplaced = false

        ObjectReference[] allCrewSpawnPoints = CrewSpawnMarkers.GetArray()
        Int hostilenpcs = Utility.RandomInt(allCrewSpawnPoints.Length/2, allCrewSpawnPoints.Length)
        ObjectReference itemtorecover = allCrewSpawnPoints[Utility.RandomInt(0, allCrewSpawnPoints.Length)].PlaceAtMe(RecoverItem, 1, True, False, True, None, None, True)

        if itemtorecover == none
          ;We've failed to place the objective. Complete the quest as they've boarded already.
          Debug.TraceAndBox("You grab the nearby dataslate",1)
          Self.SetObjectiveCompleted(10, True)
          Self.SetStage(100)
          Parent.CompleteQuest()
        endIf
        ;Artifacts
        ;enemy.AddItem(RecoverItem, 1, False)
        ShipBoss.ForceRefTo(itemtorecover)
        RegisterForRemoteEvent(itemtorecover, "OnActivate")
        
        While hostilenpcs > 0
          ;placePosition[0] = (Utility.RandomFloat(-50, 50))
          ;placePosition[1] = (Utility.RandomFloat(-50, 50))
          ;placePosition[2] = 0
    
          Actor enemy = allCrewSpawnPoints[Utility.RandomInt(0, allCrewSpawnPoints.Length)].PlaceAtMe(Crewmembers.GetAt(Utility.RandomInt(0, Crewmembers.GetSize() - 1)), 1, True, False, True, None, None, True) as Actor
          enemy.SetValue(Suspicious, CONST_Suspicious_DetectedActor)
          enemy.SetValue(Aggression, CONST_Aggression_VeryAggressive)

          if CrewmembersNameList != none
            Message name = CrewmembersNameList.GetAt(Utility.RandomInt(0, CrewmembersNameList.GetSize() - 1)) As Message
            enemy.SetOverrideName(name)
          endIf

          ;Artifacts
          if Utility.RandomInt(0, 100) > 75
            enemy.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
          endif
          ;We want one artifact per bounty
          ;if artifactplaced == false && hostilenpcs == 1
          ;  enemy.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
          ;  artifactplaced = true
          ;endif
          hostilenpcs -= 1 ; #DEBUG_LINE_NO:803
        EndWhile

        ;Fallback ref set
        ;Sometimes it wouldn't set the ref, think it might be busy doing other things. Wait a while then set.
        Utility.Wait(10)
        ShipBoss.ForceRefTo(itemtorecover)
      endIf
    endIf
  endIf
endEvent


Event ObjectReference.OnCellLoad(ObjectReference akSource)
  if RunOnce == 1
    RunOnce = 0
    ObjectReference enemyShip = BountyTarget.getRef()
    spaceshipreference enemyShipRef = enemyShip as spaceshipreference

    if ShipDisabled == 1
      ActorValue ShipSystemEngineHealth = Game.GetFormFromFile(2027725, "Starfield.esm") as ActorValue
      ActorValue ShipSystemWeaponGroup1Health = Game.GetFormFromFile(931, "Starfield.esm") as ActorValue
      ActorValue ShipSystemWeaponGroup2Health = Game.GetFormFromFile(932, "Starfield.esm") as ActorValue
      ActorValue ShipSystemWeaponGroup3Health = Game.GetFormFromFile(933, "Starfield.esm") as ActorValue
      ActorValue ShipSystemShieldsHealth = Game.GetFormFromFile(2025673, "Starfield.esm") as ActorValue
      ActorValue ShipSystemGravDriveHealth = Game.GetFormFromFile(2027723, "Starfield.esm") as ActorValue
      ActorValue SpaceshipCrew = Game.GetFormFromFile(265440, "Starfield.esm") as ActorValue
      ActorValue SpaceshipExternalLightsDisabledValue = Game.GetFormFromFile(1723657, "Starfield.esm") as ActorValue
      
      enemyShipRef.DamageValue(ShipSystemEngineHealth, enemyShipRef.GetValue(ShipSystemEngineHealth))
      enemyShipRef.EnablePartRepair(ShipSystemEngineHealth, False)
    
      enemyShipRef.DamageValue(ShipSystemWeaponGroup1Health, enemyShipRef.GetValue(ShipSystemWeaponGroup1Health))
      enemyShipRef.EnablePartRepair(ShipSystemWeaponGroup1Health, False)
    
      enemyShipRef.DamageValue(ShipSystemWeaponGroup2Health, enemyShipRef.GetValue(ShipSystemWeaponGroup2Health))
      enemyShipRef.EnablePartRepair(ShipSystemWeaponGroup2Health, False)
    
      enemyShipRef.DamageValue(ShipSystemWeaponGroup3Health, enemyShipRef.GetValue(ShipSystemWeaponGroup3Health))
      enemyShipRef.EnablePartRepair(ShipSystemWeaponGroup3Health, False)
    
      enemyShipRef.DamageValue(ShipSystemShieldsHealth, enemyShipRef.GetValue(ShipSystemShieldsHealth))
      enemyShipRef.EnablePartRepair(ShipSystemShieldsHealth, False)
    
      enemyShipRef.DamageValue(ShipSystemGravDriveHealth, enemyShipRef.GetValue(ShipSystemGravDriveHealth))
      enemyShipRef.EnablePartRepair(ShipSystemGravDriveHealth, False)

      enemyShipRef.EnablePartRepair(None, False)

      enemyShipRef.SetValue(SpaceshipExternalLightsDisabledValue, 1)
    endif

    if ForceHostile > 0
      enemyShipRef.RemoveFromAllFactions()
      enemyShipRef.AddToFaction(ShipFaction as Faction)
    endif

    if NameList != none
      Message name = NameList.GetAt(Utility.RandomInt(0, NameList.GetSize() - 1)) As Message
      enemyShipRef.SetOverrideName(name)
    endIf

    Int hostilenpcs = Utility.RandomInt(MinGangMembers, MaxGangMembers)
    ActorValue Suspicious = Game.GetFormFromFile(748, "Starfield.esm") as ActorValue;Suspicious [AVIF:000002EC]
    ActorValue Aggression = Game.GetFormFromFile(700, "Starfield.esm") as ActorValue;Aggression [AVIF:000002BC]
    bool artifactplaced = false
    While hostilenpcs > 0
      Float[] placePosition = new Float[6]
      placePosition[0] = (Utility.RandomFloat(-10, 10) * 250)
      placePosition[1] = (Utility.RandomFloat(-10, 10) * 250)
      placePosition[2] = (Utility.RandomFloat(-10, 10) * 200)

      spaceshipreference enemy = enemyShip.PlaceShipAtMe(GangMembers.GetAt(Utility.RandomInt(0, GangMembers.GetSize() - 1)), 1, False, False, False, True, placePosition, None, None, True)

      if NameList != none
        enemy.SetOverrideName(NameList.GetAt(Utility.RandomInt(0, NameList.GetSize() - 1)) As Message)
      endIf

      enemy.SetValue(Aggression, 1)
      enemy.SetForwardVelocity(0.5)

      if ForceHostile > 0
        enemy.RemoveFromAllFactions()
        enemy.AddToFaction(ShipFaction as Faction)
      endif

      ;Artifacts
      ;Target has 50% change of additional artifact
      if Utility.RandomInt(0, 100) > 50
        enemyShip.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
      endif

      if Utility.RandomInt(0, 100) > 75
        enemy.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
        artifactplaced = true
      endif
      ;We want one artifact per bounty
      ;if artifactplaced == false && hostilenpcs == 1
      ;  enemy.AddItem(artifactlist.GetAt(Utility.RandomInt(0, artifactlist.GetSize() - 1)), 1, False)
      ;  artifactplaced = true
      ;endif

      hostilenpcs -= 1 ; #DEBUG_LINE_NO:803
    EndWhile
  endif
EndEvent

Event ReferenceAlias.OnDeath(ReferenceAlias akSource, ObjectReference akKiller)
  Self.SetObjectiveFailed(10, True)
  Self.Stop()
;  Self.SetStage(100)
;  Parent.CompleteQuest()
EndEvent

Event OnQuestRejected()
  Self.SetObjectiveDisplayed(10, False, False)
  Self.Stop()
EndEvent