Scriptname GSN:Objects:Container_World extends GSN:Objects:Container

GSN:VendorManager Property GSN_VendorManager Auto Const Mandatory
Keyword Property GSN_KW_HasVendor Mandatory Auto

; For some reason the vanilla IDCardReader triggers multiple lockStateChanged events
; ensure container can only be added once
Bool UnlockedOnce = false

Function HandleOnload()
    GSN_StorageManager.TrackContainer(Self)

    If HasKeyword(GSN_KW_HasVendor)
        GSN_VendorManager.SetupVendor(Self)
    EndIf

    ; If the container ref has changed, check if player has used this key before and unlock
    If GSN_StorageManager.CheckKey(Self.GetKey()) && Self.IsLocked()
        Self.UnlockContainer()
    EndIf
EndFunction

Function HandleOnUnload()
    If HasKeyword(GSN_KW_HasVendor)
        GSN_VendorManager.ResetVendor()
    EndIf
EndFunction

Function HandleLockStateChanged()    
    If !IsLocked() && !UnlockedOnce
        UnlockedOnce = true
        GSN_StorageManager.AddContainer(Self)
        SetValue(CarryWeight, GSN_StorageManager.GetCarryWeight())
    EndIf
EndFunction