Scriptname ManualWeaponStance:QuestScript extends Quest
{
Author: Fallen01135
Version: 1.00
Description: This script lets the player toggle between a lowered and raised weapon stance
}


;===================================================================================================
;IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII Properties IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII
;===================================================================================================

; ============================== Editable ============================== ;

; ============================== Scripts =============================== ;

; ============================= Structures ============================= ;

; ============================== Autofill ============================== ;
Action Property ActionGunDown Auto
Action Property ActionGunReady Auto
Action Property ActionGunRelaxed Auto

; Condition Forms, so we can check for things we cannot access in Papyrus
ConditionForm Property pFTAMWSFirstPerson Auto
ConditionForm Property pFTAMWSGunStateLowered3rd Auto
ConditionForm Property pFTAMWSGunStateRaised1st Auto
ConditionForm Property pFTAMWSGunStateLowered1st Auto


;===================================================================================================
;IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII Variables IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII
;===================================================================================================

; ============================== Public =============================== ;
; Key code of the key to press
int Property iKeyCode = 88 Auto

; ============================== Private ============================== ;


;===================================================================================================
;IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII Events IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII
;===================================================================================================

event OnQuestInit()
	Utility.Wait(1.0000)

	RegisterForRemoteEvent(Game.GetPlayer(), "OnPlayerLoadGame")
	DoStuff()
endEvent

event Actor.OnPlayerLoadGame(Actor akActor)
	DoStuff()
endEvent

function BSInputEvent(Int aiKeyCode, String asControlName, String asFriendlyName, bool bPressed, Float afHeldTime) Global
	; Dirty check to prevent the script from executing when we are in a menu or an unvalid key is pressed
	; This will change if I find a better mod that has an actual good implementation for input events, as this one sucks hard...
	; This batch of checks look confusing, but all of them are simple quick checks.
	; Not all of them are fired all the time, so it is not as bad as it looks. Checks are only fired until we have at least one valid one. Then the rest are ignored.
	if (!bPressed || afHeldTime > 0.1 || (bPressed && afHeldTime > 0.1) || asControlName == "Forward" || asControlName == "Back" || asControlName == "StrafeLeft" || asControlName == "StrafeRight" || asControlName == "Jump" || asControlName == "Activate" || asControlName == "PrimaryAttack" || asControlName == "SecondaryAttack" || asControlName == "TogglePOV" || asControlName == "Pause" || asControlName == "WeaponReadyReload" || asControlName == "StarbornPower" || asControlName == "QuickSkills" || asControlName == "Monocle" || asControlName == "AltAttack" || asControlName == "QuickShip" || asControlName == "QuickPowers" || asControlName == "QuickMission" || asControlName == "Console" || asControlName == "Melee" || asControlName == "QuickMap" || asControlName == "Sneak" || asControlName == "Sprint" || asControlName == "ToggleAlwaysRun" || asControlName == "QuickInventory" || asControlName == "DataMenu" || Utility.IsGameMenuPaused())
		return
	endIf

	; Here we check if the player has a weapon drawn
	Actor Player = Game.GetPlayer()
	if (!Player.IsWeaponDrawn())
		return
	endIf

	; This is a stupid thing i have done as the implementation of this input "event" sucks... Normally we want to avoid using "GetFormFromFile" as it is slow and not very efficient, but in this case we have no other choice as we need to retrieve the key code from the Quest Script, as we are in a Global environment (which is a extremely bad implementation)
	; We do not want to retrieve this property all the time, so we use simple and easy checks before we do it
	ManualWeaponStance:QuestScript myQuest = (Game.GetFormFromFile(0x807, "ManualWeaponStance.esm") as Quest) as ManualWeaponStance:QuestScript
	; Check if the correct key is pressed
	if (aiKeyCode == myQuest.iKeyCode)
		if (myQuest.pFTAMWSFirstPerson.IsTrue(Player, None))
			if (myQuest.pFTAMWSGunStateRaised1st.IsTrue(Player, None))
				Player.PlayIdleAction(myQuest.ActionGunDown, None)
			elseIf (myQuest.pFTAMWSGunStateLowered1st.IsTrue(Player, None))
				Debug.ExecuteConsole("14.SendAnimEvent GunDownStop")
			endIf
		else
			if (myQuest.pFTAMWSGunStateLowered3rd.IsTrue(Player, None))
				Player.PlayIdleAction(myQuest.ActionGunReady, None)
			else
				Player.PlayIdleAction(myQuest.ActionGunRelaxed, None)
			endIf
		endIf
	endIf
endFunction


;===================================================================================================
;IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII States IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII
;===================================================================================================

;===================================================================================================
;IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII Functions IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII
;===================================================================================================

function DoStuff()
	; Register for the input event
	CassiopeiaPapyrusExtender.RegisterForNativeEvent("ManualWeaponStance:QuestScript", "BSInputEvent")
	; Gets and sets the key code from the INI file
	setKey()
endFunction

function setKey()
	String sKeyCodeLocal = CassiopeiaPapyrusExtender.ReadIni(".\\Data\\SFSE\\ManualWeaponStance\\", "Settings", "Hotkey", "iKeyCode")

	if (sKeyCodeLocal as int)
		iKeyCode = sKeyCodeLocal as int
	endIf
endFunction