Scriptname SMIN:Object:Activator extends ObjectReference

SMIN:Main Property Main Auto Const Mandatory
ReferenceAlias Property SMIN_ContainerAlias Mandatory Const Auto
Potion Property SMIN_SyncInventory_Potion Mandatory Const Auto
ReferenceAlias Property SMIN_SyncInventory_PotionAlias Auto Const Mandatory

Group Globals
    GlobalVariable Property SMIN_GLOB_WeaponTracker Auto Const Mandatory
    GlobalVariable Property SMIN_GLOB_SyncResources Auto Const Mandatory
EndGroup

Group Messages
    Message Property SMIN_Message_Menu Mandatory Const Auto
    Message Property SMIN_Message_Tutorial Mandatory Const Auto
    Message Property SMIN_Message_SyncDevice Mandatory Const Auto
    Message Property SMIN_Message_WeaponTracker Mandatory Const Auto
    Message Property SMIN_Message_SyncResources Mandatory Const Auto
EndGroup

Event OnWorkshopObjectPlaced(ObjectReference akReference)
    Utility.Wait(1)
EndEvent

Event OnLoad()
    BlockActivation(false, false)
EndEvent

Event OnActivate(ObjectReference akActionRef)
    BlockActivation(true, true)
    Main.ShowContainer()
    Utility.wait(0.25)
    BlockActivation(false, false)
EndEvent

Function ShowMessage_Menu()
    BlockActivation(true, true)
    Int Response = SMIN_Message_Menu.Show()
    If Response == 0
        SMIN_Message_Tutorial.Show()
        ShowMessage_Menu()
    ElseIf Response == 1
        SMIN_Message_SyncDevice.Show()
        ShowMessage_Menu()
    ElseIf Response == 2 || Response == 3
        ShowMessage_WeaponTracker()
        ShowMessage_Menu()
    ElseIf Response == 4 || Response == 5
        ShowMessage_SyncResources()
        ShowMessage_Menu()
    EndIf
    BlockActivation(false, false)
    SMIN_Utils.AddItemAndFillAlias(Game.GetPlayer(), SMIN_SyncInventory_Potion, SMIN_SyncInventory_PotionAlias, false)
EndFunction

Function ShowMessage_WeaponTracker()
    Int Response = SMIN_Message_WeaponTracker.Show()
    If Response == 0
        SMIN_GLOB_WeaponTracker.SetValueInt(1)
    ElseIf Response == 1
        SMIN_GLOB_WeaponTracker.SetValueInt(0)
    EndIf
EndFunction

Function ShowMessage_SyncResources()
    Int Response = SMIN_Message_SyncResources.Show()
    If Response == 0
        SMIN_GLOB_SyncResources.SetValueInt(1)
    ElseIf Response == 1
        SMIN_GLOB_SyncResources.SetValueInt(0)
    EndIf
EndFunction