Scriptname SMIN:Main extends Quest

Group Ship
    ReferenceAlias Property HomeShip Auto Mandatory Const
EndGroup

Group Conditions
    GameplayOption Property SMIN_GPO_Mod Auto Const Mandatory
    GlobalVariable Property SMIN_GLOB_Mod Auto Const Mandatory
    GlobalVariable Property SMIN_GLOB_WeaponTracker Auto Const Mandatory
    GlobalVariable Property SMIN_GLOB_SyncResources Auto Const Mandatory
    ConditionForm Property SMIN_CNDF_ShipIsInRange Auto Const Mandatory
    ConditionForm Property PEO_CargoAccess_Distance Auto Const Mandatory
    Keyword Property SpaceshipLinkedInterior Auto Const Mandatory
EndGroup

Group Things
    Spell Property SMIN_CarryLimit_Spell Auto Const Mandatory
    Spell Property SMIN_WeaponTracker_Spell Auto Const Mandatory
    Spell Property SMIN_RemoveItems_Spell Auto Const Mandatory
    Perk Property SMIN_Activator_Perk Mandatory Const Auto
    Potion Property SMIN_SyncInventory_Potion Auto Const Mandatory
    ReferenceAlias Property SMIN_SyncInventory_PotionAlias Auto Const Mandatory
    ReferenceAlias Property SMIN_ContainerAlias Mandatory Const Auto
EndGroup

Actor Player
SpaceshipReference Ship

Bool Property ModRunning Auto Hidden

CustomEvent OnSyncInventory
CustomEvent OnSetCarryLimit
CustomEvent OnSetIgnoreSync

Int RegisteredEffects
Int SyncedEffects

Bool Function OptionChanged(GameplayOption[] aChangedOptions)
    If aChangedOptions.find(SMIN_GPO_Mod) >= 0
        Return true
    EndIf
    Return false
EndFunction

Event OnGameplayOptionChanged(GameplayOption[] aChangedOptions)
    If OptionChanged(aChangedOptions)
        If SMIN_GPO_Mod.GetValue() > 0
            If !ModRunning
                StartMod()
                ModRunning = true
            EndIf
        ElseIf ModRunning
            StopMod()
            ModRunning = false
        EndIf
    EndIf
EndEvent

Event OnInit()  
    RegisterForGameplayOptionChangedEvent()
    If SMIN_GPO_Mod.GetValue() > 0
        StartMod()
        ModRunning = true
    EndIf
EndEvent

Function StartMod()
    Utility.Wait(1)
    Player = Game.GetPlayer()
    Ship = HomeShip.GetRef() as SpaceShipReference
    RegisterForRemoteEvent(Player, "OnHomeShipSet")
    AddSpells(true)
    (SMIN_ContainerAlias.GetRef() as SMIN:Object:Container).Init()
    SMIN_GLOB_Mod.SetValue(1)
    Debug.Notification("Smart Inventory enabled.")
EndFunction

Function StopMod()
    AddSpells(false)
    UnregisterForRemoteEvent(Player, "OnHomeShipSet")
    RegisteredEffects = 0
    SyncedEffects = 0
    Player = None
    Ship = None
    Utility.Wait(1)
    SMIN_GLOB_Mod.SetValue(0)
    SMIN_Glob_WeaponTracker.SetValue(0)
    SMIN_Glob_SyncResources.SetValue(0)
    Debug.Notification("Smart Inventory disabled.")
EndFunction

Function AddSpells(Bool bAdd)
    If bAdd
        SMIN_Utils.CheckAndAddSpell(Player, SMIN_CarryLimit_Spell)
        SMIN_Utils.CheckAndAddSpell(Player, SMIN_RemoveItems_Spell)
        SMIN_Utils.CheckAndAddSpell(Player, SMIN_WeaponTracker_Spell)
        SMIN_Utils.CheckAndAddPerk(Player, SMIN_Activator_Perk)
    Else
        SMIN_Utils.CheckAndRemoveSpell(Player, SMIN_CarryLimit_Spell)
        SMIN_Utils.CheckAndRemoveSpell(Player, SMIN_WeaponTracker_Spell)
        SMIN_Utils.CheckAndRemoveSpell(Player, SMIN_RemoveItems_Spell)
        SMIN_Utils.CheckAndRemovePerk(Player, SMIN_Activator_Perk)
        SMIN_Utils.RemoveItemAndClearAlias(Player, SMIN_SyncInventory_Potion, SMIN_SyncInventory_PotionAlias, false)
    EndIf
EndFunction

Event Actor.OnHomeShipSet(Actor acSender, SpaceshipReference akShip, SpaceshipReference akPrevious)
    Ship = akShip
EndEvent

SpaceshipReference Function GetShip()
    Return Ship
EndFunction

Bool Function ShipHasSpace()
    float CargoSpaceTotal = Ship.GetShipMaxCargoWeight()
	float CargoSpaceUsed = Ship.GetWeightInContainer()
	float CargoSpace = CargoSpaceTotal - CargoSpaceUsed
    If cargoSpace > 0
        Return true
    Else
        Return false
    EndIf
EndFunction

Bool Function ShipIsInRange()
    Return CheckDocked() || SMIN_CNDF_ShipIsInRange.IsTrue()
EndFunction

Bool Function CheckDocked()
    Return Ship.IsDocked() && Ship.GetFirstDockedShip().GetLinkedCell(SpaceshipLinkedInterior) == Player.GetParentCell()
EndFunction

Bool Function CanSync(Bool bNotify = false)
    String Text
    If ModRunning
        If Player.GetCombatState() > 0
           Text = "Cannot sync during combat!"
        ElseIf !ShipIsInRange()
            Text = "Ship out of range."
        ElseIf !ShipHasSpace()
            Text = "Cargo hold full."
        Else    
            Return true
        EndIf
    EndIf
     
    If bNotify && Text
        Debug.Notification(Text)
    EndIf

    return false
EndFunction

Function SyncInventory()
    If CanSync(true)
        Debug.Notification("Synchronizing...")
        SendCustomEvent("OnSyncInventory")
    EndIf
EndFunction

Function SetCarryLimit(Form Item, Int Carrylimit)
    Var[] Args = New Var[2]
    Args[0] = Item
    Args[1] = CarryLimit
    SendCustomEvent("OnSetCarryLimit", Args)
EndFunction

Function SetIgnoreSync(Form Item, Bool bIgnore)
    Var[] Args = New Var[2]
    Args[0] = Item
    Args[1] = bIgnore
    SendCustomEvent("OnSetIgnoreSync", Args)
EndFunction

Function RemoveItemFromPlayer(Form Item, Int Count, ObjectReference ItemSource = None, Bool bSilent = false)
    ObjectReference Destination
    If CanSync() && ShipHasSpace()
        Destination = Ship
    ElseIf ItemSource
        Destination = ItemSource
    EndIf

    If Destination
        Player.RemoveItem(Item, Count, bSilent, Destination)
    Else
        Player.DropObject(Item, Count)
    EndIf
EndFunction

Function AddItemToPlayer(Form Item, Int Count, Bool bSilent)
    If CanSync()
        Ship.RemoveItem(Item, Count, bSilent, Player)
    EndIf
EndFunction

Function ShowContainer()
    If CanSync()
        SMIN_ContainerAlias.GetRef().Activate(Player)
    EndIf
EndFunction

Function RegisterEffect(ActiveMagicEffect TheEffect, Bool bRegister)
    If bRegister
        If TheEffect as SMIN:Effect:CarryLimit
            RegisterForCustomEvent(TheEffect as SMIN:Effect:CarryLimit, "OnSyncComplete")
        ElseIf TheEffect as SMIN:Effect:RemoveItems
            RegisterForCustomEvent(TheEffect as SMIN:Effect:RemoveItems, "OnSyncComplete")
        ElseIf TheEffect as SMIN:Effect:WeaponTracker
            RegisterForCustomEvent(TheEffect as SMIN:Effect:WeaponTracker, "OnSyncComplete")
        EndIf
        RegisteredEffects += 1
    Else
        If TheEffect as SMIN:Effect:CarryLimit
            UnregisterForCustomEvent(TheEffect as SMIN:Effect:CarryLimit, "OnSyncComplete")
        ElseIf TheEffect as SMIN:Effect:RemoveItems
            UnregisterForCustomEvent(TheEffect as SMIN:Effect:RemoveItems, "OnSyncComplete")
        ElseIf TheEffect as SMIN:Effect:WeaponTracker
            UnregisterForCustomEvent(TheEffect as SMIN:Effect:WeaponTracker, "OnSyncComplete")
        EndIf

        If RegisteredEffects > 0
            RegisteredEffects -= 1
        EndIf
    EndIf
EndFunction

Event SMIN:Effect:CarryLimit.OnSyncComplete(SMIN:Effect:CarryLimit TheEffect, Var[] Args)
    OnSyncComplete()
EndEvent

Event SMIN:Effect:RemoveItems.OnSyncComplete(SMIN:Effect:RemoveItems TheEffect, Var[] Args)
    OnSyncComplete()
EndEvent

Event SMIN:Effect:WeaponTracker.OnSyncComplete(SMIN:Effect:WeaponTracker TheEffect, Var[] Args)
    OnSyncComplete()
EndEvent

Function OnSyncComplete()
    SyncedEffects += 1
    If SyncedEffects == RegisteredEffects
        Debug.Notification("Inventory synchronized.")
        SyncedEffects = 0
    EndIf
EndFunction