Scriptname SMIN:Effect:RemoveItems extends ActiveMagicEffect

SMIN:Main Property Main Auto Const Mandatory
FormList Property ItemList Auto Const Mandatory
GlobalVariable Property SMIN_Glob_SyncResources Mandatory Const Auto

Actor Player
Form[] ItemArray

CustomEvent OnSyncComplete

Event OnEffectStart(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, float afMagnitude, float afDuration)
    Utility.Wait(0.25)
    Player = akTarget as Actor
    AddInventoryEventFilter(ItemList)
    ItemArray = SMIN_Utils.ImportFormlist(ItemList)
    RegisterForCustomEvent(Main, "OnSyncInventory")
    Main.RegisterEffect(Self, true)
    Debug.Notification("Sync resources - ON")
EndEvent

Event OnEffectFinish(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, float afMagnitude, float afDuration)
    Utility.Wait(0.25)
    Player = None
    RemoveInventoryEventFilter(ItemList)
    ItemArray = None
    UnregisterForCustomEvent(Main, "OnSyncInventory")
    Main.RegisterEffect(Self, false)
    If SMIN_Glob_SyncResources.GetValueInt() == 0
        Debug.Notification("Sync resources - OFF")
    EndIf
EndEvent

Event SMIN:Main.OnSyncInventory(SMIN:Main Sender, Var[] Args)
    RemoveAll()
    SendCustomEvent("OnSyncComplete")
EndEvent

Function RemoveAll()
    Int i = 0
    While i < ItemArray.length
        RemoveItem(ItemArray[i])  
        i += 1
    EndWhile
EndFunction

Function RemoveItem(Form TheItem)
    Int Count = Player.GetItemCount(TheItem)
    If Count > 0
        Main.RemoveItemFromPlayer(TheItem, Count, None, true)
    EndIf
EndFunction