Scriptname SMIN:Object:Container extends ObjectReference

SMIN:Main Property Main Auto Const Mandatory
FormList Property SMIN_Items_All Auto Const Mandatory

Function Init()
    AddInventoryEventFilter(SMIN_Items_All)
EndFunction

; Increase the carry limit by aiItemCount
Event OnItemAdded(Form akBaseItem, int aiItemCount, ObjectReference akItemReference, ObjectReference akSourceContainer, int aiTransferReason)
    Int CarryLimit = Self.GetItemCount(akBaseItem)
    Main.SetCarryLimit(akBaseItem, CarryLimit)
    akSourceContainer.addItem(akBaseItem, aiItemCount, true) ; refund player

    ; replenish up to the player's new carry limit from the ship
    Int PlayerCount = akSourceContainer.GetItemCount(akBaseItem)
    If PlayerCount < CarryLimit
        Main.GetShip().RemoveItem(akBaseItem, CarryLimit - PlayerCount, true, akSourceContainer)
    EndIf
EndEvent

; Decrease the carry limit by aiItemCount
Event OnItemRemoved(Form akBaseItem, int aiItemCount, ObjectReference akItemReference, ObjectReference akDestContainer, int aiTransferReason)
    Int PlayerCount = akDestContainer.GetItemCount(akBaseItem)
    akDestContainer.RemoveItem(akBaseItem, aiItemCount, true)

    ; Excess items will have been moved to ship when they took out the items, based on the old carry limit 
    ; As we took ours back, it can leave player with less items than they started with
    Int NewPlayerCount = akDestContainer.GetItemCount(akBaseItem)
    Int MovedToShip = PlayerCount - NewPlayerCount 
    
    ; Once the new carry limit is set, replensih player's items
    Int CarryLimit = Self.GetItemCount(akBaseItem)
    Main.SetCarryLimit(akBaseItem, CarryLimit)
    If MovedToShip > 0 ; move it back
        Main.GetShip().RemoveItem(akBaseItem, MovedToShip, true, akDestContainer)
    EndIf
EndEvent