Scriptname SMIN:Effect:CarryLimit extends ActiveMagicEffect

SMIN:Main Property Main Auto Const Mandatory
FormList Property ItemList Auto Const Mandatory
Bool Property CarryLimitIsRequired Auto Const Mandatory
ReferenceAlias Property SMIN_ContainerAlias Mandatory Const Auto
GlobalVariable Property SMIN_GLOB_EnableOverflow Mandatory Const Auto
GlobalVariable Property SMIN_GLOB_OverflowMult Mandatory Const Auto

Form[] ItemArray
Int[] CarryLimits
Bool[] IgnoreSync
Int CARRY_DISABLED = -1 Const

Actor Player
ObjectReference ContainerRef

CustomEvent OnSyncComplete
float OverflowMult

Event OnEffectStart(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, float afMagnitude, float afDuration)
    Player = akTarget as Actor
    AddInventoryEventFilter(ItemList)
    OverflowMult = SMIN_GLOB_OverflowMult.GetValue()
    Init()
    RegisterForCustomEvent(Main, "OnSetCarryLimit")
    RegisterForCustomEvent(Main, "OnSetIgnoreSync")
    RegisterForCustomEvent(Main, "OnSyncInventory")
    Main.RegisterEffect(Self, true)
EndEvent

Event OnEffectFinish(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, float afMagnitude, float afDuration)
    Player = None
    RemoveInventoryEventFilter(ItemList)
    ItemArray.clear()
    CarryLimits.clear()
    UnregisterForCustomEvent(Main, "OnSetCarryLimit")
    UnregisterForCustomEvent(Main, "OnSetIgnoreSync")
    UnregisterForCustomEvent(Main, "OnSyncInventory")
    Main.RegisterEffect(Self, false)
EndEvent

; Transfer reasons
; 2 - Purchased
; 4 - Picked up from container
; 7 - Picked up from floor
; 9 - Crafted
; 23 - Added via script/console
Event OnItemAdded(Form akBaseItem, int aiItemCount, ObjectReference akItemReference, ObjectReference akSourceContainer, int aiTransferReason)
    If akSourceContainer == ContainerRef
        ; Do nothing (container script will handle)
    ElseIf Main.ModRunning && aiTransferReason != 2 && aiTransferReason != 9
        ManageItem(akBaseItem, akSourceContainer)
        ; Debug.Notification("Transfer reason: "+ aiTransferReason)
    EndIf
EndEvent

Event SMIN:Main.OnSyncInventory(SMIN:Main Sender, Var[] Args)
    SyncAll()
    SendCustomEvent("OnSyncComplete")
EndEvent

Event SMIN:Main.OnSetCarryLimit(SMIN:Main Sender, Var[] Args)
    Form TheItem = Args[0] as Form
    Int CarryLimit = Args[1] as Int
    Int ItemIndex = ItemArray.Find(TheItem)
    If ItemIndex >= 0
        If CarryLimit == 0 && CarryLimitIsRequired
            CarryLimit = CARRY_DISABLED
        EndIf
        CarryLimits[ItemIndex] = CarryLimit
    EndIf
EndEvent

Event SMIN:Main.OnSetIgnoreSync(SMIN:Main Sender, Var[] Args)
    Form TheItem = Args[0] as Form
    Bool bIgnore = Args[1] as Bool
    Int ItemIndex = ItemArray.Find(TheItem)
    If ItemIndex >= 0
        IgnoreSync[ItemIndex] = bIgnore
    EndIf
EndEvent

Function Init()
    ContainerRef = SMIN_ContainerAlias.GetRef()
    ItemArray = SMIN_Utils.ImportFormlist(ItemList)
    CarryLimits = New Int[ItemArray.length]
    IgnoreSync = New Bool[ItemArray.length]
    Int i = 0
    While i < ItemArray.length
        Form TheItem = ItemArray[i]
        Int CarryLimit = ContainerRef.GetItemCount(TheItem)
        If CarryLimit == 0 && CarryLimitIsRequired
            CarryLimit = CARRY_DISABLED
        EndIf
        CarryLimits[i] = CarryLimit
        i += 1
    EndWhile
EndFunction

Function SyncAll()
    Int i = 0
    While i < ItemArray.length
        If !IgnoreSync[i]
            ManageItem(ItemArray[i], None, true)   
        EndIf 
        i += 1
    EndWhile
EndFunction

Function ManageItem(Form TheItem, ObjectReference Source = None, Bool bSync = false, Bool bSilent = true)
    Int ItemIndex = ItemArray.Find(TheItem) 
    Int CarryLimit = CarryLimits[ItemIndex]
    Int PlayerCount = Player.GetItemCount(TheItem)

    If CarryLimit == CARRY_DISABLED 
        If bSync && PlayerCount > 0 
            Main.RemoveItemFromPlayer(TheItem, PlayerCount, Source, bSilent)
        EndIf
    ElseIf CarryLimit > 0
        If bSync && PlayerCount < CarryLimit 
            ; Top up
            Int Count = CarryLimit - PlayerCount
            Main.AddItemToPlayer(TheItem, Count, bSilent)
        Else
            If !bSync && SMIN_GLOB_EnableOverflow.GetValue() == 1.0
                CarryLimit = Math.Ceiling(CarryLimit * OverflowMult)
            EndIf

            If PlayerCount > CarryLimit 
                ; Remove excess
                Int Count = PlayerCount - CarryLimit
                Main.RemoveItemFromPlayer(TheItem, Count, Source, bSync)
            EndIf
        EndIf
    EndIf
EndFunction
