Scriptname SMIN_Utils

Form[] Function ImportFormlist(FormList MyFormList) Global
    Int listSize = MyFormList.GetSize()
    Form[] MyArray = new Form[listSize]
    Int i = 0
    While i < listSize
        MyArray[i] = MyFormList.GetAt(i) as Form
        i += 1
    EndWhile
    return MyArray
EndFunction 

Function AddItemAndFillAlias(Actor TheActor, Form TheItem, ReferenceAlias TheAlias, Bool bSilent = true) Global
    Int ItemCount = TheActor.GetItemCount(TheItem)
    If ItemCount == 0
        ObjectReference TheObject = TheActor.PlaceAtMe(TheItem)
        TheAlias.ForceRefTo(TheObject)
        TheActor.AddItem(TheObject, 1, bSilent)
        ; Debug.Notification("Added item: " + TheItem + " and filled alias: " + TheAlias)
    EndIf
EndFunction

Function RemoveItemAndClearAlias(Actor TheActor, Form TheItem, ReferenceAlias TheAlias, Bool bSilent = true) Global
    Int ItemCount = TheActor.GetItemCount(TheItem)
    If ItemCount > 0
        TheAlias.Clear()
        TheActor.RemoveItem(TheItem, ItemCount, bSilent)
        ; Debug.Notification("Removed item: " + TheItem + " and cleared alias: " + TheAlias)
    EndIf
EndFunction

Function CheckAndAddSpell(Actor TheActor, Spell TheSpell) Global
    If !TheActor.HasSpell(TheSpell)
        TheActor.AddSpell(TheSpell, false)
    EndIf
EndFunction

Function CheckAndRemoveSpell(Actor TheActor, Spell TheSpell) Global
    If TheActor.HasSpell(TheSpell)
        TheActor.RemoveSpell(TheSpell)
    EndIf
EndFunction

Function CheckAndAddPerk(Actor TheActor, Perk ThePerk) Global
    If !TheActor.HasPerk(ThePerk)
        TheActor.AddPerk(ThePerk, false)
    EndIf
EndFunction

Function CheckAndRemovePerk(Actor TheActor, Perk ThePerk) Global
    If TheActor.HasPerk(ThePerk)
        TheActor.RemovePerk(ThePerk)
    EndIf
EndFunction