Scriptname SMIN:Effect:WeaponTracker extends ActiveMagicEffect

SMIN:Main Property Main Auto Const Mandatory
Keyword Property WeaponTypeRanged Auto Const Mandatory
FormList Property SMIN_Items_Ammo Auto Const Mandatory
FormList Property SMIN_Items_Weapons Auto Const Mandatory
ReferenceAlias Property SMIN_ContainerAlias Mandatory Const Auto
GlobalVariable Property SMIN_Glob_EnableWeaponTracker Mandatory Const Auto

Ammo[] AmmoArray
Weapon[] WeaponArray
Int[] WeaponCounts
Int[] CarryLimits
ObjectReference ContainerRef
Actor Player
SpaceshipReference Ship

CustomEvent OnSyncComplete

Event OnEffectStart(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, float afMagnitude, float afDuration)
    Utility.Wait(0.25)
    Debug.Notification("Weapon Tracker - initializing")

    AddInventoryEventFilter(WeaponTypeRanged)
    Player = Game.GetPlayer()
    Ship = Main.GetShip()
    ContainerRef = SMIN_ContainerAlias.GetRef()
    AmmoArray = SMIN_Utils.ImportFormlist(SMIN_Items_Ammo) as Ammo[]
    WeaponArray = SMIN_Utils.ImportFormList(SMIN_Items_Weapons) as Weapon[]
    
    InitCarryLimits()
    CountWeaponsByAmmoType()
    SyncAll(false)

    RegisterForCustomEvent(Main, "OnSetCarryLimit")
    RegisterForCustomEvent(Main, "OnSyncInventory")
    Main.RegisterEffect(Self, true)

    Debug.Notification("Weapon Tracker - ON")
EndEvent

Event OnEffectFinish(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, float afMagnitude, float afDuration)
    ResetTracking()
    Player = None
    ContainerRef = None
    AmmoArray.clear()
    WeaponArray.clear()
    CarryLimits.clear()
    WeaponCounts.clear()

    UnregisterForCustomEvent(Main, "OnSetCarryLimit")
    UnregisterForCustomEvent(Main, "OnSyncInventory")
    Main.RegisterEffect(Self, false)

    ; If SMIN_Glob_EnableWeaponTracker.GetValueInt() == 0
    ;     Debug.Notification("Weapon Tracker - OFF")
    ; EndIf
EndEvent

Function InitCarryLimits()
    CarryLimits = New Int[AmmoArray.length]
    Int i = 0
    While i < AmmoArray.length
        Ammo TheAmmo = AmmoArray[i]
        CarryLimits[i] = ContainerRef.GetItemCount(TheAmmo)
        Main.SetIgnoreSync(TheAmmo as Form, true)
        i += 1
    EndWhile
EndFunction

Function ResetTracking()
    Int i = 0
    While i < AmmoArray.length
        Main.SetIgnoreSync(AmmoArray[i] as Form, false)
        i += 1
    EndWhile
EndFunction

Event OnItemAdded(Form akBaseItem, int aiItemCount, ObjectReference akItemReference, ObjectReference akSourceContainer, int aiTransferReason)
    Ammo TheAmmo = (akBaseItem as Weapon).GetAmmo()
    IncrementWeaponCount(TheAmmo, aiItemCount)
EndEvent

Event OnItemRemoved(Form akBaseItem, int aiItemCount, ObjectReference akItemReference, ObjectReference akDestContainer, int aiTransferReason)    
    Ammo TheAmmo = (akBaseItem as Weapon).GetAmmo()
    IncrementWeaponCount(TheAmmo, aiItemCount * -1)
EndEvent

Function CountWeaponsByAmmoType()
    WeaponCounts = new Int[AmmoArray.length]
    Int i = 0
    While i < WeaponArray.length
        Weapon TheWeapon = WeaponArray[i]
        Ammo TheAmmo = TheWeapon.GetAmmo()
        Int Count = Player.GetItemCount(TheWeapon)
        Int AmmoIndex = AmmoArray.Find(TheAmmo)
        If AmmoIndex >= 0 && Count > 0
            WeaponCounts[AmmoIndex] += Count
        EndIf
        i += 1
    EndWhile
EndFunction

Function IncrementWeaponCount(Ammo TheAmmo, Int Amount)
    Ship = Main.GetShip()
    Int AmmoIndex = AmmoArray.Find(TheAmmo)
    If AmmoIndex >= 0
        Int OldCount = WeaponCounts[AmmoIndex]
        Int NewCount = WeaponCounts[AmmoIndex] + Amount
        
        If NewCount < 0
            NewCount = 0
        EndIf

        WeaponCounts[AmmoIndex] = NewCount

        If NewCount == 0 || NewCount == 1
            If Main.CanSync()
                SyncAmmo(AmmoIndex, false)
            EndIf
        EndIf
    EndIf
EndFunction

Event SMIN:Main.OnSetCarryLimit(SMIN:Main Sender, Var[] Args)
    Form TheAmmo = Args[0] as Form
    Int CarryLimit = Args[1] as Int
    Int ItemIndex = AmmoArray.Find(TheAmmo as Ammo)
    If ItemIndex >= 0
        CarryLimits[ItemIndex] = CarryLimit
    EndIf
EndEvent

Event SMIN:Main.OnSyncInventory(SMIN:Main Sender, Var[] Args)
    Ship = Main.GetShip()
    SyncAll(true)
    SendCustomEvent("OnSyncComplete")
EndEvent

Function SyncAll(Bool bSilent)
    Int i = 0
    While i < AmmoArray.length
        SyncAmmo(i, bSilent)
        i += 1
    EndWhile
EndFunction

Function SyncAmmo(Int AmmoIndex, Bool bSilent)
    Ammo TheAmmo = AmmoArray[AmmoIndex]
    Int CarryLimit = CarryLimits[AmmoIndex]
    Int PlayerCount = Player.GetItemCount(TheAmmo)
    If WeaponCounts[AmmoIndex] == 0
        Main.RemoveItemFromPlayer(TheAmmo, PlayerCount, None, bSilent)
    ElseIf CarryLimit == 0 ; Get all
        Main.AddItemToPlayer(TheAmmo, Main.GetShip().GetItemCount(TheAmmo), bSilent)
    ElseIf PlayerCount < CarryLimit ; Top up
        Main.AddItemToPlayer(TheAmmo, CarryLimit - PlayerCount, bSilent)
    ElseIf PlayerCount > CarryLimit ; Remove excess
        Main.RemoveItemFromPlayer(TheAmmo, PlayerCount - CarryLimit, None, bSilent)
    EndIf
EndFunction