Scriptname SMIN:Object:Activator extends ObjectReference

SMIN:Main Property Main Auto Const Mandatory
ReferenceAlias Property SMIN_ContainerAlias Mandatory Const Auto
Potion Property SMIN_SyncInventory_Potion Mandatory Const Auto
ReferenceAlias Property SMIN_SyncInventory_PotionAlias Auto Const Mandatory

Group Globals
    GlobalVariable Property SMIN_GLOB_EnableAutoSync Auto Const Mandatory
    GlobalVariable Property SMIN_GLOB_EnableWeaponTracker Auto Const Mandatory
    GlobalVariable Property SMIN_GLOB_EnableAdditionalItems Auto Const Mandatory
    GlobalVariable Property SMIN_GLOB_EnableOverflow Auto Const Mandatory
EndGroup

Group Messages
    Message Property SMIN_Message_Menu Mandatory Const Auto
    Message Property SMIN_Message_Tutorial Mandatory Const Auto
    Message Property SMIN_Message_AutoSync Mandatory Const Auto
    Message Property SMIN_Message_WeaponTracker Mandatory Const Auto
    Message Property SMIN_Message_SyncResources Mandatory Const Auto
    Message Property SMIN_Message_Overflow Mandatory Const Auto
EndGroup

Event OnWorkshopObjectPlaced(ObjectReference akReference)
    Utility.Wait(1)
EndEvent

Event OnLoad()
    BlockActivation(false, false)
EndEvent

Event OnActivate(ObjectReference akActionRef)
EndEvent

Function SyncInventory()
    BlockActivation(true, true)
    Main.SyncInventory()
    BlockActivation(false, false)
EndFunction

Function ShowContainer()
    BlockActivation(true, true)
    Main.ShowContainer()
    Utility.wait(0.25)
    BlockActivation(false, false)
EndFunction

Function ShowSettings()
    BlockActivation(true, true)
    Int Response = SMIN_Message_Menu.Show()
    If Response == 0
        SMIN_Message_Tutorial.Show()
        ShowSettings()
    ElseIf Response == 1 || Response == 2
        ShowMessage_AutoSync()
        ShowSettings()
    ElseIf Response == 3 || Response == 4
        ShowMessage_Overflow()
        ShowSettings()
    ElseIf Response == 5 || Response == 6
        ShowMessage_WeaponTracker()
        ShowSettings()
    ElseIf Response == 7 || Response == 8
        ShowMessage_AdditionalItems()
        ShowSettings()
    EndIf
    BlockActivation(false, false)
    SMIN_Utils.AddItemAndFillAlias(Game.GetPlayer(), SMIN_SyncInventory_Potion, SMIN_SyncInventory_PotionAlias, false)
EndFunction

Function ShowMessage_AutoSync()
    Int Response = SMIN_Message_AutoSync.Show()
    If Response == 0
        SMIN_GLOB_EnableAutoSync.SetValueInt(1)
    ElseIf Response == 1
        SMIN_GLOB_EnableAutoSync.SetValueInt(0)
    EndIf
EndFunction

Function ShowMessage_WeaponTracker()
    Int Response = SMIN_Message_WeaponTracker.Show()
    If Response == 0
        SMIN_GLOB_EnableWeaponTracker.SetValueInt(1)
    ElseIf Response == 1
        SMIN_GLOB_EnableWeaponTracker.SetValueInt(0)
    EndIf
EndFunction

Function ShowMessage_AdditionalItems()
    Int Response = SMIN_Message_SyncResources.Show()
    If Response == 0
        SMIN_GLOB_EnableAdditionalItems.SetValueInt(1)
    ElseIf Response == 1
        SMIN_GLOB_EnableAdditionalItems.SetValueInt(0)
    EndIf
EndFunction

Function ShowMessage_Overflow()
    Int Response = SMIN_Message_Overflow.Show()
    If Response == 0
        SMIN_GLOB_EnableOverflow.SetValueInt(1)
    ElseIf Response == 1
        SMIN_GLOB_EnableOverflow.SetValueInt(0)
    EndIf
EndFunction