Scriptname SMIN:Object:Container extends ObjectReference

SMIN:Main Property Main Auto Const Mandatory
FormList Property SMIN_Items_All Auto Const Mandatory

Function Init()
    AddInventoryEventFilter(SMIN_Items_All)
EndFunction

; Increase the carry limit by aiItemCount
Event OnItemAdded(Form akBaseItem, int aiItemCount, ObjectReference akItemReference, ObjectReference akSourceContainer, int aiTransferReason)
    Int CarryLimit = Self.GetItemCount(akBaseItem)
    Main.GetShip().AddItem(akBaseItem, aiItemCount, true) ; refund
    Main.SetCarryLimit(akBaseItem, CarryLimit)
    
    Int PlayerCount = akSourceContainer.GetItemCount(akBaseItem)
    If PlayerCount < CarryLimit ; Replenish from ship
        Main.GetShip().RemoveItem(akBaseItem, CarryLimit - PlayerCount, true, akSourceContainer)
    ElseIf PlayerCount > CarryLimit
        akSourceContainer.RemoveItem(akBaseItem, PlayerCount - CarryLimit, true, Main.GetShip())
    EndIf
EndEvent

; Decrease the carry limit by aiItemCount
Event OnItemRemoved(Form akBaseItem, int aiItemCount, ObjectReference akItemReference, ObjectReference akDestContainer, int aiTransferReason)
    Int CarryLimit = Self.GetItemCount(akBaseItem)
    Main.SetCarryLimit(akBaseItem, CarryLimit)
    akDestContainer.RemoveItem(akBaseItem, aiItemCount, true) ; refund
    
    Int PlayerCount = akDestContainer.GetItemCount(akBaseItem)
    If CarryLimit > 0
        If PlayerCount > CarryLimit
            akDestContainer.RemoveItem(akBaseItem, PlayerCount - CarryLimit, true, Main.GetShip())
        ElseIf PlayerCount < CarryLimit
            Main.GetShip().RemoveItem(akBaseItem, CarryLimit - PlayerCount, true, akDestContainer)
        EndIf
    EndIf
EndEvent