ScriptName GSN:Objects:ShipPanel extends ObjectReference

GSN:ShipManager Property GSN_ShipManager Auto Const
GlobalVariable Property GSN_Global_ShipIsConnected Auto Const Mandatory
GlobalVariable Property GSN_Global_DEBUG Auto Const Mandatory
Keyword Property Contraband Const Auto Mandatory
Message Property GSN_Message_ContrabandNotPermitted Const Auto Mandatory

Event OnWorkshopObjectPlaced(ObjectReference akReference)
    RegisterEvents(true)
    GSN_ShipManager.RegisterPanel(Self, true)
EndEvent

Event OnWorkshopObjectRemoved(ObjectReference akReference)
    RegisterEvents(false)
    GSN_ShipManager.RegisterPanel(Self, false)
EndEvent

Function RegisterEvents(Bool bRegister)
    If bRegister
        RegisterForCustomEvent(GSN_ShipManager, "OnConnect")
        RegisterForCustomEvent(GSN_ShipManager, "OnDisconnect")
    Else    
        UnregisterForCustomEvent(GSN_ShipManager, "OnConnect")
        UnregisterForCustomEvent(GSN_ShipManager, "OnDisconnect")
    EndIf
EndFunction

Event OnLoad()
    UpdateDisplay()
EndEvent

Event GSN:ShipManager.OnConnect(GSN:ShipManager Sender, Var[] Args)
    UpdateDisplay()
EndEvent

Event GSN:ShipManager.OnDisconnect(GSN:ShipManager Sender, Var[] Args)
    UpdateDisplay()
EndEvent

Function UpdateDisplay()
    If Is3DLoaded() && IsEnabled()
        StopAllSequences()
        If GSN_Global_ShipIsConnected.GetValueInt() == 1
            StartSequence("Idle", true)
        Else
            StartSequence("Off", true)
        EndIf
    EndIf
EndFunction

Event OnItemAdded(Form akBaseItem, int aiItemCount, ObjectReference akItemReference, ObjectReference akSourceContainer, int aiTransferReason)
    If akBaseItem.HasKeyword(Contraband)
        RemoveItem(akBaseItem, aiItemCount, true, akSourceContainer)
        GSN_Message_ContrabandNotPermitted.Show()
    EndIf
EndEvent

Function Activate_ShowInfo(ObjectReference akTargetRef)
    akTargetRef.BlockActivation(true, true)
    GSN_ShipManager.ShowInfo()
    Utility.Wait(2)
    akTargetRef.BlockActivation(false)
EndFunction

Function Activate_MasterPanel(ObjectReference akTargetRef)
    akTargetRef.BlockActivation(true, true)
    GSN_ShipManager.ActivateMasterPanel()
    Utility.Wait(0.25)
    akTargetRef.BlockActivation(false)
EndFunction