-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function init()
    electrics.values.trackwheel = 1
end

local function updateGFX(dt)
    local gear = (electrics.values.gear_M or 0)
    local wheelspeed = electrics.values.wheelspeed

    electrics.values.trackwheel = ((electrics.values.trackwheel + (dt * wheelspeed * 100 * gear)) % 360) or 0
    
end

-- public interface
M.updateGFX      = updateGFX
M.onInit      = init
M.onReset     = init
return M