-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local htmlTexture = require("htmlTexture")

local min = math.min
local max = math.max

local gaugesScreenName = nil
local htmlPath = nil

local updateTimer = 0

local updateFPS = 30
local invFPS = 1 / updateFPS


local function updateGFX(dt)
  updateTimer = updateTimer + dt

  if updateTimer > invFPS then

    local data = {}

	if electrics.values["screenunit"] == 0 then

    data.dategauge = os.date("%m") .. "." .. os.date("%d") .. "." .. os.date("%Y")
    data.timegauge = os.date("%H") .. ":" .. os.date("%M")
	
	else
    data.dategauge = os.date("%d") .. "." .. os.date("%m") .. "." .. os.date("%Y") -- the correct way to make a date.  https://www.gammon.com.au/scripts/doc.php?lua=os.date useful page for date function
    data.timegauge = os.date("%H") .. ":" .. os.date("%M") -- done to prevent seconds from being sent.
	end
	
	data.speedometergauge =  electrics.values["wheelspeed"] * 3.6
	data.enginerunning = electrics.values["engineRunning"]
	
    data.topscreenunit = electrics.values["screenunit"]
	
	if electrics.values["gear"] == 0 then
	data.geargauge =  "N"
	elseif electrics.values["gear"] == -1 then
	data.geargauge =  "R"
	else
	data.geargauge =  electrics.values["gear"]
	end

    --dump(data)
    htmlTexture.call(gaugesScreenName, "updateData", data)
    updateTimer = 0
  end
end

local function init(jbeamData)
	gaugesScreenName = jbeamData.materialName
	htmlPath = jbeamData.htmlPath
	local width = jbeamData.textureWidth or 512
	local height = jbeamData.textureHeight or 256

    htmlTexture.create(gaugesScreenName, htmlPath, width, height, updateFPS, "automatic")
	htmlTexture.call(gaugesScreenName, "setUnits", {unitType = unitType})
end

M.init = init
M.updateGFX = updateGFX

return M
