local M = {}


local function onBeamNGTrigger(data)
  local playerVehId = be:getPlayerVehicleID(0)
  if data.triggerName == "dragTrigger" and data.subjectID == playerVehId then
    if data.event == "enter" then
      local buttonsTable = {}
      local DragRaceUI = scenetree.findObject("DragRaceActionMap")
      if DragRaceUI then
        DragRaceUI:push()
      end
      table.insert(buttonsTable, {action = 'start_drag', text = 'ui.dragrace.Accept', cmd = 'freeroam_dragRace.accept()'})
      guihooks.trigger('MissionInfoUpdate',{title = "ui.wca.dragstrip.title", type="race", typeName="", buttons = buttonsTable})
    end

    if data.event == "exit" then
      local DragRaceUI = scenetree.findObject("DragRaceActionMap")
      if DragRaceUI then
        DragRaceUI:pop()
      end
      guihooks.trigger('MenuHide', true)
      guihooks.trigger('MissionInfoUpdate', nil)
    end
  end
end

-- figure out whether drag racing mode should be active or not (e.g. it should be disabled while during bus missions)
local function mustBeRunning()
  if career_career and career_career.isEnabled() then return false end
  if scenario_scenarios then return false end
  if scenario_busdriver then return false end
  local st = core_gamestate and core_gamestate.state and core_gamestate.state.state
  if st == nil then return true end
  if st ~= "freeroam" then return false end
  return true
end

-- make sure drag racing mode is active only at appropriate times
local function ensureRunningState()
  local isRunning = freeroam_dragRace ~= nil
  local mustRun = mustBeRunning()
  if mustRun ~= isRunning then
    if mustRun then
      extensions.load("freeroam_dragRace")
      M.onBeamNGTrigger = onBeamNGTrigger
      extensions.refresh('mainLevel')
    else
      extensions.unload("freeroam_dragRace")
      guihooks.trigger('MissionInfoUpdate', nil)
      M.onBeamNGTrigger = nop
      extensions.refresh('mainLevel')
    end
  end
end

M.onClientPostStartMission = ensureRunningState
M.onClientEndMission       = ensureRunningState
M.onCareerEnabledChanged   = ensureRunningState
M.onDeserialize            = ensureRunningState
M.onSerialize = function() return {} end -- our only purpose is to enable onDeserialize function, so ctrl+L will reflect changes to the code in this file (while a developer is tweaking this file)

return M
