
// This is the default save location for any ForestBrush(s) created in
// the Forest Editor.
// This script is executed from ForestEditorPlugin::onWorldEditorStartup().

//--- OBJECT WRITE BEGIN ---
new SimGroup(ForestBrushGroup) {
   canSave = "1";
   canSaveDynamicFields = "1";

   new ForestBrush() {
      internalName = "trees_pine_radiata";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_pine_radiata_forest";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "pine_radiata_forest";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_pine_radiata_large";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "pine_radiata_large";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_pine_radiata_small";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "pine_radiata_small";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "2";
         sinkMax = "3";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_pine_radiata_weathered";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "pine_radiata_weathered";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   
   new ForestBrush() {
      internalName = "trees_oak_dry";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_oak_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "oak_dry_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "tree_oak_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "oak_dry_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "tree_oak_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "oak_dry_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "tree_oak_d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "oak_dry_d";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   
   new ForestBrush() {
      internalName = "trees_redwood";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_redwood_split";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "redwood_split";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_redwood_tall";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "redwood_tall";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_redwood_broad";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "redwood_broad";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "trees_fanpalm";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_fanpalm_full";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "fanpalm_full";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_fanpalm_short";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "fanpalm_short";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_fanpalm_skirt";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "fanpalm_skirt";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_fanpalm_slim";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "fanpalm_slim";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_fanpalm_tall";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "fanpalm_tall";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "trees_shrub";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "shrub_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "shrub_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.5";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "shrub_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "shrub_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.5";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "shrub_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "shrub_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.5";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "shrub_d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "shrub_d";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.5";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "shrub_e";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "shrub_e";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.5";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "shrub_f";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "shrub_f";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.5";
         scaleMax = "0.7";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "shrub_g";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "shrub_g";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.5";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "tree_cypress";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_cypress";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_cypress";
         probability = "1";
         rotationRange = "360";
         scaleMin = "2";
         scaleMax = "3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "80";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "grasses1";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "grassclump_large";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "grassclump_large";
         probability = "1";
         rotationRange = "360";
         scaleMin = "2";
         scaleMax = "3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "80";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "grassclump_small";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "grassclump_small";
         probability = "1";
         rotationRange = "360";
         scaleMin = "2";
         scaleMax = "3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "80";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "spanishbayonet1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "spanishbayonet1";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "80";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "spanishbayonet2";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "spanishbayonet2";
         probability = "1";
         rotationRange = "360";
         scaleMin = "2";
         scaleMax = "3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "80";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "eucalyptus";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "eucalyptus_tall";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eucalyptus_tall";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.4";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "80";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_eucalyptus_double";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eucalyptus_double";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.4";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "80";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_eucalyptus_group";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eucalyptus_group";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.4";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "80";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "wca_rocks";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "wca_rock1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "wca_rock1";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.6";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "wca_rock2";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "wca_rock2";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.6";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "wca_rock3";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "wca_rock3";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.6";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "wca_rock4";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "wca_rock4";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.6";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "wca_rock5";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "wca_rock5";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.6";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "wca_rock6";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "wca_rock6";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.6";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "wca_rock7";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "wca_rock7";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.6";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "wca_rock8";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "wca_rock8";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.6";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "wca_rock9";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "wca_rock9";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.6";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "wca_rock10";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "wca_rock10";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.6";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "wca_rock11";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "wca_rock11";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.6";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "wca_cliffs";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "wca_cliff1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "wca_cliff1";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.6";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "barrierfences";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "barrierfence_folk";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "barrierfence_folk";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "barrierfence_plain";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "barrierfence_plain";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "solarpanel";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "solarpanel";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "solarpanel";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   
   new ForestBrush() {
      internalName = "flags";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "flag_usa1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "flag_usa1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   
   new ForestBrush() {
      internalName = "fences";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "fence_metal1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "fence_metal1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "screenfence1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "screenfence1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "railings";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "guardrail_support1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "guardrail_support1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "railing_support1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "railing_support1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "railing_support2";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "railing_support2";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "tirestack1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tirestack1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "pylon";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "pylon";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "pylon";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "train_support1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "train_support1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "road_support1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "road_support1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "walls";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "wall_brick1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "wall_brick1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "wall_metal1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "wall_metal1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "wall_wire1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "wall_wire1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "wall_wood1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "wall_wood1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "billboards";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "billboard_structure1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "billboard_structure1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "billboard_structure2";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "billboard_structure2";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "sign_rounded";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "sign_rounded";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "sign_turboburger";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "sign_turboburger";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "power poles";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "powerpole1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "powerpole1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "powerpole2";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "powerpole2";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "powerpole3";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "powerpole3";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "substation";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "substation_circuitbreaker";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "substation_circuitbreaker";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "substation_lightning";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "substation_lightning";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "substation_support";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "substation_support";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "substation_transformer";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "substation_transformer";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "substation_truss";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "substation_truss";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "industrial_objects";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "dumpster";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "dumpster";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "constructionbarrier";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "constructionbarrier";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };

      new ForestBrushElement() {
         internalName = "industrial_watertower";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "industrial_watertower";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "industrial_pumpjack";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "industrial_pumpjack";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "workshop1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "workshop1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "leanto_small";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "leanto_small";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "leanto_large";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "leanto_large";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "rack";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rack";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "pipeline_objects";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "pipeline_support1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "pipeline_support1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "pipeline_support2";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "pipeline_support2";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "houses";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "house1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "house1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "house2";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "house2";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "house3";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "house3";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "house4";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "house4";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   
   new ForestBrush() {
      internalName = "townhouses";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "townhouse_01l";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_01l";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_02l";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_02l";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_03l";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_03l";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_04l";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_04l";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_05l";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_05l";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_06l";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_06l";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_07l";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_07l";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_08l";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_08l";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_09l";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_09l";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_10l";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_10l";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_11l";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_11l";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_12l";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_12l";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_13l";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_13l";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_14l";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_14l";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_15l";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_15l";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_16l";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_16l";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_17l";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_17l";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_01r";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_01r";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_02r";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_02r";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_03r";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_03r";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_04r";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_04r";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_05r";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_05r";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_06r";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_06r";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_07r";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_07r";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_08r";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_08r";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_09r";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_09r";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_10r";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_10r";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_11r";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_11r";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_12r";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_12r";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_13r";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_13r";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_14r";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_14r";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_15r";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_15r";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_16r";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_16r";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "townhouse_17r";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "townhouse_17r";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
   };
   
   new ForestBrush() {
      internalName = "warehouses";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "warehouse1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "warehouse1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "toll_objects";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "toll";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "toll";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "toll_edge";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "toll_edge";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "toll_side";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "toll_side";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "poles";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "pole_city1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "pole_city1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "cable_boom";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "cable_boom";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "pole_light_bridge";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "pole_light_bridge";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "pole_light_single";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "pole_light_single";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "pole_light_double";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "pole_light_double";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "pole_light_signal1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "pole_light_signal1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "pole_traffic1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "pole_traffic1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "pole_thick";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "pole_thick";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "pole_boom";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "pole_boom";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "pole_boom_med";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "pole_boom_med";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "boom_trafficlight_small";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "boom_trafficlight_small";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "light_city";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "light_city";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "lamp1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lamp1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "pole_lighting1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "pole_lighting1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "pole_lighting2";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "pole_lighting2";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "trafficlights";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "trafficlight1a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "trafficlight1a";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "trafficlight1b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "trafficlight1b";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "trafficlight1c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "trafficlight1c";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "trafficlight2a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "trafficlight2a";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "trafficlight2b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "trafficlight2b";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "trafficlight2c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "trafficlight2c";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "trafficlight_city1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "trafficlight_city1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "trafficlight_city2";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "trafficlight_city2";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "trafficlight_overhead1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "trafficlight_overhead1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "trafficlight_overhead2";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "trafficlight_overhead2";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      
      new ForestBrushElement() {
         internalName = "crosswalklight";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "crosswalklight";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "sidewalk_objects";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "hydrant1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "hydrant1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "bollard_yellow";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "bollard_yellow";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "bollard_hoop_red";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "bollard_hoop_red";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "bollard_hoop_grey";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "bollard_hoop_grey";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "planterbox";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "planterbox";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "busstop";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "busstop";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "trafficlightbox_green";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "trafficlightbox_green";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "postbox_blue";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "postbox_blue";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "gaspump";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "gaspump";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   
   new ForestBrush() {
      internalName = "roadsigns";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "roadsign_truss1";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "sign_truss1";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "roadsign_truss2";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "sign_truss2";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "roadsign_truss3";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "sign_truss3";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "roadsign_truss4";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "sign_truss4";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "85";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
};
//--- OBJECT WRITE END ---
