
// This is the default save location for any TSForestItemData(s) created in the
// Forest Editor Editor (this script is executed from onServerCreated())

datablock TSForestItemData(tree_cypress)
{
   internalName = "tree_cypress";
   shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_cypress/cypress_tree.dae";
   windScale = "0.4";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.4";
};

datablock TSForestItemData(grassclump_large)
{
   internalName = "grassclump_large";
   shapeFile = "levels/west_coast_usa/art/shapes/trees/grassclump_large.dae";
   windScale = "0.4";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.4";
};

datablock TSForestItemData(grassclump_small)
{
   internalName = "grassclump_large";
   shapeFile = "levels/west_coast_usa/art/groundcover/grassclump_small.dae";
   windScale = "0.4";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.4";
};

datablock TSForestItemData(spanishbayonet1)
{
   internalName = "spanishbayonet1";
   shapeFile = "levels/west_coast_usa/art/shapes/trees/spanishbayonet1.dae";
   windScale = "0.4";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.4";
};

datablock TSForestItemData(spanishbayonet2)
{
   internalName = "spanishbayonet2";
   shapeFile = "levels/west_coast_usa/art/shapes/trees/spanishbayonet2.dae";
   windScale = "0.4";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.4";
};


datablock TSForestItemData(eucalyptus_tall)
{
   internalName = "eucalyptus_tall";
   shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_eucalyptus/eucalyptus_tall.dae";
   windScale = "1";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.4";
};

datablock TSForestItemData(eucalyptus_double)
{
   internalName = "eucalyptus_double";
   shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_eucalyptus/eucalyptus_double.dae";
   windScale = "1";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.4";
};

datablock TSForestItemData(eucalyptus_group)
{
   internalName = "eucalyptus_group";
   shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_eucalyptus/eucalyptus_group.dae";
   windScale = "1";
   trunkBendScale = "0.03";
   branchAmp = "0.1";
   detailAmp = "0.1";
   detailFreq = "0.4";
};



datablock TSForestItemData(pine_radiata_forest)
{
    internalName = "pine_radiata_forest";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_conifer/pine_radiata_forest.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(pine_radiata_large)
{
    internalName = "pine_radiata_large";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_conifer/pine_radiata_large.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};
datablock TSForestItemData(pine_radiata_small)
{
    internalName = "pine_radiata_small";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_conifer/pine_radiata_small.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(pine_radiata_weathered)
{
    internalName = "pine_radiata_weathered";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_conifer/pine_radiata_weathered.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(oak_dry_a)
{
    internalName = "oak_dry_a";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_oak/oak_a.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(oak_dry_b)
{
    internalName = "oak_dry_b";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_oak/oak_b.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(oak_dry_c)
{
    internalName = "oak_dry_c";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_oak/oak_c.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(oak_dry_d)
{
    internalName = "oak_dry_d";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_oak/oak_d.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};
datablock TSForestItemData(redwood_split)
{
    internalName = "redwood_split";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_conifer/redwood_split.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(redwood_tall)
{
    internalName = "redwood_tall";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_conifer/redwood_tall.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(redwood_broad)
{
    internalName = "redwood_broad";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_conifer/redwood_broad.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};


datablock TSForestItemData(fanpalm_full)
{
    internalName = "fanpalm_full";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_palm/fanpalm_full.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(fanpalm_short)
{
    internalName = "fanpalm_short";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_palm/fanpalm_short.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(fanpalm_skirt)
{
    internalName = "fanpalm_skirt";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_palm/fanpalm_skirt.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(fanpalm_slim)
{
    internalName = "fanpalm_slim";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_palm/fanpalm_slim.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(fanpalm_tall)
{
    internalName = "fanpalm_tall";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_palm/fanpalm_tall.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(BBZ_redwood1)
{
    internalName = "BBZ_redwood1";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_conifer/BBZ_redwood1.dae";
    
};

datablock TSForestItemData(BBZ_redwood2)
{
    internalName = "BBZ_redwood2";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_conifer/BBZ_redwood2.dae";
    
};

datablock TSForestItemData(BBZ_redwood3)
{
    internalName = "BBZ_redwood3";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_conifer/BBZ_redwood3.dae";
    
};

datablock TSForestItemData(BBZ_redwood4)
{
    internalName = "BBZ_redwood4";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_conifer/BBZ_redwood4.dae";
    
};

datablock TSForestItemData(BBZ_redwood5)
{
    internalName = "BBZ_redwood5";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_conifer/BBZ_redwood5.dae";
    
};

datablock TSForestItemData(shrub_a)
{
    internalName = "shrub_a";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_shrub/shrub_a.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(shrub_b)
{
    internalName = "shrub_b";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_shrub/shrub_b.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(shrub_c)
{
    internalName = "shrub_c";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_shrub/shrub_c.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(shrub_d)
{
    internalName = "shrub_d";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_shrub/shrub_d.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(shrub_e)
{
    internalName = "shrub_e";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_shrub/shrub_e.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(shrub_f)
{
    internalName = "shrub_f";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_shrub/shrub_f.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(shrub_g)
{
    internalName = "shrub_g";
    shapeFile = "levels/west_coast_usa/art/shapes/trees/trees_shrub/shrub_g.dae";
    tightnessCoefficient = "1";
    windScale = "0.5";
    trunkBendScale = "0.04";
    branchAmp = "0.1";
    detailAmp = "0.5";
    detailFreq = "0.5";
    rigidity = "5";
};

datablock TSForestItemData(flag_usa1)
{
   internalName = "flag_usa1";
   shapeFile = "levels/west_coast_usa/art/shapes/objects/flag_usa1.dae";
   windScale = "0.7";
   trunkBendScale = "0.1";
   branchAmp = "0.6";
   detailAmp = "0.1";
   detailFreq = "0.4";
};

datablock TSForestItemData(featherflag_gavril)
{
   internalName = "featherflag_gavril";
   shapeFile = "levels/west_coast_usa/art/shapes/objects/featherflag_gavril.dae";
   windScale = "0";
   trunkBendScale = "0.300000012";
   branchAmp = "0";
   detailAmp = "0";
   detailFreq = "0";
   order_simset = "0";
   mass = "1";
};

datablock TSForestItemData(featherflag_beamng)
{
   internalName = "featherflag_beamng";
   shapeFile = "levels/west_coast_usa/art/shapes/objects/featherflag_beamng.dae";
   windScale = "0.7";
   trunkBendScale = "0.1";
   branchAmp = "0.6";
   detailAmp = "0.1";
   detailFreq = "0.4";
};

datablock TSForestItemData(featherflag_repair)
{
   internalName = "featherflag_repair";
   shapeFile = "levels/west_coast_usa/art/shapes/objects/featherflag_repair.dae";
   windScale = "0.7";
   trunkBendScale = "0.1";
   branchAmp = "0.6";
   detailAmp = "0.1";
   detailFreq = "0.4";
};

datablock TSForestItemData(featherflag_ibishu)
{
   internalName = "featherflag_ibishu";
   shapeFile = "levels/west_coast_usa/art/shapes/objects/featherflag_ibishu.dae";
   windScale = "0.7";
   trunkBendScale = "0.1";
   branchAmp = "0.6";
   detailAmp = "0.1";
   detailFreq = "0.4";
};

datablock TSForestItemData(featherflag_bruckell)
{
   internalName = "featherflag_bruckell";
   shapeFile = "levels/west_coast_usa/art/shapes/objects/featherflag_bruckell.dae";
   windScale = "0.7";
   trunkBendScale = "0.1";
   branchAmp = "0.6";
   detailAmp = "0.1";
   detailFreq = "0.4";
};
//--------------------------------------------------HOUSES

datablock TSForestItemData(house1)
{
    internalName = "house1";
    shapeFile = "levels/west_coast_usa/art/shapes/buildings/house1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(house2)
{
    internalName = "house2";
    shapeFile = "levels/west_coast_usa/art/shapes/buildings/house2.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(house3)
{
    internalName = "house3";
    shapeFile = "levels/west_coast_usa/art/shapes/buildings/house3.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(house4)
{
    internalName = "house4";
    shapeFile = "levels/west_coast_usa/art/shapes/buildings/house4.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(tent1)
{
    internalName = "tent1";
    shapeFile = "levels/west_coast_usa/art/shapes/buildings/tent1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(marshaltower)
{
    internalName = "marshaltower";
    shapeFile = "levels/west_coast_usa/art/shapes/buildings/marshaltower.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(seating1)
{
    internalName = "seating1";
    shapeFile = "levels/west_coast_usa/art/shapes/buildings/seating1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};


//--------------------------------------------------WAREHOUSES

datablock TSForestItemData(warehouse1)
{
    internalName = "warehouse1";
    shapeFile = "levels/west_coast_usa/art/shapes/buildings/warehouse1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

//-------------------------------------------------------ROCKS
datablock TSForestItemData(wca_rock1)
{
    internalName = "wca_rock1";
    shapeFile = "levels/west_coast_usa/art/shapes/rocks/wca_rock1.dae";
    radius = "0";
};

datablock TSForestItemData(wca_rock2)
{
    internalName = "wca_rock2";
    shapeFile = "levels/west_coast_usa/art/shapes/rocks/wca_rock2.dae";
    radius = "0";
};

datablock TSForestItemData(wca_rock3)
{
    internalName = "wca_rock3";
    shapeFile = "levels/west_coast_usa/art/shapes/rocks/wca_rock3.dae";
    radius = "0";
};

datablock TSForestItemData(wca_rock4)
{
    internalName = "wca_rock4";
    shapeFile = "levels/west_coast_usa/art/shapes/rocks/wca_rock4.dae";
    radius = "0";
};

datablock TSForestItemData(wca_rock5)
{
    internalName = "wca_rock5";
    shapeFile = "levels/west_coast_usa/art/shapes/rocks/wca_rock5.dae";
    radius = "0";
};

datablock TSForestItemData(wca_rock6)
{
    internalName = "wca_rock6";
    shapeFile = "levels/west_coast_usa/art/shapes/rocks/wca_rock6.dae";
    radius = "0";
};

datablock TSForestItemData(wca_rock7)
{
    internalName = "wca_rock7";
    shapeFile = "levels/west_coast_usa/art/shapes/rocks/wca_rock7.dae";
    radius = "0";
};

datablock TSForestItemData(wca_rock8)
{
    internalName = "wca_rock8";
    shapeFile = "levels/west_coast_usa/art/shapes/rocks/wca_rock8.dae";
    radius = "0";
};

datablock TSForestItemData(wca_rock9)
{
    internalName = "wca_rock9";
    shapeFile = "levels/west_coast_usa/art/shapes/rocks/wca_rock9.dae";
    radius = "0";
};

datablock TSForestItemData(wca_rock10)
{
    internalName = "wca_rock10";
    shapeFile = "levels/west_coast_usa/art/shapes/rocks/wca_rock10.dae";
    radius = "0";
};

datablock TSForestItemData(wca_rock11)
{
    internalName = "wca_rock11";
    shapeFile = "levels/west_coast_usa/art/shapes/rocks/wca_rock11.dae";
    radius = "0";
};

datablock TSForestItemData(wca_cliff1)
{
    internalName = "wca_cliff1";
    shapeFile = "levels/west_coast_usa/art/shapes/rocks/wca_cliff1.dae";
    radius = "0";
};


//-------------------------------------------------TRACK OBJECTS
datablock TSForestItemData(barrierfence_folk)
{
    internalName = "barrierfence_folk";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/barrierfence_folk.dae";
    radius = "0";
    annotation = "GUARD_RAIL";
    mode = "Override";
};

datablock TSForestItemData(barrierfence_plain)
{
    internalName = "barrierfence_plain";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/barrierfence_plain.dae";
    radius = "0";
    annotation = "GUARD_RAIL";
    mode = "Override";
};

//--------------------------------------------SOLAR PANEL

datablock TSForestItemData(solarpanel)
{
    internalName = "solarpanel";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/solarpanel.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

//-------------------------------------------PYLON

datablock TSForestItemData(pylon)
{
    internalName = "pylon";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/pylon.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(train_support1)
{
    internalName = "train_support1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/train_support1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(road_support1)
{
    internalName = "road_support1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/road_support1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

//-------------------------------------------WALLS

datablock TSForestItemData(wall_brick1)
{
    internalName = "wall_brick1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/wall_brick1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(wall_metal1)
{
    internalName = "wall_metal1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/wall_metal1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(wall_wire1)
{
    internalName = "wall_wire1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/wall_wire1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(wall_wood1)
{
    internalName = "wall_wood1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/wall_wood1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};
//-------------------------------------------POWER POLES

datablock TSForestItemData(powerpole1)
{
    internalName = "powerpole1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/powerpole1.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(powerpole2)
{
    internalName = "powerpole2";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/powerpole2.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(powerpole3)
{
    internalName = "powerpole3";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/powerpole3.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(powerpole4)
{
    internalName = "powerpole4";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/powerpole4.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

//-------------------------------------------FENCES

datablock TSForestItemData(fence_metal1)
{
    internalName = "fence_metal1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/fence_metal1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(screenfence1)
{
    internalName = "screenfence1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/screenfence1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

//-------------------------------------------RAILINGS

datablock TSForestItemData(railing_support1)
{
    internalName = "railing_support1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/railing_support1.dae";
    radius = "0";
    annotation = "GUARD_RAIL";
    mode = "Override";
};

datablock TSForestItemData(railing_support2)
{
    internalName = "railing_support2";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/railing_support2.dae";
    radius = "0";
    annotation = "GUARD_RAIL";
    mode = "Override";
};

datablock TSForestItemData(guardrail_support1)
{
    internalName = "guardrail_support1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/guardrail_support1.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(guardrailpost)
{
    internalName = "guardrailpost";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/guardrailpost.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(guardrail1)
{
    internalName = "guardrail1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/guardrail1.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(guardrail2)
{
    internalName = "guardrail2";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/guardrail2.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(guardrail1_white)
{
    internalName = "guardrail1_white";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/guardrail1_white.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(guardrail2_white)
{
    internalName = "guardrail2_white";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/guardrail2_white.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(guardrail1_blue)
{
    internalName = "guardrail1_blue";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/guardrail1_blue.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(guardrail2_blue)
{
    internalName = "guardrail2_blue";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/guardrail2_blue.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(guardrail1_red)
{
    internalName = "guardrail1_red";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/guardrail1_red.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(guardrail2_red)
{
    internalName = "guardrail2_red";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/guardrail2_red.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(tirestack1)
{
    internalName = "tirestack1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/tirestack1.dae";
    radius = "0";
};

datablock TSForestItemData(hr_tirestack_blue)
{
    internalName = "hr_tirestack_blue";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/hr_tirestack_blue.dae";
    radius = "0";
};

datablock TSForestItemData(hr_tirestack_white)
{
    internalName = "hr_tirestack_white";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/hr_tirestack_white.dae";
    radius = "0";
};

//-------------------------------------------SUBSTATION

datablock TSForestItemData(substation_circuitbreaker)
{
    internalName = "substation_circuitbreaker";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/substation_circuitbreaker.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(substation_lightning)
{
    internalName = "substation_lightning";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/substation_lightning.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(substation_support)
{
    internalName = "substation_support";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/substation_support.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
    
};

datablock TSForestItemData(substation_transformer)
{
    internalName = "substation_transformer";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/substation_transformer.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(substation_truss)
{
    internalName = "substation_truss";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/substation_truss.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

//-------------------------------------------INDUSTRIAL OBJECTS

datablock TSForestItemData(industrial_watertower)
{
    internalName = "industrial_watertower";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/industrial_watertower.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(workshop1)
{
    internalName = "workshop1";
    shapeFile = "levels/west_coast_usa/art/shapes/buildings/workshop1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(leanto_small)
{
    internalName = "leanto_small";
    shapeFile = "levels/west_coast_usa/art/shapes/buildings/leanto_small.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(leanto_large)
{
    internalName = "leanto_large";
    shapeFile = "levels/west_coast_usa/art/shapes/buildings/leanto_large.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(storagerack)
{
    internalName = "storagerack";
    shapeFile = "levels/west_coast_usa/art/shapes/buildings/storagerack.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(industrial_pumpjack)
{
    internalName = "industrial_pumpjack";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/industrial_pumpjack.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

//-------------------------------------------------PIPELINE

datablock TSForestItemData(pipeline_support1)
{
    internalName = "pipeline_support1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/pipeline_support1.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(pipeline_support2)
{
    internalName = "pipeline_support2";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/pipeline_support2.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

//-------------------------------------------------TOLL OBJECTS

datablock TSForestItemData(toll)
{
    internalName = "toll";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/toll.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(toll_edge)
{
    internalName = "toll_edge";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/toll_edge.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(toll_side)
{
    internalName = "toll_side";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/toll_side.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};


//-------------------------------------------POLES

datablock TSForestItemData(pole_fence1)
{
    internalName = "pole_fence1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/pole_fence1.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(pole_fence2)
{
    internalName = "pole_fence2";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/pole_fence2.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(pole_light_bridge)
{
    internalName = "pole_light_bridge";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/pole_light_bridge.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(pole_light_single)
{
    internalName = "pole_light_single";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/pole_light_single.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(pole_light_double)
{
    internalName = "pole_light_double";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/pole_light_double.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(pole_light_signal1)
{
    internalName = "pole_light_signal1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/pole_light_signal1.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(pole_traffic1)
{
    internalName = "pole_traffic1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/pole_traffic1.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(pole_thick)
{
    internalName = "pole_thick";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/pole_thick.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(pole_boom_med)
{
    internalName = "pole_boom_med";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/pole_boom_med.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(boom_trafficlight_small)
{
    internalName = "boom_trafficlight_small";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/boom_trafficlight_small.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(pole_city1)
{
    internalName = "pole_city1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/pole_city1.dae";
    radius = "0";
   annotation = "POLE";
   mode = "Override";
};

datablock TSForestItemData(pole_lighting1)
{
    internalName = "pole_lighting1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/pole_lighting1.dae";
    radius = "0";
   annotation = "POLE";
   mode = "Override";
};

datablock TSForestItemData(pole_lighting2)
{
    internalName = "pole_lighting2";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/pole_lighting2.dae";
    radius = "0";
   annotation = "POLE";
   mode = "Override";
};

datablock TSForestItemData(cable_boom)
{
    internalName = "cable_boom";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/cable_boom.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(light_city)
{
    internalName = "light_city";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/light_city.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(lamp1)
{
    internalName = "lamp1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/lamp1.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};
//-------------------------------------------BILLBOARDS

datablock TSForestItemData(billboard_structure1)
{
    internalName = "billboard_structure1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/billboard_structure1.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(billboard_structure2)
{
    internalName = "billboard_structure2";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/billboard_structure2.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(sign_rounded)
{
    internalName = "sign_rounded";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/sign_rounded.dae";
    radius = "0";
};

datablock TSForestItemData(sign_turboburger)
{
    internalName = "sign_turboburger";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/sign_turboburger.dae";
    radius = "0";
};

//-------------------------------------------TRAFFIC LIGHTS

datablock TSForestItemData(trafficlight_city1)
{
    internalName = "trafficlight_city1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/trafficlight_city1.dae";
    radius = "0";
    annotation = "TRAFFIC_SIGNALS";
    mode = "Override";
};

datablock TSForestItemData(trafficlight_city2)
{
    internalName = "trafficlight_city2";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/trafficlight_city2.dae";
    radius = "0";
    annotation = "TRAFFIC_SIGNALS";
    mode = "Override";
};

datablock TSForestItemData(trafficlight_overhead1)
{
    internalName = "trafficlight_overhead1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/trafficlight_overhead1.dae";
    radius = "0";
    annotation = "TRAFFIC_SIGNALS";
    mode = "Override";
};

datablock TSForestItemData(trafficlight_overhead2)
{
    internalName = "trafficlight_overhead2";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/trafficlight_overhead2.dae";
    radius = "0";
    annotation = "TRAFFIC_SIGNALS";
    mode = "Override";
};

datablock TSForestItemData(crosswalklight)
{
    internalName = "crosswalklight";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/crosswalklight.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

//-------------------------------------------SIDEWALK OBJECTS

datablock TSForestItemData(hydrant1)
{
    internalName = "hydrant1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/hydrant1.dae";
    radius = "0";
    annotation = "OBSTACLES";
    mode = "Override";
};

datablock TSForestItemData(bollard_yellow)
{
    internalName = "bollard_yellow";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/bollard_yellow.dae";
    radius = "0";
    annotation = "OBSTACLES";
    mode = "Override";
};

datablock TSForestItemData(bollard_hoop_red)
{
    internalName = "bollard_hoop_red";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/bollard_hoop_red.dae";
    radius = "0";
    annotation = "OBSTACLES";
    mode = "Override";
};

datablock TSForestItemData(bollard_hoop_grey)
{
    internalName = "bollard_hoop_grey";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/bollard_hoop_grey.dae";
    radius = "0";
    annotation = "OBSTACLES";
    mode = "Override";
};

datablock TSForestItemData(planterbox)
{
    internalName = "planterbox";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/planterbox.dae";
    radius = "0";
   annotation = "OBSTACLES";
    mode = "Override";
};

datablock TSForestItemData(trafficlightbox_green)
{
    internalName = "trafficlightbox_green";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/trafficlightbox_green.dae";
    radius = "0";
    annotation = "OBSTACLES";
    mode = "Override";
};

datablock TSForestItemData(postbox_blue)
{
    internalName = "postbox_blue";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/postbox_blue.dae";
    radius = "0";
    annotation = "OBSTACLES";
    mode = "Override";
};

datablock TSForestItemData(gaspump)
{
    internalName = "gaspump";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/gaspump.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

//-------------------------------------------CONSTRUCTION OBJECTS

datablock TSForestItemData(dumpster)
{
    internalName = "dumpster";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/dumpster.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(sandbarrel)
{
    internalName = "sandbarrel";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/sandbarrel.dae";
    radius = "0";
    annotation = "OBSTACLES";
    mode = "Override";
};

datablock TSForestItemData(constructionbarrier)
{
    internalName = "constructionbarrier";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/constructionbarrier.dae";
    radius = "0";
    annotation = "ROADBLOCK";
    mode = "Override";
};

datablock TSForestItemData(jerseybarrier_3m)
{
    internalName = "jerseybarrier_3m";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/jerseybarrier_3m.dae";
    radius = "0";
    annotation = "ROADBLOCK";
    mode = "Override";
};

datablock TSForestItemData(jerseybarrier_end)
{
    internalName = "jerseybarrier_end";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/jerseybarrier_end.dae";
    radius = "0";
    annotation = "ROADBLOCK";
    mode = "Override";
};

datablock TSForestItemData(spool)
{
    internalName = "spool";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/spool.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

datablock TSForestItemData(pallet)
{
    internalName = "pallet";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/pallet.dae";
    radius = "0";
    annotation = "BUILDINGS";
    mode = "Override";
};

//-------------------------------------------ROAD SIGNS

datablock TSForestItemData(sign_truss1)
{
    internalName = "sign_truss1";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/sign_truss1.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(sign_truss2)
{
    internalName = "sign_truss2";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/sign_truss2.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(sign_truss3)
{
    internalName = "sign_truss3";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/sign_truss3.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};

datablock TSForestItemData(sign_truss4)
{
    internalName = "sign_truss4";
    shapeFile = "levels/west_coast_usa/art/shapes/objects/sign_truss4.dae";
    radius = "0";
    annotation = "POLE";
    mode = "Override";
};




datablock TSForestItemData(excavator)
{
   internalName = "excavator";
   shapeFile = "levels/west_coast_usa/art/shapes/objects/excavator.dae";
};
