local M = {}

-- figure out whether drag racing mode should be active or not (e.g. it should be disabled while during bus missions)
local function mustBeRunning()
  if career_career and career_career.isEnabled() then return false end
  if scenario_scenarios then return false end
  if scenario_busdriver then return false end
  local st = core_gamestate and core_gamestate.state and core_gamestate.state.state
  if st == nil then return true end
  if st ~= "freeroam" then return false end
  return true
end

-- make sure drag racing mode is active only at appropriate times
local function ensureRunningState()
  local isRunning = freeroam_dragRace ~= nil
  local mustRun = mustBeRunning()
  if mustRun ~= isRunning then
    if mustRun then
      extensions.unload("freeroam_dragRace")
      extensions.load("freeroam_dragRace")
      freeroam_dragRace.setLevel("west_coast_usa")
      --M.onBeamNGTrigger = onBeamNGTrigger
      extensions.refresh('mainLevel')
    else
      extensions.unload("freeroam_dragRace")
      ui_missionInfo.closeDialogue()
      --M.onBeamNGTrigger = nop
      extensions.refresh('mainLevel')
    end
  end
end

M.onClientPostStartMission = ensureRunningState
M.onClientEndMission       = ensureRunningState
M.onCareerEnabledChanged   = ensureRunningState
M.onDeserialize            = ensureRunningState
M.onSerialize = function() return {} end -- our only purpose is to enable onDeserialize function, so ctrl+L will reflect changes to the code in this file (while a developer is tweaking this file)

return M
