angular.module('beamng.apps')
.directive('masuostt', [function () {
  return {
    templateUrl: '/ui/modules/apps/masuostt/app.svg',
    replace: true,
    link: function (scope, element, attrs) {
		var streamsList = ['engineInfo', 'electrics']
		StreamsManager.add(streamsList)

		scope.$on('$destroy', function () {
			StreamsManager.remove(streamsList)
		})

		const mapSwitches = [0,1,1,2,3,2,3,4,5,4,5,6,6,7,8,9,10,11,10,11,12,12,13]
		const mapSwToSw =   [0,2,1,5,6,3,4,9,10,7,8,12,11,0,0,0,18,19,16,17,21,20,0]
		const mapSemaphores = ["#000000","#ff0000","#88ff88","#88ff88","#ff8800","#ffff00","#ffff00","#888800","#888888","#ffffff","#000000"]
		const mapSemaphoresToTacks = ["", "stS2","stS1","st5","st3","st1","st2","st4","st4","st2","st1","st3","st5","stG","stJ"]
		var routesOccupations = [
			["stS2c", "sw1M", "st12", "sw6M", "st32"], //0
			["stS2c", "sw1D", "sw2D", "sw3M", "sw4D", "sw6D", "st32"],
			["st32b", "sw8M", "st2p"],
			["st32b", "sw8D", "sw10D", "st4p"],
			["stS2c", "sw1D", "sw2D", "sw3M", "sw4M", "st1p"],
			["stS1c", "sw2M", "sw3M", "sw4D", "sw6D", "st32"], //5
			["stS1c", "sw2M", "sw3M", "sw4M", "st1p"],
			["stS2c", "sw1D", "sw2D", "sw3D", "sw5D", "sw7M", "st3p"],
			["stS1c", "sw2M", "sw3D", "sw5D", "sw7D", "sw9D", "st5p"],
			["stS1c", "sw2M", "sw3D", "sw5D", "sw7M", "st3p"],
			["stS2c", "sw1D", "sw2D", "sw3D", "sw5D", "sw7D", "sw9D", "st5p"], //10
			["st5p", "sw9D", "sw7D", "sw5M", "st13b"],
			["st3p", "sw7M", "sw5M", "st13b"],
			["st5p", "sw9M", "sw11M", "st15b"],
			["st15b", "sw11D", "sw12D", "st7p"],
			["sw12M","st7p"], //15
			["st42","sw16M","st22","sw21M","stJc"],
			["st42","sw16D","sw18D","sw19M","sw20D","sw21D","stJc"],
			["st42a", "sw14M", "st2a"],
			["st42a", "sw14D", "st4a"],
			["stJc", "sw21D", "sw20D", "sw19M", "sw18M", "st1a"], //20
			["st42","sw16D","sw18D","sw19M","sw20M","stGc"],
			["st1a","sw18M","sw19M","sw20M","stGc"],
			["stJc","sw21D","sw20D","sw19D","sw17D","sw15M","st3a"],
			["stGc","sw20M","sw19D","sw17D","sw15D","st25","sw13M","st5a"],
			["stGc","sw20M","sw19D","sw17D","sw15M","st3a"], //25
			["stJc","sw21D","sw20D","sw19D","sw17D","sw15D","st25","sw13M","st5a"],
			["stGc","sw20M","sw19D","sw17D","sw15D","st25","sw13D","st7a"],
			["stJc","sw21D","sw20D","sw19D","sw17D","sw15D","st25","sw13D","st7a"],
			["st23a","sw17M","sw15D","st25","sw13M","st5a"],
			["st23a","sw17M","sw15M","st3a"], //30
			["st23a","sw17M","sw15D","st25","sw13D","st7a"],
		];

		routesOccupations[101] = ["stS2b"];
		routesOccupations[102] = ["stS1b"];
		routesOccupations[103] = ["stS2"];
		routesOccupations[104] = ["stS1"];
		routesOccupations[111] = ["stJb"];
		routesOccupations[112] = ["stGb"];
		routesOccupations[113] = ["stJ"];
		routesOccupations[114] = ["stG"];
		routesOccupations[201] = ["st1"];
		routesOccupations[202] = ["st2"];
		routesOccupations[203] = ["st3"];
		routesOccupations[204] = ["st4"];
		routesOccupations[205] = ["st5"];
		routesOccupations[207] = ["st7"];
		routesOccupations[213] = ["st13"];
		routesOccupations[215] = ["st15"];
		routesOccupations[217] = ["st17"];
		routesOccupations[223] = ["st23"];

		const routesSets = [
			[],
			// the last element in each array is the next semaphore id

			// TRAIN ROUTES - SEMS //
			// P-END SIDE
			[[101,0,2,202,9],[101,1,2,202,9],[101,0,3,204,8],[101,1,3,204,8],[101,4,201,10],[101,7,203,11],[101,10,205,12]], // 1/A
			[[102,5,2,202,9],[102,5,3,204,8],[102,6,201,10],[102,8,205,12],[102,9,203,11]], // 2/B
			[[8,102,104,0],[10,101,103,0]], // 3/C
			[[9,102,104,0],[7,101,103,0]], // 4/D
			[[6,102,104,0],[4,101,103,0]], // 5/E
			[[2,5,102,104,0],[2,0,101,103,0],[2,1,101,103,0]], // 6/F
			[[3,5,102,104,0],[3,0,101,103,0],[3,1,101,103,0]], // 7/G
			// A-END SIDE
			[[19,21,112,114,0],[19,16,111,113,0],[19,17,111,113,0]], // 8/H
			[[18,21,112,114,0],[18,16,111,113,0],[18,17,111,113,0]], // 9/I
			[[22,112,114,0],[20,111,113,0]], // 10/J
			[[25,112,114,0],[23,111,113,0]], // 11/K
			[[26,111,113,0],[24,112,114,0]], // 12/L
			[[112,21,18,202,6],[112,21,19,204,7],[112,22,201,5],[112,24,205,3],[112,25,203,4],[112,27,207,19]], // 13/M
			[[111,16,18,202,6],[111,17,18,202,6],[111,16,19,204,7],[111,17,19,204,7],[111,20,201,5],[111,23,203,4],[111,26,205,3],[111,28,207,19]], // 14/M
			// TRAIN ROUTES - DWARFS //
			// empty ofc
			[],[],[],[],[],[],

			// SHUNTING ROUTES - SEMS //
			// P-END SIDE
			[],[],
			[[13,215],[11,213],[8,102],[10,101]], // 3/C
			[[12,213],[9,102],[7,101]], // 4/D
			[[6,102],[4,101]], // 5/E
			[[2,5,102],[2,0,101],[2,1,101]], // 6/F
			[[3,5,102],[3,0,101],[3,1,101]], // 7/G
			// A-END SIDE
			[[19,21,112],[19,16,111],[19,17,111]], // 8/H
			[[18,21,112],[18,16,111],[18,17,111]], // 9/I
			[[22,112],[20,111]], // 10/J
			[[25,112],[23,111],[30,223]], // 11/K
			[[26,111],[24,112],[29,223]], // 12/L
			[],[],

			// SHUNTING ROUTES - DWARFS //
			// P-END SIDE //
			[[0],[1],[4,201],[7,203],[10,205]], // 15/Tm1
			[[5],[6,201],[8,205],[9,203]], // 16/Tm2
			[[14,207],[13,205]], // 17/Tm3
			[[12,203],[11,205]], // 18/Tm4
			[[14,215],[15,217]], // 19/Tm5
			[[2,202],[3,204]], // 20/Tm6
			// A-END SIDE //
			[[28,111],[27,112],[31,223]], // 21/Tm7
			[[18,202],[19,204]], // 22/Tm8
			[[30,203],[29,205],[31,207]], // 23/Tm9
			[[21],[22,201],[25,203],[24,205],[27,207]], // 24/Tm10
			[[16],[17],[20,201],[23,203],[26,205],[28,207]] // 25/Tm11
		];
		let swPlusBtns = []
		let swMinusBtns = []
		let sblDirBtns = []
    let spawnBtns = []
		var swUpdate = []
		var sblDirections = []
		var trackOccupied = Array()
		let semBtns = []
		let svg = element[0]
		var swStatus = []
		var semStatus = []
		var semMode = 0
		let semModeBtns = []
		let semOSRMBtn;
		let visBtn;
		var uiVisible = true;
		var safeRoutesMode = true;
		var needReset = true;
		var needSetup = true;
		var checkMasuostt;
    var spawnLocked = false;

		function clearRoute(sem)
		{
			Object.keys(trackOccupied).forEach(function(key) {
				if(trackOccupied[key] == sem)
				{
					trackOccupied[key] = 0
				}
			});
		}

		function clearAllRoutes()
		{
			Object.keys(trackOccupied).forEach(function(key) {
				clearRoute(trackOccupied[key])
			});
		}

		function visualizeOccupies()
		{
			Object.keys(trackOccupied).forEach(function(key) {
				svg.getElementById(key).style.fill = (trackOccupied[key]!=0) ? "#484" : "#fff"
				if(key.startsWith("sw") && trackOccupied[key] == 0)
				{
					if(
						(swStatus[key.substr(2,key.length-3)] == 1 && key.endsWith("M")) ||
						(swStatus[key.substr(2,key.length-3)] == 0 && key.endsWith("D"))
					) svg.getElementById(key).style.fill = "#f80"
				}
			});
		}

		// MAIN ROUTES //
		// 0 - sem15 - sem20		// 16 - sem25 - sem22
		// 1 - sem15 - sem20 alt	// 17 - sem25 - sem22 alt
		// 2 - sem20 - sem6			// 18 - sem22 - sem9
		// 3 - sem20 - sem7			// 19 - sem22 - sem8
		// 4 - sem15 - sem5			// 20 - sem25 - sem10
		// 5 - sem16 - sem20		// 21 - sem24 - sem22
		// 6 - sem16 - sem5			// 22 - sem24 - sem10

		// CARGO ENTRANCE //
		// 7 - sem15 - sem4			// 23 - sem25 - sem11
		// 8 - sem16 - sem3			// 24 - sem24 - sem12
		// 9  - sem4  - sem16		// 25 - sem24 - sem11
		// 10 - sem3  - sem15		// 26 - sem25 - sem12
									// 27 - sem24 - sem21
									// 28 - sem25 - sem21

		// INSIDE CARGO //
		// 11 - sem3  - sem18		// 29 - sem12 - sem23
		// 12 - sem4  - sem18		// 30 - sem11 - sem23
									// 31 - sem21 - sem23

		// INSIDE P-END CARGO //
		// 13 - sem3  - sem17
		// 14 - sem17 - sem19
		// 15 - sem19 - pktB

		// TRACKS //
		// 101 - sem1 - sem15		// 111 - sem14 - sem25
		// 102 - sem2 - sem16		// 112 - sem13 - sem24
		// 103 - S2   - sem1		// 113 - J     - sem25
		// 104 - S1   - sem2		// 114 - G     - sem24

		// 201 - track1
		// 202 - track2
		// 203 - track3
		// 204 - track4
		// 205 - track5
		// 207 - track7
		// 213 - track13
		// 215 - track15
		// 217 - track17

		function findRouteSet(sem)
		{
			for(var i = 0; i < routesSets[sem].length; i++) //dla kazdego routesetu dla tego sem
			{
				var currentRoutesSet = routesSets[sem][i]
				var routesetcorrect = true;

				for(var j = 0; j < currentRoutesSet.length; j++) //dla kazdej trasy z routesetu
				{
					if(sem<20 && j == currentRoutesSet.length-1)
						break;

					var currentRouteID = currentRoutesSet[j]
					var currentOccupationSet = routesOccupations[currentRouteID]

					if(
						(currentRouteID == 103 && sblDirections[1] == 1) ||
						(currentRouteID == 104 && sblDirections[0] == 0)
					)
					{
						routesetcorrect = false
						break;
					}

					for(var k = 0; k < currentOccupationSet.length; k++) //dla kazdej okupacji z trasy
					{
						var currentOccupation = currentOccupationSet[k]

						if(currentOccupation.startsWith("sw"))
						{
							var ocLength = currentOccupation.length
							var currentSwitchStatus = swStatus[currentOccupation.substr(2,ocLength-3)]
							var currentSwitchOccupationLL = currentOccupation.substr(ocLength-1,ocLength-1)

							if(currentSwitchStatus != (currentSwitchOccupationLL=="M") ? 1 : 0)
							{
								routesetcorrect = false
								break;
							}
						}
					}

					if(!routesetcorrect)
						break;
				}

				if(routesetcorrect)
					return currentRoutesSet
			}
			return 0;
		}

		function occupyFields(routesSet, sem)
		{
			var limited = 0
			var nextlimited = 0

			for(var k = 0; k < routesSet.length; k++) //dla kazdej trasy z routesetu
			{
				if(sem<20 && k == routesSet.length-1)
				{
					var nextSemStatus = semStatus[routesSet[k]]
					if(routesSet[k] > 0)
					{
						if(nextSemStatus == 1 || nextSemStatus > 7)
							nextlimited = 2
						else if(nextSemStatus >= 5)
							nextlimited = 1
					}

					break;
				}

				var currentOccupationSet = routesOccupations[routesSet[k]]

				for(var j = 0; j < currentOccupationSet.length; j++) //dla kazdej okupacji z trasy
				{
					if(trackOccupied[currentOccupationSet[j]] > 0)
					{
						bngApi.activeObjectLua('gui.message("This route is already in use!")');
						return -1;
					}
					trackOccupied[currentOccupationSet[j]] = sem
					if(currentOccupationSet[j].endsWith("D")) limited = 1;
				}
			}

			return [limited, nextlimited];
		}

		function setInternalSemStatus(sem, status)
		{
			semStatus[sem] = status
			semBtns[sem][0].style.fill = mapSemaphores[status];
			if(status == 1 && sem >= 15)
			{
				semBtns[sem][0].style.fill = "#0000ff"
			}
		}

		function updateRoute(sem, semState)
		{
			clearRoute(sem)
			clearRoute(sem+20)
			var signalID = 1 + (semState==3)*7
			var offset = 0

			if(semState < 2)
			{
				if(semState == 1)
					offset=20 // shunting mode

				var currentRoutesSet = findRouteSet(sem + offset)

				if(currentRoutesSet !== 0)
				{
					var signalParameters = occupyFields(currentRoutesSet, sem + offset)

					if(signalParameters != -1)
					{
						var signalID = 2 + (signalParameters[0]*3) + signalParameters[1]
						if(semState==1) signalID = 9
					}
					else
						clearRoute(sem+offset)
				}
			}

			bngApi.activeObjectLua('controller.getController(\'masuostt\').semApply(' + sem + ','+ signalID +')');
			setInternalSemStatus(sem, signalID)

			var trackBeforeOc = trackOccupied[mapSemaphoresToTacks[sem]]
			if(sem+offset < 33 && trackBeforeOc > 0 && trackBeforeOc < 20)
			{
				updateRoute(trackBeforeOc, 0)
			}

			visualizeOccupies()
		}

		function checkSRM(swid)
		{
			return !(
				safeRoutesMode &&
				(
					trackOccupied["sw"+swid+"M"]>0 ||
					trackOccupied["sw"+swid+"D"]>0 ||
					trackOccupied["sw"+mapSwToSw[swid]+"M"]>0 ||
					trackOccupied["sw"+mapSwToSw[swid]+"D"]>0
				)
			)
		}

		function updateRoutesToSwitches()
		{
			Object.keys(trackOccupied).forEach(function(key) {
				if(key.startsWith("sw") && trackOccupied[key] > 0)
				{
					if(
						(key.endsWith("M") && Math.round(swStatus[key.substr(2,key.length-3)]) == 0) ||
						(key.endsWith("D") && Math.round(swStatus[key.substr(2,key.length-3)]) == 1)
					)
					{
						clearRoute(trackOccupied[key]);
					}
				}
			});

			visualizeOccupies()
		}

		function setup()
		{
			for(var i = 1; i <= 22; i++)
			{
				swPlusBtns[i] = angular.element(svg.getElementById('sw'+i+'M'));
				swMinusBtns[i] = angular.element(svg.getElementById('sw'+i+'D'));
			}

			for(var i = 1; i <= 25; i++)
			{
				semBtns[i] = angular.element(svg.getElementById('sem_'+i));
			}

			for(var i = 0; i < 4; i++)
			{
				semModeBtns[i] = angular.element(svg.getElementById('semm_'+i));
			}

      for(var i = 0; i < 4; i++)
			{
				spawnBtns[i] = angular.element(svg.getElementById('spawn_'+i));
			}

			for(var i = 2; i < 6; i++)
			{
				sblDirBtns[i] = angular.element(svg.getElementById('sbl'+Math.floor(i/2)+'dir'+i%2));
			}

			semOSRMBtn = angular.element(svg.getElementById('semo_srm'));
			visBtn = angular.element(svg.getElementById('visbtn'));

			swPlusBtns.forEach(function (el, i) {
				el.on('mousedown', function () {
					if(checkSRM(i))
						bngApi.activeObjectLua('controller.getController(\'masuostt\').switchPlus(' + mapSwitches[i] + ')');
				})
			})

      spawnBtns.forEach(function (el, i) {
				el.on('mousedown', function () {
          if(spawnLocked == false)
          {
            spawnLocked = true;
            var loco = el[0].attributes["loco"].value;
            var displayloco = el[0].attributes["displayloco"].value;
            var locox = parseFloat(el[0].attributes["locox"].value);
            var locoy = parseFloat(el[0].attributes["locoy"].value);
            var locoz = parseFloat(el[0].attributes["locoz"].value);

            bngApi.activeObjectLua('gui.message("Spawning ' + displayloco + ' at ' + locox + ', ' + locoy + ', ' + locoz + '", 5, "spawn'+i+'")');
            bngApi.engineLua('core_vehicles.spawnNewVehicle("'+loco+'",{}):setPosRot('+locox+','+locoy+','+locoz+',0,0,0,0)');
          }
				})
			})

			sblDirBtns.forEach(function (el, i) {
				el.on('mousedown', function () {
					if(!(safeRoutesMode && (
						(trackOccupied["stS2"] && Math.floor(i/2) == 2) ||
						(trackOccupied["stS1"] && Math.floor(i/2) == 1))
					))
					{
						bngApi.activeObjectLua('controller.getController(\'masuostt\').setSBLDirection(' + Math.floor(i/2) + ',' + i%2 + ')');
						sblDirections[Math.floor(i/2)] = i%2;
					}
				})
			})

			swMinusBtns.forEach(function (el, i) {
				el.on('mousedown', function () {
					if(checkSRM(i))
						bngApi.activeObjectLua('controller.getController(\'masuostt\').switchMinus(' + mapSwitches[i] + ')');
				})
			})

			semBtns.forEach(function (el, i) {
				el.on('mousedown', function (eventData) {
          if(eventData.button == 2)
            updateRoute(i, 2);
					else if(i >= 15 && (semMode == 0 || semMode == 3))
						bngApi.activeObjectLua('gui.message("Dwarf semaphores can only display shunting routes!")');
					else if((i <= 2 || i==13 || i==14)&&semMode==1)
						bngApi.activeObjectLua('gui.message("Entrance semaphores cannot dsplay shunting routes!")');
					else
					{
						updateRoute(i, semMode);
					}
				});
			})

			semModeBtns.forEach(function (el, i) {
				el.on('mousedown', function () {
					semModeBtns[semMode][0].style.fill = "#fff"
					semMode = i;
					semModeBtns[semMode][0].style.fill = "#f80"
				});
			})

			visBtn.on('mousedown', function () {
				uiVisible = !uiVisible;

				visBtn[0].style.fill = uiVisible ? "#f80" : "#fff"
				svg.getElementById("mttui").style.display = uiVisible ? "unset" : "none"

			})

			semOSRMBtn.on('mousedown', function () {
				safeRoutesMode = !safeRoutesMode;

				semOSRMBtn[0].style.fill = safeRoutesMode ? "#f80" : "#fff"

			})
		}

		function reset() {
			if(checkMasuostt != undefined)
			{
				svg.style.display = "unset"

				if(needSetup)
				{
					setup()
					needSetup = false;
				}

				visualizeOccupies();
				console.log("masuostt app set!")
				needReset = false;
			}
			else
			{
				svg.style.display = "none"
        spawnLocked = false;
			}
		}

    scope.$on('streamsUpdate', function (event, streams) {
			if(needReset)
			{
				checkMasuostt = streams.electrics["swctrlr_1_turna"];
				reset();
			}
			else
			{
				for(var i = 1; i <= 22; i++)
				{
					var swStatusNow = streams.electrics['swctrlr_'+mapSwitches[i]+'_turnb']

					if(swStatus[i] != swStatusNow)
					{

						// at the end
						if(swStatusNow == Math.round(swStatusNow))
						{
							updateRoutesToSwitches()
						}

						swPlusBtns[i][0].style.fill = swStatusNow==1 ? "#f80" : "#fff";
						swMinusBtns[i][0].style.fill = swStatusNow==0 ? "#f80" : "#fff";

						swStatus[i] = swStatusNow;
					}
				}
        /*
        for(var i = 1; i <= 25; i++)
        {
          if(streams.electrics['trigger_sem_'+i] == true)
          {
            console.log(i);
            bngApi.activeObjectLua('electrics.values["trigger_sem_'+i+'"] = false');
          }
        }
        */
				sblDirections = [streams.electrics['sbl1direction'], streams.electrics['sbl2direction']]

				sblDirBtns[2][0].style.fill = sblDirections[0] ? "000" : "c8c8c8"
				sblDirBtns[3][0].style.fill = sblDirections[0] ? "c8c8c8" : "000"
				sblDirBtns[4][0].style.fill = sblDirections[1] ? "000" : "c8c8c8"
				sblDirBtns[5][0].style.fill = sblDirections[1] ? "c8c8c8" : "000"

				for(var i = 1; i <= 25; i++)
				{
					var semStatusNow = streams.electrics["sem_"+i+"_state"]
					if(semStatusNow != semStatus[i])
						setInternalSemStatus(i, semStatusNow)
				}
			}
        })

		scope.$on('VehicleChanged', function () {
			needReset = true;
		})

		scope.$on('VehicleReset', function () {
			clearAllRoutes()
			needReset = true;
		})

		scope.$on('VehicleFocusChanged', function () {
			needReset = true;
		})

		scope.toctrlr = function(command)
		{
			bngApi.activeObjectLua('controller.getController(\'masuostt\').' + command)
		}

    }
  }
}]);
