local M = {}
M.type = "main"

local switch_settarget = {}
local switchselected = 1
local semselected = 1
local signselected = 1
local sem_types = {	5,5,5,5,5,5,5,4,4,4,4,4,5,5,1,1,1,1,1,1,1,1,1,1,1}
local sem_sign = {}
local sem_prevsign = {}
local sbls = {"21","21n","22","22n","37","37n","38","38n","ton"}
local sbldirection = {0,0}
local prevsign = {4,2,2,2,3,3,3,4,4}

local _switchescount = 13
local _semcount = 25
local _semvalcount = 9
local _tmminus = 14
local _sblcount = 8

local blinkTimer = 0;

local switch_names = {
	"Switches #1 and #2",
	"Switches #3 and #5",
	"Switches #4 and #6",
	"Switches #7 and #9",
	"Switches #10 and #8",
	"Switches #11 and #12",
	"Switch #13",
	"Switch #14",
	"Switch #15",
	"Switches #16 and #18",
	"Switches #17 and #19",
	"Switches #20 and #21",
	"Switch #22 (Outside)"
}

local sign_names = {
	"S1/Ms1 - Stop",
	"S2 - VMax, then still VMax",
	"S4 - VMax now, then 40km/h",
	"S5 - Stop at next semaphore",
	"S10 - 40km/h now, then VMax",
	"S12 - 40km/h now, then 40km/h",
	"S13 - 40km/h now, stop at next semaphore",
	"Sz - Semaphore malfunction, 40km/h max",
	"Ms2 - Shunting allowed, 25km/h max",
}

local function updateSem(prefix, sign)
	for j=1, 5 do
			electrics.values[prefix .. j] = 0
	end
			
	if sign == 1 then -- are there even switch statements in lua ?!?
		electrics.values[prefix .. "3"] = 1
	end
	if sign == 2 then
		electrics.values[prefix .. "1"] = 1
	end
	if sign == 3 then
		electrics.values[prefix .. "2"] = blinkTimer > 0.5
	end
	if sign == 4 then
		electrics.values[prefix .. "2"] = 1
	end
	if sign == 5 then
		electrics.values[prefix .. "1"] = 1
		electrics.values[prefix .. "4"] = 1
	end
	if sign == 6 then
		electrics.values[prefix .. "2"] = blinkTimer > 0.5
		electrics.values[prefix .. "4"] = 1
	end
	if sign == 7 then
		electrics.values[prefix .. "2"] = 1
		electrics.values[prefix .. "4"] = 1
	end
	if sign == 8 then
		electrics.values[prefix .. "3"] = 1
		electrics.values[prefix .. "5"] = blinkTimer > 0.5
	end
	
	if sign == 9 then
		electrics.values[prefix .. "5"] = 1
	end
end

local function init(jbeamData)
	for i=1, _switchescount do
		electrics.values['swctrlr_' .. i .. '_turna'] = 0
		electrics.values['swctrlr_' .. i .. '_turnb'] = 1
		switch_settarget[i] = -1
	end
	
	for i=1, _semcount do
		sem_sign[i] = 1
		sem_prevsign[i] = 0
		electrics.values["sem_" .. i .. "_state"] = 1
	end
	
	for i=0, (_sblcount*3)-1 do
		electrics.values['semctrlr_sbl' .. sbls[math.floor(i/3)+1] .. '_' .. (i % 3)+1] = i % 3 == 0
	end
	
	for i=3, 7 do
		electrics.values['semctrlr_' .. i .. '_w24'] = 0;
	end
	
	electrics.values["sbl1direction"] = 0
	electrics.values["sbl2direction"] = 0
	
	updateSem('semctrlr_sbl21n_', 0)
	updateSem('semctrlr_sbl22n_', 0)
	updateSem('semctrlr_sbl37n_', 0)
	
	switchselected = 1
	semselected = 1
	signselected = 1
end

local function updateW24(semid)

	if semid == 3 then
		electrics.values['semctrlr_3_w24'] = (switch_settarget[4] == 1 and switch_settarget[2] == 1 and switch_settarget[1] == -1)
	end
	
	if semid == 4 then
		electrics.values['semctrlr_4_w24'] = (switch_settarget[4] == -1 and switch_settarget[2] == 1 and switch_settarget[1] == -1)
	end
	
	if semid == 5 then
		electrics.values['semctrlr_5_w24'] = (switch_settarget[2] == -1 and switch_settarget[1] == -1)
	end
	
	if semid == 6 then
		electrics.values['semctrlr_6_w24'] = (switch_settarget[3] == 1 and switch_settarget[1] == -1)
	end
	
	if semid == 7 then
		electrics.values['semctrlr_7_w24'] = (switch_settarget[5] == 1 and switch_settarget[3] == 1 and switch_settarget[1] == -1)
	end
	
	if sem_sign[semid] > 8 or sem_sign[semid] == 1 then
		electrics.values['semctrlr_' .. semid .. '_w24'] = 0
	end
end

local function updateSems()
	
	for i=1, _semcount do
		if sem_sign[i] ~= sem_prevsign[i] or sem_sign[i] == 3 or sem_sign[i] == 6 or sem_sign[i] == 8 then
			updateSem('semctrlr_' .. i .. '_', sem_sign[i])
			sem_prevsign[i] = sem_sign[i]
		end
	end
	
	updateSem('semctrlr_sblton_', prevsign[sem_sign[14]])
	updateSem('semctrlr_sbl37_', prevsign[sem_sign[2]])
	updateSem('semctrlr_sbl38n_', prevsign[sem_sign[1]])
end

local function setSBLDirection(sbl, direction)
	if sbldirection[sbl] ~= direction*2 then
		sbldirection[sbl] = direction*2
	
		updateSem('semctrlr_sbl21_', (2 - sbldirection[1]))
		updateSem('semctrlr_sbl21n_', (sbldirection[1]))
		updateSem('semctrlr_sbl22_', (2 - sbldirection[2]))
		updateSem('semctrlr_sbl22n_', (sbldirection[2]))
		updateSem('semctrlr_sbl37n_', (sbldirection[1]))
		updateSem('semctrlr_sbl38_', (2 - sbldirection[2]))
	
		electrics.values["sbl" .. sbl .. "direction"] = direction
		gui.message("Direction of the track has been changed" , 4, sbl.."direction")
	end
end

local function switchPlus(switchid)
	if switchid == -1 then
		switchid = switchselected
	end

	if switch_settarget[switchid] == 1 then
		switch_settarget[switchid] = -1 
		gui.message((switch_names[switchid] .. " switched into the main line (+)"), 4, switchid.."switch")
	end
end

local function switchMinus(switchid)
	if switchid == -1 then
		switchid = switchselected
	end

	if switch_settarget[switchid] == -1 then
		switch_settarget[switchid] = 1
		gui.message((switch_names[switchid] .. " switched into the diverging line (-)"), 4, switchid.."switch")
	end
end

local function switchSwitch(switchid)
	if switchid == -1 then
		switchid = switchselected
	end

	if switch_settarget[switchid] == 1 then
		switchPlus(switchid)
	else
		switchMinus(switchid)
	end
end

local function switchSelect()
	switchselected = switchselected + 1
	if switchselected > _switchescount then switchselected = 1 end
	gui.message((switch_names[switchselected] .. " selected"), 2, "switch")
end

local function semSelectMsg(sem)
	local semname = ""

	if sem_types[sem] == 1 then semname = "Tm" .. tostring(sem-_tmminus) 
	else semname = string.char(sem+64) end
	
	return semname
end

local function semSelectN()
	semselected = semselected + 1
	if semselected > _semcount then semselected = 1 end
	
	gui.message(("Semaphore " .. semSelectMsg(semselected) .. " selected"), 2, "sem")
end

local function semSelectP()
	semselected = semselected - 1
	if semselected < 1 then semselected = _semcount end
	
	gui.message(("Semaphore " .. semSelectMsg(semselected) .. " selected"), 2, "sem")
end

local function signSelect()
	signselected = signselected + 1
	if signselected > _semvalcount then signselected = 1 end
	gui.message(("Signal \"" .. sign_names[signselected] .. "\" selected. Remember to apply!"), 4, "sign")
end

local function semApply(semid, sigid)
	if semid == -1 then
		semid = semselected
	end
	
	if sigid == -1 then
		sigid = signselected
	end

	local semprefix = 'semctrlr_' .. semid .. '_'
	
	gui.message(("Displaying \"" .. sign_names[sigid] .. "\" on the semaphore " .. semSelectMsg(semid)), 4, semid.."sem")
	
	sem_sign[semid] = sigid
	
	if sigid > 1 and sigid < 9 and sem_types[semid] == 1 then
		gui.message(("You can't display it on this semaphore. Displaying Ms2 instead"), 4, semid.."semerror")
		sem_sign[semid] = 9
	end
	if (sigid == 3 or sigid == 4) and sem_types[semid] == 4 then
		gui.message(("You can't display it on this semaphore. Displaying S2 instead"), 4, semid.."semerror")
		sem_sign[semid] = 2
	end
	if (sigid == 6 or sigid == 7) and sem_types[semid] == 4 then
		gui.message(("You can't display it on this semaphore. Displaying S10 instead"), 4, semid.."semerror")
		sem_sign[semid] = 5
	end
	
	electrics.values["sem_" .. semid .. "_state"] = sem_sign[semid]
	updateW24(semid)
end
	
local function updateGFX(dt)

	blinkTimer = blinkTimer + dt
	if blinkTimer > 1 then
		--print("blink!")
		blinkTimer = 0
	end
	
	updateSems()

	-- SWITCHES UPDATE --
	
	for i=1, _switchescount do
		local target = math.max(0, math.min(1, electrics.values['swctrlr_' .. i .. '_turna'] + (switch_settarget[i] * dt)))
		electrics.values['swctrlr_' .. i .. '_turna'] = target
		electrics.values['swctrlr_' .. i .. '_turnb'] = 1 - target 
    end
end

M.init    = init
M.updateGFX = updateGFX

M.switchSelect = switchSelect
M.switchSwitch = switchSwitch
M.switchPlus = switchPlus
M.switchMinus = switchMinus

M.setSBLDirection = setSBLDirection

M.semSelectN = semSelectN
M.semSelectP = semSelectP

M.signSelect = signSelect
M.semApply = semApply

return M
