ScriptName Aurie:AOS:OutfitEffectScript Extends ActiveMagicEffect Hidden

Group AutoFill
    FormList Property AOS_FLST_Outfit_AllLists Auto Mandatory
    FormList Property AOS_FLST_Outfit_Master Auto Mandatory
    GlobalVariable Property AOS_GLOB_OutfitSwitcherMode Auto Mandatory
    Message Property AOS_MESG_EquipOutfit Auto Mandatory
    Message Property AOS_MESG_EquipOutfitRemove Auto Mandatory
    Message Property AOS_MESG_SaveOutfit Auto Mandatory
    Message Property AOS_MESG_SaveOutfitOverride Auto Mandatory
    Perk Property AOS_PERK_OutfitSwitcher Auto Mandatory
    Actor Property PlayerRef Auto Const Mandatory
    Int Property TotalAvailableOutfits Auto Const Mandatory
EndGroup

Int selectedOutfit = 10
Bool bRemoveAll = false

Event OnEffectStart(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, Float afMagnitude, Float afDuration)
    ShowOutfitChoices()
EndEvent

Event OnEffectFinish(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, Float afMagnitude, Float afDuration)

EndEvent

Function ShowOutfitChoices()
    If AOS_GLOB_OutfitSwitcherMode.GetValue() == 1.0 
        selectedOutfit = AOS_MESG_SaveOutfit.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
        If selectedOutfit < TotalAvailableOutfits
            SaveOutfit(selectedOutfit)
        ElseIf selectedOutfit == TotalAvailableOutfits  
            ; User Cancelled. Reset the global
            AOS_GLOB_OutfitSwitcherMode.SetValue(0.0)  
        EndIf
    ElseIf AOS_GLOB_OutfitSwitcherMode.GetValue() == 2.0
        selectedOutfit = AOS_MESG_EquipOutfit.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
        If selectedOutfit < TotalAvailableOutfits
            bRemoveAll = AOS_MESG_EquipOutfitRemove.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0) as bool
            EquipOutfit(selectedOutfit, bRemoveAll)
        ElseIf selectedOutfit == TotalAvailableOutfits  
            ; User Cancelled. Reset the global
            AOS_GLOB_OutfitSwitcherMode.SetValue(0.0)  
        EndIf
    EndIf
EndFunction

Function SaveOutfit(Int theOutfit)
    Formlist currentFormList = GetOutfitFormList(theOutfit)
    ; First check to make sure we have a valid formlist
    If currentFormList
        ; Check to see if there is already an outfit stored in the formlist and prompt player if it should be overwritten
        If OutfitExists(currentFormList)            
            Int checkOverwrite = AOS_MESG_SaveOutfitOverride.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
            ; If ok to overwrite
            If checkOverwrite == 0
                SaveOutfitForReal(currentFormList)
            ; If not then show outfits again
            Else 
                ShowOutfitChoices()
            EndIf
        ElseIf !OutfitExists(currentFormList)
            SaveOutfitForReal(currentFormList)
        EndIf
    EndIf
EndFunction

Function SaveOutfitForReal(FormList currentFormList)
    ; Clear the formlist first
    currentFormList.Revert()
    Int Index = 0
    ; Go through the master formlist which contains every item every equipped. We have to do this because there is no way to get currently equipped items.
    While (Index < AOS_FLST_Outfit_Master.GetSize())
        Form currentItem = AOS_FLST_Outfit_Master.GetAt(Index)
        If Game.GetPlayer().IsEquipped(currentItem)
            currentFormList.AddForm(currentItem)
        EndIf
        Index = Index + 1
    EndWhile
    ; Reset the global
    AOS_GLOB_OutfitSwitcherMode.SetValue(0.0)
EndFunction

Function EquipOutfit(Int theOutfit, bool removeAll=false)
    Formlist currentFormList = GetOutfitFormList(theOutfit)
    If currentFormList.GetSize() > 0
        If removeAll
            Game.GetPlayer().UnequipAll()
        EndIf
        Int Index = 0
        While (Index < currentFormList.GetSize())
            Form currentItem = currentFormList.GetAt(Index)
            PlayerRef.EquipItem(currentItem,false,true)
            Index = Index + 1
        EndWhile
        ; Reset the global
        AOS_GLOB_OutfitSwitcherMode.SetValue(0.0)
    Else
        Debug.Messagebox("No outfit exists. Please select a different outfit.")
        ShowOutfitChoices()
    EndIf
EndFunction

; Get the correct FormList for the outfit
Formlist Function GetOutfitFormList(Int theOutfit)
    ; We need to add 1 because the first item in the AllLists is the master list.
    Int flIndex = theOutfit + 1
    FormList selectedFormList = AOS_FLST_Outfit_AllLists.GetAt(flIndex) as FormList
    return selectedFormList
EndFunction

; Checks to see if there is already an outfit stored there
bool Function OutfitExists(FormList theFormList)
    bool outfitExists = true
    Int formlistSize = theFormList.GetSize()
    If formlistSize == 0
        outfitExists = false
    EndIf
    return outfitExists    
EndFunction


