ScriptName Aurie:AOS:OutfitPlayerAliasScript Extends ReferenceAlias Hidden

Group AutoFill
    Actor Property PlayerRef Auto Const Mandatory
    FormList Property AOS_FLST_Outfit_Master Auto Mandatory
    Perk Property AOS_PERK_OutfitSwitcher Auto Mandatory
EndGroup

Event OnAliasInit()
    AddOutfitPerk()
EndEvent

Event OnPlayerLoadGame()
    Utility.Wait(1.0)
    Actor PlayerActor = Game.GetPlayer()
    RegisterForRemoteEvent(PlayerActor, "OnItemEquipped")
    AddOutfitPerk()
EndEvent

Function AddOutfitPerk()
    If !PlayerRef.HasPerk(AOS_Perk_OutfitSwitcher)
        PlayerRef.AddPerk(AOS_Perk_OutfitSwitcher, false)
    EndIf
EndFunction

Event Actor.OnItemEquipped(Actor akSender, Form akBaseObject, ObjectReference akReference)
    Form equippedItem = akBaseObject
    ;Check if item already exists in the master formlist and add it if not.
    If equippedItem && !AOS_FLST_Outfit_Master.HasForm(akBaseObject)
        AOS_FLST_Outfit_Master.AddForm(akBaseObject)
    EndIf
EndEvent