ScriptName Aurie:AOS:OutfitSwitcher Extends ScriptObject Hidden

; CGF "Aurie:AOS:OutfitSwitcher.Save"
Function Save() Global
    GlobalVariable AOS_GLOB_OutfitSwitcherMode = Game.GetFormFromFile(0x0000080B, "Aurie_SFOutfitSwitcher.esm") as GlobalVariable 
    AOS_GLOB_OutfitSwitcherMode.SetValue(1.0)
EndFunction

; CGF "Aurie:AOS:OutfitSwitcher.Equip"
Function Equip() Global
    GlobalVariable AOS_GLOB_OutfitSwitcherMode = Game.GetFormFromFile(0x0000080B, "Aurie_SFOutfitSwitcher.esm") as GlobalVariable 
    AOS_GLOB_OutfitSwitcherMode.SetValue(2.0)
EndFunction

; CGF "Aurie:AOS:OutfitSwitcher.SaveOutfit" 1 true
Function SaveOutfit(Int selectedOutfit, bool canOverwrite = false) Global
    FormList AOS_FLST_Outfit_Master = Game.GetFormFromFile(0x00000800, "Aurie_SFOutfitSwitcher.esm") as FormList
    FormList AOS_FLST_Outfit_AllLists = Game.GetFormFromFile(0x00000817, "Aurie_SFOutfitSwitcher.esm") as FormList
    FormList currentFormList = AOS_FLST_Outfit_AllLists.GetAt(selectedOutfit) as FormList
    ; Check to see if there is already an outfit stored in the formlist and prompt player
    If currentFormList
        ; Make sure the current list is empty or it is ok to overwrite          
        If (currentFormList.GetSize() == 0 || canOverwrite)
            Int Index = 0
            While (Index < AOS_FLST_Outfit_Master.GetSize())
                Form currentItem = AOS_FLST_Outfit_Master.GetAt(Index)
                If Game.GetPlayer().IsEquipped(currentItem)
                    currentFormList.AddForm(currentItem)
                EndIf
                Index = Index + 1
            EndWhile
        ; If not then let player know that the outfit is not empty
        Else
            Debug.Messagebox("Outfit 0" + selectedOutfit + " already has items. Please select a different outfit or set overwrite to true.")        
        EndIf
    EndIf
EndFunction

; CGF "Aurie:AOS:OutfitSwitcher.EquipOutfit" 1 false
Function EquipOutfit(Int selectedOutfit, bool removeAll=false) Global
    FormList AOS_FLST_Outfit_Master = Game.GetFormFromFile(0x00000800, "Aurie_SFOutfitSwitcher.esm") as FormList
    FormList AOS_FLST_Outfit_AllLists = Game.GetFormFromFile(0x00000817, "Aurie_SFOutfitSwitcher.esm") as FormList
    FormList currentFormList = AOS_FLST_Outfit_AllLists.GetAt(selectedOutfit) as FormList
    If currentFormList.GetSize() > 0
        ; Remove everything
        If removeAll
            Game.GetPlayer().UnequipAll()
        EndIf
        Int Index = 0
        While (Index < currentFormList.GetSize())
            Form currentItem = currentFormList.GetAt(Index)
            Game.GetPlayer().EquipItem(currentItem,false,true)
            Index = Index + 1
        EndWhile
    Else
        Debug.Messagebox("Outfit 0" + selectedOutfit + " does not contain any items. Please select a different outfit.")
    EndIf
EndFunction

; CGF "Aurie:AOS:OutfitSwitcher.View" 0
; Use 0 for master list, 1-5 for specific outfits
Function View(Int selectedOutfit) Global
    FormList AOS_FLST_Outfit_Master = Game.GetFormFromFile(0x00000800, "Aurie_SFOutfitSwitcher.esm") as FormList
    FormList AOS_FLST_Outfit_AllLists = Game.GetFormFromFile(0x00000817, "Aurie_SFOutfitSwitcher.esm") as FormList
    FormList currentFormList = AOS_FLST_Outfit_AllLists.GetAt(selectedOutfit) as FormList
    String currentListName
    If selectedOutfit == 0
        currentListName == "Master"
    Else
        currentListName == "Outfit 0" + selectedOutfit
    EndIF
    If currentFormList.GetSize() < 1
        Debug.Messagebox(currentListName + " list is empty")
    ElseIf currentFormList.GetSize() > 0
        Debug.Messagebox(currentListName + " has " + currentFormList.GetSize() + " items.")
    EndIf
EndFunction

