local M = {}

local tick = 0
local soundFX = "day"
local isRain = false
local isAlarm = true
local isInMudArea = false
local alarmTick = 0

local function setAllLightsEnabled(group, value)
    for i = 0, group.obj:getCount(), 1 do
        local id = group.obj:idAt(i)
        local lightObjs = scenetree.findObjectById(id)
        if lightObjs and lightObjs.obj:isSubClassOf("LightBase") then
            lightObjs.obj:setLightEnabled( value )
        end
    end
end

local function setFogWeather(group, fogValue)
    for i = 0, group.obj:getCount(), 1 do
        local id = group.obj:idAt(i)
        local fogObj = scenetree.findObjectById(id)
        if fogObj and fogObj.obj:isSubClassOf("LevelInfo") then
            fogObj.fogDensity = fogValue
        end
    end
end

local function setRainWeather(group, rainValue, cloudValue)
    for i = 0, group.obj:getCount(), 1 do
        local id = group.obj:idAt(i)
        local rainObj = scenetree.findObjectById(id)
        if rainObj and rainObj.obj:isSubClassOf("Precipitation") then
            rainObj.numDrops = rainValue
        end
    end

    local cloudObj = scenetree.findObject("clouds1")
    if cloudObj and cloudObj.obj:isSubClassOf("CloudLayer") then
        cloudObj.coverage = cloudValue
    end
end

local function setRainSounds()
    local soundFXDay = scenetree.findObject("Ambient_Sounds_Day")
    local soundFXNight = scenetree.findObject("Ambient_Sounds_Night")
    if soundFXDay then
        soundFXDay:stop()
    end

    if soundFXNight then
        soundFXNight:stop()
    end

    local soundFXRain = scenetree.findObject("Ambient_Sounds_Rain")
    if soundFXRain then
        soundFXRain:play()
    end
end

local function setGraveYardSong(playBool)
    local song = scenetree.findObject("graveyard_song")
    if playBool == true then
        song:play()
    end
    if playBool == false then
        song:stop()
    end
end

local function setMudAreaSong(playBool)
    local song = scenetree.findObject("mudarea_song")
    if playBool == true and isInMudArea == false then
        song:play()
    else
        song:stop()
    end
end

local function mudAreaEnter()
    isInMudArea = true
end

local function mudAreaLeft()
    isInMudArea = false
end

local function graveEnter()
    local object  = scenetree.findObject("gravestone_watchtower")
    local pos = Point3F(126.169, 181.749, 0)
    object:setPosition(pos)
    be:reloadStaticCollision(false)
end

local function graveLeft()
    local object  = scenetree.findObject("gravestone_watchtower")
    local pos = Point3F(126.169, 181.749, 204.866)
    object:setPosition(pos)
    be:reloadStaticCollision(false)
end

local function setNormalSounds()
    local soundFXDay = scenetree.findObject("Ambient_Sounds_Day")
    local soundFXNight = scenetree.findObject("Ambient_Sounds_Night")
    if soundFXDay and soundFX == "day" then
        soundFXDay:play()
    else
        soundFXDay:stop()
    end

    if soundFXNight and soundFX == "night" then
        soundFXNight:play()
    else
        soundFXNight:stop()
    end

    local soundFXRain = scenetree.findObject("Ambient_Sounds_Rain")
    if soundFXRain then
        soundFXRain:stop()
    end
end

local function toggleShuffleboardAlarm()
    local shuffleboard_alarm = scenetree.findObject("shuffleboard_alarm")
    if shuffleboard_alarm and soundFX == "night" then
        shuffleboard_alarm:play()
        isAlarm = true
    end
end

local function onExtensionLoaded()
    isAlarm = true
    tick = 10000
    alarmTick = 2000
end

local lastValue = nil

local morningFog = false
local randomRainNR = math.random(0, 10000)
local rainValue = 10000 + randomRainNR
local rainValueDefault = 0

local randomCloudNR = math.random(0, 0.4)
local cloudValue = 0.5 + randomCloudNR
local cloudValueDefault = 0.08

local randomFogNR = math.random(0, 0.003)
local fogValue = 0.005 + randomFogNR
local fogValueDefault = 0.001

local function onUpdate(dt)
    tick = tick + 1

    if isAlarm == true then
        alarmTick = alarmTick + 1
        if alarmTick >= 2000 then
            local shuffleboard_alarm = scenetree.findObject("shuffleboard_alarm")
            shuffleboard_alarm:stop()
            isAlarm = false
            log("D", "mainLevel.alarmTick", alarmTick)
            alarmTick = 0
        end
    end

    local tod = scenetree.tod

    if tod.time >= 0.74 and tod.time <= 0.85 then
        morningFog = true
        setFogWeather(scenetree.sky_and_sun, 0.007)
    else
        morningFog = false
        setFogWeather(scenetree.sky_and_sun, fogValueDefault)
    end

    if tick >= 10000 then
        local randomNR = math.random(0, 1000)
        log("D", "mainLevel.weatherTick", randomNR) --debug
        tick = 0

        if randomNR >= 900 then
            setFogWeather(scenetree.sky_and_sun, fogValue)
            setRainWeather(scenetree.sky_and_sun, rainValue, cloudValue)
            setRainSounds()
            isRain = true
        else
            if morningFog == false then
                setFogWeather(scenetree.sky_and_sun, fogValueDefault)
            end
            setRainWeather(scenetree.sky_and_sun, rainValueDefault, cloudValueDefault)
            setNormalSounds()
        end
    end

    local value = false

    if tod.time > 0.21 and tod.time < 0.77 then
        value = true
        soundFX = "night"
        if isRain == false then
            setNormalSounds()
        end
        setGraveYardSong(true)
        setMudAreaSong(true)
    else
        value = false
        soundFX = "day"
        if isRain == false then
            setNormalSounds()
        end
        setGraveYardSong(false)
        setMudAreaSong(false)
    end

    if lastValue == value then return end
    lastValue = value

    if scenetree.lighthouse_stuff then
      setAllLightsEnabled(scenetree.backdrop_stuff, value)
      setAllLightsEnabled(scenetree.lighthouse_stuff, value)
    end
end

M.mudAreaEnter = mudAreaEnter
M.mudAreaLeft = mudAreaLeft
M.graveLeft = graveLeft
M.graveEnter = graveEnter
M.toggleShuffleboardAlarm = toggleShuffleboardAlarm
M.onUpdate = onUpdate
M.onExtensionLoaded = onExtensionLoaded

return M