-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

-- In other words, if you are a modder feel free to reuse this code with above license

--If you reload Lua with CTRL+L use thise in the GE console `

local M = {}

local TorqueScriptLua = TorqueScriptLua

local cubemmapLocations

--level data
local levelfolder = nil
local levelname =  nil

local value

local function onClientStartMission()
  if not TorqueScriptLua then
    TorqueScriptLua = TorqueScript
  end
  log('I', 'onClientStartMission', 'Getting current level path' )
  levelname = getCurrentLevelIdentifier()
  --print(levelname)
  log('I', 'onClientStartMission', 'Level is loaded' )
  levelfolder = ("/levels/" .. levelname .. "/")
  if TorqueScriptLua then
    local cmFiles = FS:findFiles(levelfolder, '*.cubemap_data.json', 1, true, false)
    for k,filename in pairs(cmFiles) do
      cubemmapLocations = jsonReadFile(filename) or {}
    end
  end
end

local function setCubemap(value)
  if value then
    local levelinf = scenetree.findObject("theLevelInfo")
    if levelinf then
      log("I", "Showroom17 Level LUA", "Enabling cubemap " ..value)
      levelinf:setField('globalEnviromentMap', 0, value)
      levelinf:postApply()
    else
      log("W", "Showroom17 Level LUA", "Enabling fallback cubemap " ..value)
      setConsoleVariable("$defaultLevelEnviromentMap", value)
    end
  end
end


local function onBeamNGTrigger(data)
  if data.event == "enter" then
    local trigger = data.triggerName
    if cubemmapLocations then
      local cubemapLocation = cubemmapLocations.cubemaps
      for k,v in pairs(cubemapLocation) do
        if v.triggerName == trigger then
          local veh = be:getPlayerVehicleID(0)
          if data.subjectID == veh then
            value = v.cubemap
            setCubemap(value)
          end
        end
      end
    end
  end
end

M.onClientStartMission = onClientStartMission
M.onBeamNGTrigger = onBeamNGTrigger

return M

