//-----------------------------------------------------------------------------
// Copyright (c) 2012 GarageGames, LLC
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
//-----------------------------------------------------------------------------

// This is the default save location for any ForestBrush(s) created in 
// the Forest Editor.
// This script is executed from ForestEditorPlugin::onWorldEditorStartup().

//--- OBJECT WRITE BEGIN ---
new SimGroup(ForestBrushGroup) {
   canSave = "1";
   canSaveDynamicFields = "1";

   new ForestBrush() {
      internalName = "Trees_Dead";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_oak_dead_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_dead_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_dead_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_dead_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_dead_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_dead_b";
         probability = "2";
         rotationRange = "360";
         scaleMin = "0.5";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_dead_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_dead_a";
         probability = "2";
         rotationRange = "360";
         scaleMin = "0.5";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_douglasfir_dead";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_dead";
         probability = "2";
         rotationRange = "360";
         scaleMin = "0.5";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Trees_Stumps";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_aspen_chopped";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_chopped";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0.2";
         sinkMax = "0.6";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "50";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_chopped_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_chopped_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0.2";
         sinkMax = "0.6";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "50";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_chopped_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_chopped_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0.2";
         sinkMax = "0.6";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "50";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_douglasfir_chopped";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_chopped";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0.2";
         sinkMax = "0.6";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "50";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_chopped_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_chopped_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0.2";
         sinkMax = "0.6";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "50";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_chopped_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_chopped_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0.2";
         sinkMax = "0.6";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "50";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Grass_mesh";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "grass_field_filler";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "grass_field_filler";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "grass_field_long";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "grass_field_long";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "grass_field_sml";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "grass_field_sml";
         probability = "10";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.6";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "grass_field_large";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "grass_field_large";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "0";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "vines";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "vine_side_8m";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_side_8m";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_side_4m";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_side_4m";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_side_2m";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_side_2m";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_side_1m";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_side_1m";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_roof_wide";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_roof_wide";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_roof_small";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_roof_small";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_roof_end";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_roof_end";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_ground_medium";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_ground_medium";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_ground_large";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_ground_large";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_ground_small";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_ground_small";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_wall_wide_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_wall_wide_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_wall_wide_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_wall_wide_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_wall_small";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_wall_small";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_wall_medium";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_wall_medium";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_wall_large";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_wall_large";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_bush_wide";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_bush_wide";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_bush_wide_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_bush_wide_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_bush_small";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_bush_small";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "vine_bush_large";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "vine_bush_large";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Lush";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "lush_general_01_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_general_01_a";
         probability = "2";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "0";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "lush_general_01_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_general_01_b";
         probability = "10";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "0";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "lush_general_01_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_general_01_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.6";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "0";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "lush_general_01_d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_general_01_d";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.6";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "0";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "lush_general_01_e";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_general_01_e";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "0";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "lush_ferns_02_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_ferns_02_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "-1000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "lush_ferns_02_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_ferns_02_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "-1000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "lush_big_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_big_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "0";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "lush_big_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_big_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "0";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "NeedFix";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "lush_grass_01_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_grass_01_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "lush_grass_01_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_grass_01_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "lush_grass_01_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_grass_01_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Trees_oak";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_oak_large_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_large_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "80";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_large_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_large_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.4";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "80";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_large_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_large_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.4";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_forest_canopy_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.6";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "3";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "40";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_forest_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_forest_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "80";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_forest_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_forest_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "80";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_forest_group";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_forest_group";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_small_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_sml_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_sml_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Trees_Aspen";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_aspen_large_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_large_a";
         probability = "1.5";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "80";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_large_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_large_b";
         probability = "1.5";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_small_low_group";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_small_low_group";
         probability = "1.5";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.7";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_wall";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_wall";
         probability = "1.5";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "80";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_small_low";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_small_low";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_small_d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_small_d";
         probability = "0.5";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_small_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_small_c";
         probability = "0.5";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_small_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_small_b";
         probability = "0.5";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.4";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_small_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_small_a";
         probability = "0.5";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_forest_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_forest_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_forest_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_forest_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_forest_group";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_forest_group";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_overhang_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_overhang_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Trees_Douglas_Fir";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_douglasfir_large_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_large_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_douglasfir_large_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_large_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "40";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_douglasfir_large_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_large_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_douglasfir_large_d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_large_d";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "40";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_douglasfir_small_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_small_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "40";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_douglasfir_small_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_small_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_douglasfir_small_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_small_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_douglasfir_small_d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_small_d";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "40";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_douglasfir_bush_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_bush_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "40";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_douglasfir_bush_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_bush_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "40";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_douglasfir_group";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_douglasfir_group";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "ECA_manmade";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "eca_bld_house_01_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_house_01_a";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_house_01_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_house_01_a";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_house_02_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_house_02_a";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_house_03_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_house_03_a";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_house_04_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_house_04_a";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_house_05_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_house_05_a";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_house_05_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_house_05_b";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_house_05_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_house_05_c";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_house_05_d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_house_05_d";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_house_05_e";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_house_05_e";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_house_sml_01";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_house_sml_01";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_house_sml_02";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_house_sml_02";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_gastation";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_gastation";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_gastation_sign";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_gastation_sign";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_filler_wall_01";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_filler_wall_01";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_grocerystore";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_grocerystore";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_filler_wall_01";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_filler_wall_01";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_ornate_01";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_ornate_01";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_shop_town_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_shop_town_a";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_shop_town_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_shop_town_b";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_shop_town_bwhite";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_shop_town_bwhite";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_shop_town_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_shop_town_c";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_shop_town_d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_shop_town_d";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_shop_town_e";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_shop_town_e";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_shop_town_f";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_shop_town_f";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_station_police_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_station_police_a";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_store_fish_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_store_fish_a";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_warehouse_01_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_warehouse_01_a";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_warehouse_02_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_warehouse_02_a";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_bld_townblock_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_bld_townblock_a";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "eca_drain_12m";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "eca_drain_12m";
         probability = "1";
         rotationRange = "0";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "0";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Trees_Beech";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_beech_large_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_large_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.6";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_large_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_large_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.6";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_forest_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_forest_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_forest_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_forest_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_forest_group";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_forest_group";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_small_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_small_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "35";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_small_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_small_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.4";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "35";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_small_d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_small_d";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.7";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "35";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_overhang_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_overhang_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Trees_palm";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_palm_f";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_palm_f";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_palm_e";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_palm_e";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_palm_d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_palm_d";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_palm_overhang_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_palm_overhang_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_palm_overhang_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_palm_overhang_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_palm_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_palm_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_palm_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_palm_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_palm_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_palm_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.4";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Trees_Blocker";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "oak_beech_wallblocker_long";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "oak_beech_wallblocker_long";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_blocker_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_blocker_a";
         probability = "2";
         rotationRange = "360";
         scaleMin = "0.5";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "1";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "40";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_blocker_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_blocker_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "40";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_blocker_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_blocker_a";
         probability = "0.5";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "40";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Ferns";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "lush_ferns_01_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_ferns_01_a";
         probability = "2";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "-1000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "lush_ferns_01_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "lush_ferns_01_b";
         probability = "2";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "30";
         elevationMin = "0";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Bushes_huge";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_beech_bush_d";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_bush_d";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "40";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_bush_e";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_bush_e";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.32";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "90";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Bushes_large";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_oak_bush_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_bush_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_bush_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_bush_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "25";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_bush_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_bush_b";
         probability = "3";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.3";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "80";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_aspen_bush_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_bush_c";
         probability = "1.5";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "80";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_bush_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_bush_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.5";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "80";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_bush_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_bush_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "80";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Bushes_small";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "tree_aspen_bush_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_aspen_bush_a";
         probability = "1.5";
         rotationRange = "360";
         scaleMin = "0.8";
         scaleMax = "1.2";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.1";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "80";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_oak_bush_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_oak_bush_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.7";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "80";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "tree_beech_bush_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "tree_beech_bush_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "80";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "Undergrowth East Coast";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "undergrowth_eca_large_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "undergrowth_eca_large_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "80";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "undergrowth_eca_med_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "undergrowth_eca_med_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "50";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "undergrowth_eca_med_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "undergrowth_eca_med_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "50";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "undergrowth_eca_med_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "undergrowth_eca_med_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "50";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "undergrowth_eca_med_single";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "undergrowth_eca_med_single";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "50";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "undergrowth_eca_small_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "undergrowth_eca_small_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "50";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "undergrowth_eca_small_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "undergrowth_eca_small_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "50";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "undergrowth_eca_tiny_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "undergrowth_eca_tiny_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "50";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "undergrowth_eca_tiny_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "undergrowth_eca_tiny_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "50";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "undergrowth_eca_test";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "undergrowth_eca_tiny_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "0.9";
         scaleMax = "1.3";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "50";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "rocks_01_a_large";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "rock_01_a_large_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_large_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "rock_01_a_large_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_large_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "rock_01_a_large_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_large_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "1.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.2";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "45";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrush() {
      internalName = "rocks_01_a_small";
      canSave = "1";
      canSaveDynamicFields = "1";

      new ForestBrushElement() {
         internalName = "rock_01_a_small_c";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_small_c";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "2.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.05";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "rock_01_a_small_b";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_small_b";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "2.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.05";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
      new ForestBrushElement() {
         internalName = "rock_01_a_small_a";
         canSave = "1";
         canSaveDynamicFields = "1";
         ForestItemData = "rock_01_a_small_a";
         probability = "1";
         rotationRange = "360";
         scaleMin = "1";
         scaleMax = "2.5";
         scaleExponent = "1";
         sinkMin = "0";
         sinkMax = "0.05";
         sinkRadius = "1";
         slopeMin = "0";
         slopeMax = "60";
         elevationMin = "-10000";
         elevationMax = "10000";
      };
   };
   new ForestBrushElement() {
      internalName = "coastrock_dark_a";
      canSave = "1";
      canSaveDynamicFields = "1";
      ForestItemData = "coastrock_dark_a";
      probability = "1";
      rotationRange = "360";
      scaleMin = "0.5";
      scaleMax = "1";
      scaleExponent = "1";
      sinkMin = "0";
      sinkMax = "0.5";
      sinkRadius = "1";
      slopeMin = "0";
      slopeMax = "90";
      elevationMin = "-10000";
      elevationMax = "10000";
   };
   new ForestBrushElement() {
      internalName = "coastrock_dark_b";
      canSave = "1";
      canSaveDynamicFields = "1";
      ForestItemData = "coastrock_dark_b";
      probability = "1";
      rotationRange = "360";
      scaleMin = "0.5";
      scaleMax = "1";
      scaleExponent = "1";
      sinkMin = "0";
      sinkMax = "1";
      sinkRadius = "1";
      slopeMin = "0";
      slopeMax = "90";
      elevationMin = "-10000";
      elevationMax = "10000";
   };
   new ForestBrushElement() {
      internalName = "coastrock_dark_c";
      canSave = "1";
      canSaveDynamicFields = "1";
      ForestItemData = "coastrock_dark_c";
      probability = "1";
      rotationRange = "360";
      scaleMin = "0.5";
      scaleMax = "1";
      scaleExponent = "1";
      sinkMin = "0";
      sinkMax = "1";
      sinkRadius = "1";
      slopeMin = "0";
      slopeMax = "90";
      elevationMin = "-10000";
      elevationMax = "10000";
   };
   new ForestBrushElement() {
      internalName = "coastrock_dark_d";
      canSave = "1";
      canSaveDynamicFields = "1";
      ForestItemData = "coastrock_dark_d";
      probability = "1";
      rotationRange = "360";
      scaleMin = "0.5";
      scaleMax = "1";
      scaleExponent = "1";
      sinkMin = "0";
      sinkMax = "1";
      sinkRadius = "1";
      slopeMin = "0";
      slopeMax = "90";
      elevationMin = "-10000";
      elevationMax = "10000";
   };
   new ForestBrushElement() {
      internalName = "DRI_rock_a";
      canSave = "1";
      canSaveDynamicFields = "1";
      ForestItemData = "DRI_rock_a";
      probability = "1";
      rotationRange = "360";
      scaleMin = "1";
      scaleMax = "1";
      scaleExponent = "1";
      sinkMin = "0";
      sinkMax = "0";
      sinkRadius = "1";
      slopeMin = "0";
      slopeMax = "90";
      elevationMin = "-10000";
      elevationMax = "10000";
   };
   new ForestBrushElement() {
      internalName = "DRI_rock_b";
      canSave = "1";
      canSaveDynamicFields = "1";
      ForestItemData = "DRI_rock_b";
      probability = "1";
      rotationRange = "360";
      scaleMin = "1.3";
      scaleMax = "1.3";
      scaleExponent = "1";
      sinkMin = "0";
      sinkMax = "0.5";
      sinkRadius = "1";
      slopeMin = "0";
      slopeMax = "90";
      elevationMin = "-10000";
      elevationMax = "10000";
   };
   new ForestBrushElement() {
      internalName = "DRI_rock_c";
      canSave = "1";
      canSaveDynamicFields = "1";
      ForestItemData = "DRI_rock_c";
      probability = "1";
      rotationRange = "360";
      scaleMin = "1.3";
      scaleMax = "1.3";
      scaleExponent = "1";
      sinkMin = "0";
      sinkMax = "0";
      sinkRadius = "1";
      slopeMin = "0";
      slopeMax = "90";
      elevationMin = "-10000";
      elevationMax = "10000";
   };
   new ForestBrushElement() {
      internalName = "DRI_rock_d";
      canSave = "1";
      canSaveDynamicFields = "1";
      ForestItemData = "DRI_rock_d";
      probability = "15";
      rotationRange = "360";
      scaleMin = "1.3";
      scaleMax = "1.3";
      scaleExponent = "1";
      sinkMin = "0";
      sinkMax = "0.2";
      sinkRadius = "1";
      slopeMin = "0";
      slopeMax = "90";
      elevationMin = "-10000";
      elevationMax = "10000";
   };
   new ForestBrushElement() {
      internalName = "DRI_rock_e";
      canSave = "1";
      canSaveDynamicFields = "1";
      ForestItemData = "DRI_rock_e";
      probability = "1";
      rotationRange = "360";
      scaleMin = "1.3";
      scaleMax = "1.3";
      scaleExponent = "1";
      sinkMin = "0";
      sinkMax = "0";
      sinkRadius = "1";
      slopeMin = "0";
      slopeMax = "90";
      elevationMin = "-10000";
      elevationMax = "10000";
   };
   new ForestBrushElement() {
      internalName = "DRI_rock_f";
      canSave = "1";
      canSaveDynamicFields = "1";
      ForestItemData = "DRI_rock_f";
      probability = "1";
      rotationRange = "360";
      scaleMin = "1";
      scaleMax = "1";
      scaleExponent = "1";
      sinkMin = "0";
      sinkMax = "0";
      sinkRadius = "1";
      slopeMin = "0";
      slopeMax = "90";
      elevationMin = "-10000";
      elevationMax = "10000";
   };
   new ForestBrushElement() {
      internalName = "DRI_rock_g";
      canSave = "1";
      canSaveDynamicFields = "1";
      ForestItemData = "DRI_rock_g";
      probability = "1";
      rotationRange = "360";
      scaleMin = "1";
      scaleMax = "1";
      scaleExponent = "1";
      sinkMin = "0";
      sinkMax = "0";
      sinkRadius = "1";
      slopeMin = "0";
      slopeMax = "90";
      elevationMin = "-10000";
      elevationMax = "10000";
   };
};
//--- OBJECT WRITE END ---
