-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

TorqueScriptLua.getVar('$LightRayPostFX::Enable')

-- TOD Lights Function
local function setAllLightsEnabled(group, value)
    for i = 0, group.obj:getCount(), 1 do
        local id = group.obj:idAt(i)
        local obj = scenetree.findObjectById(id)
        if obj and obj.obj:isSubClassOf('LightBase') then
            obj.obj:setLightEnabled( value )
        end
    end
end

local shadowvalue = nil

-- TOD Shadows Function
local function setAllLightsShadowsEnabledDisabled(group, shadowvalue)
  if not group then
  else
  for i = 0, group.obj:getCount(), 1 do
    local id = group.obj:idAt(i)
    light = scenetree.findObjectById(id)
    light.castShadows = shadowvalue
  end
end
end



-- execution stuff --------------------------------------------------------------------------

local lastValue = nil

-- Dynamic Street Lamps
local function onUpdate()
    local tod = scenetree.tod
    if not tod then return end

    local value = false
    local shadowvalue = true
    if tod.time > 0.25 and tod.time < 0.75 then
        value = true
        shadowvalue = false
        scenetree.findObject("LightRayPostFX"):disable()       
    end

    if shadowvalue == true then
        scenetree.findObject("LightRayPostFX"):enable()
    end

    if lastValue == value then return end
    lastValue = value

    if scenetree.Nagao_Lights then
      setAllLightsEnabled(scenetree.Nagao_Lights, value )
      setAllLightsShadowsEnabledDisabled(scenetree.sky_and_sun, shadowvalue ) 
    end
end



M.onUpdate = onUpdate

return M