angular.module("beamng.apps").directive("navigation", [
  "Utils",
  function (Utils) {
    return {
      template: `
      <div style="height: 100%; width: 100%; position: relative;">
        <!-- map container -->

        <div id="overflow-wrap" style=" width: 100%; height: 100%; overflow: hidden">
          <div id="mapContainer" style="overflow: visible;">
            <svg style="overflow: visible">
              <defs>
                <image style="" id="vehicleMarker" width="40" height="40"  x="-20" y="-20" xlink:href="/ui/modules/apps/Navigation/vehicleMarker.svg" />
              </defs>
              <foreignObject id="canvasWrapper" style="position:absolute; x:-100%; y:-100%; width:100%; height:100%">
                <canvas id="roadCanvas"  width="40960" height="40960"> </canvas>
              </foreignObject>
              <foreignObject id="routeCanvasWrapper" style="position:absolute; x:-100%; y:-100%; width:100%; height:100%">
                <canvas id="routeCanvas"  width="40960" height="40960"> </canvas>
              </foreignObject>
            </svg>
          </div>

          <div style="position: absolute">
            <svg width="40" height="40" style="position: fixed; top:0; left: 50%; margin-top: -20px; margin-left: -20px; transform: scale(1, 1);">
              <!--<path d="M20.272 3.228l-5.733 10.52-3.878 6.51c-1.22 1.87-1.873 4.056-1.877 6.29 0 6.38 5.17 11.55 11.55 11.55 6.38 0 11.55-5.17 11.55-11.55-.002-2.257-.666-4.466-1.91-6.35l-3.92-6.505z" fill="#282828" fill-rule="evenodd" stroke="#fff" stroke-width="2.88"/>-->
              <circle cx="20" cy="20" r="10" stroke="#FFF" stroke-width="1.5" fill="#282828" />
              <text style="line-height:125%" x="14.265" y="1043.581" font-size="14" font-family="sans-serif" letter-spacing="0" word-spacing="0" fill="#fff" transform="translate(1 -1012.362)"><tspan x="14" y="1037">N</tspan></text>
            </svg>
          </div>
        </div>

        <!-- Collectible Display -->
        <div ng-if="collectableTotal > 0" style="font-size: 1.2em; padding: 1%; color: white; background-color: rgba(0, 0, 0, 0.3); position: absolute; top:15px; left: 15px">
          <md-icon style="margin-bottom: 3px;" md-svg-src="{{ '/ui/modules/apps/Navigation/snowman.svg' }}" />
          {{ collectableCurrent + '/' + collectableTotal }}
        </div>

        <div ng-click="openBigMap()" style="cursor: pointer; position: absolute; top: 0; background-color:rgba(0, 0, 0, 0.6)">
          <md-icon class="material-icons" style="color:rgb(255, 103, 0, 128); margin: 0.1em">map</md-icon>
        </div>

        <style>
          .bounce {
            animation: bounce 1s cubic-bezier(0.4,0.1,0.2,1) both
          }
          @keyframes bounce {
            0%, 20%, 50%, 80%, 100% { transform: translateY(0); }
            40% { transform: translateY(-4px); }
            60% { transform: translateY(-2px); }
          }
        </style>

      </div>
      `,
      replace: true,
      restrict: "EA",
      link: function (scope, element, attrs) {

        const
          DEFAULT_ROUTE_COLOR = "#3388EEFF"


        let
          initialised = false,

          root = element[0],
          mapContainer = root.children[0].children[0],
          svg = mapContainer.children[0],
          canvas = document.getElementById("roadCanvas"),
          canvasCtx = canvas.getContext("2d"),
          canvasWrapper = document.getElementById("canvasWrapper"),

          routeCanvas = document.getElementById("routeCanvas"),
          routeCanvasCtx = routeCanvas.getContext("2d"),
          routeCanvasWrapper = document.getElementById("routeCanvasWrapper"),

          pointer = mapContainer.children[1],
          northPointer = root.children[0].children[1].children[0],

          mapReady = false,
          rotateMap = true,
          viewParams = [],

          red = true,

          mapZoom = -500,
          mapScale = 1,
          routeScale = 1 / 3,
          zoomStates = [0, -500, -1000, -2000],
          zoomSlot = 1,
          t = 0,
          
          // receive live data from the GE map
          vehicleShapes = {},
          lastControlID = -1,

          staticMarkersDict = {},
          collectableShapes = {},

          // group to store all collectable svgs
          collGroup,

          visibilitySlots = [0.2, 0.6, 0.8, 1],
          activeVisibilitySlot = 1,

          quad = null //new Quadtree({x:0, y:0, width:1, height:1})

        // ability to interact
        const cycleVisibilitySlot = () => {
          activeVisibilitySlot = (activeVisibilitySlot + 1) % visibilitySlots.length
          element.css({
            "background-color": `rgba(50, 50, 50, ${visibilitySlots[activeVisibilitySlot]})`
          })
        }
        mapContainer.addEventListener("click", cycleVisibilitySlot)

        const cycleZoomSlot = () => {
          zoomSlot = (zoomSlot + 1) % zoomStates.length
          mapZoom = zoomStates[zoomSlot]
        }
        root.addEventListener("contextmenu", cycleZoomSlot)

        // update the map when necessary
        scope.$on("NavigationMapUpdate", (_, data) => {
          if (!mapReady || !data) return
          updateNavMap(data)
          // center map on thing that is controlled
          centerMap(data.objects[data.controlID])
        })

        // handle resizing
        const handleAppResized = (_, streams) => {
          element.css({
            width: streams.width - 25 + "px",
            height: streams.height - 25 + "px",
          })
          setupMap()
        }
        scope.$on("app:resized", handleAppResized)

        // shut down
        scope.$on("$destroy", () => {
          bngApi.engineLua('extensions.unload("ui_uiNavi")')
          //StreamsManager.remove(requiredStreams)
        })

        // receive the one-time map setup
        scope.$on("NavigationMap", (_, data) => {
          if (data && !initialised) {
            setupMap(data)
            initialised = true
          }
        })

        scope.$on("CollectablesInit", (_, data) => data && setupCollectables(data))
        scope.$on("NavigationStaticMarkers", (_, data) => data && setupStaticMarkers(data))

        let prevMarkers = null

        const routeLayer = {
          clear(canvas=routeCanvas, ctx=routeCanvasCtx) {
            ctx.clearRect(0, 0, routeCanvas.width, routeCanvas.height)
            ctx.stroke()
          },
          drawFreshRouteMarkers(data, canvas=routeCanvas, ctx=routeCanvasCtx) {
            routeLayer._drawMarkers({
              color: data.color,
              lineWidth: 10,
              lineCap: 'butt',
              canvas,
              ctx,
              markers: data.markers,
              startIndex: 0,
              drawFromIndex: 2,
              drawToIndex: data.markers.length
            })
          },
          optimiseAndDrawRouteMarkers(data, prevMarkers, canvas=routeCanvas, ctx=routeCanvasCtx) {
            let markers = data.markers
            let ci = markers.length - 2
            let pi = prevMarkers.length - 2
            while (pi >= 0 && ci >= 0) {
              if (markers[ci] != prevMarkers[pi] || markers[ci + 1] != prevMarkers[pi + 1]) break
              ci -= 2
              pi -= 2
            }

            if (pi >= 0 || ci >= 0) {
              // we know the common postfix
              // first, un-draw all the stuff from prevMarkers
              ctx.globalCompositeOperation = "destination-out"
              routeLayer._drawMarkers({
                color: data.color,
                lineWidth: 12,
                markers: prevMarkers,
                drawToIndex: Math.min(pi + 4, prevMarkers.length)
              })
              // next, draw all the previx stuff form current markers
              ctx.globalCompositeOperation = "source-over"
              routeLayer._drawMarkers({
                color: data.color,
                lineWidth: 10,
                markers: data.markers,
                drawToIndex: Math.min(ci + 6, data.markers.length)
              })
            }
          },
          _drawMarkers({color, lineWidth, lineCap="round", canvas=routeCanvas, ctx=routeCanvasCtx, markers, startIndex=0, drawFromIndex=0, drawToIndex }) {
            ctx.beginPath()
            ctx.strokeStyle = color || DEFAULT_ROUTE_COLOR
            ctx.lineWidth = lineWidth * routeScale
            ctx.lineCap = lineCap
            let canvasWidth = canvas.width * 0.5
            let canvasHeight = canvas.height * 0.5
            let mapFac = mapScale ? routeScale / mapScale : routeScale
            ctx.moveTo(-markers[startIndex] * mapFac + canvasWidth, markers[startIndex+1] * mapFac + canvasHeight)
            for (let i=drawFromIndex; i<drawToIndex; i+=2) {
              ctx.lineTo(-markers[i] * mapFac + canvasWidth, markers[i+1] * mapFac + canvasHeight)
            }
            ctx.stroke()
          }
        }

        scope.$on("NavigationGroundMarkersUpdate", (_, data) => {
          if (!routeCanvas) return
          let ctx = routeCanvasCtx 

          //clear canvas if no data or not markers
          if (!data || !data.markers) {
            routeLayer.clear()
            return
          }

          //if no previous markers, draw the whole route.
          if (!prevMarkers) {
            routeLayer.clear()
            if (data) {
              routeLayer.drawFreshRouteMarkers(data)
            }

          // otherwise, check previous markers for same-ness of end, and only erase the beginning that changed
          // erase anything from old markers until we reach
          } else {
            routeLayer.optimiseAndDrawRouteMarkers(data, prevMarkers)
          }
          prevMarkers = data.markers
        })

        scope.$on("CollectablesUpdate", (_, data) => {
          if (data) {
            // remove collectable from svg
            collectableShapes[data.collectableName].remove()
            // play animation
            let collectIcon = root.children[1].children[0]
            collectIcon.classList.add("bounce")
            collectIcon.addEventListener("animationend", () => {
              // resetting the animation
              collectIcon.classList.remove("bounce")
            })
            // update collected amount
            scope.collectableCurrent = data.collectableAmount
          }
        })

        // License: CC BY 4.0
        // https://stackoverflow.com/questions/29377748/draw-a-line-with-two-different-sized-ends/29379772
        function _varLine(ctx, x1, y1, x2, y2, w1, w2, color) {
          let dx = x2 - x1
          let dy = y2 - y1
          // length of the AB vector
          let length = dx * dx + dy * dy
          if (length == 0) return // exit if zero length
          length = Math.sqrt(length)
          w1 *= 0.5
          w2 *= 0.5

          dx /= length
          dy /= length
          let shiftx = -dy * w1 // compute AA1 vector's x
          let shifty = dx * w1 // compute AA1 vector's y
          ctx.beginPath()
          ctx.fillStyle = color
          ctx.moveTo(x1 + shiftx, y1 + shifty)
          ctx.lineTo(x1 - shiftx, y1 - shifty) // draw A1A2
          shiftx = -dy * w2 // compute BB1 vector's x
          shifty = dx * w2 // compute BB1 vector's y
          ctx.lineTo(x2 - shiftx, y2 - shifty) // draw A2B1
          ctx.lineTo(x2 + shiftx, y2 + shifty) // draw B1B2
          ctx.closePath() // draw B2A1

          ctx.arc(x1, y1, w1, 0, 2 * Math.PI)
          ctx.arc(x2, y2, w2, 0, 2 * Math.PI)

          ctx.fill()
        }

        function _createLine(ctx, p1, p2, color) {
          // for drawing trapezoids if the radii are not the same
          if (Math.abs(p1.radius - p2.radius) > 0.2) {
            _varLine(ctx, p1.x, p1.y, p2.x, p2.y, p1.radius, p2.radius, color)
          } else {
            ctx.beginPath()
            ctx.strokeStyle = color
            ctx.lineWidth = Math.max(p1.radius, p2.radius)
            ctx.lineCap = "round"
            ctx.moveTo(p1.x, p1.y)
            ctx.lineTo(p2.x, p2.y)
            ctx.stroke()
          }
        }

        let
          speedZoomMultiplier = 2
          zoom = 0,
          focusX = 0,
          focusY = 0,
          npx = 0,
          npy = 0,
          translateX = 0,
          translateY = 0,

          zoomIncrements = 1,
          otherFrame = false

        // *** here ***

        function centerMap(obj) {
          zoom = Math.ceil(Math.min(1 + obj.speed * 3.6 * 1.5, 200) / zoomIncrements) * zoomIncrements // speed tied zoom

          // center on what?
          focusX = Math.round(-obj.pos[0] / mapScale)
          focusY = Math.round(obj.pos[1] / mapScale)

          borderWidth = root.children[0].clientWidth
          borderHeight = root.children[0].clientHeight
          degreeNorth = rotateMap ? obj.rot - 90 : 90
          npx = -Math.cos((degreeNorth * Math.PI) / 180) * borderWidth * 0.75
          npy = borderHeight * 0.5 - Math.sin((degreeNorth * Math.PI) / 180) * borderHeight * 0.75
          translateX = viewParams[0] + borderWidth / 2 - 10 + focusX + 10
          translateY = viewParams[1] + borderHeight / 1.5 + focusY + zoom / 2 // translate map with speed

          mapContainer.style.transformOrigin = viewParams[0] * -1 - focusX + "px " + (viewParams[1] * -1 - focusY) + "px"
          mapContainer.style.transform =
            "translate3d(" +
            translateX +
            "px, " +
            translateY +
            "px," +
            (mapZoom - zoom * speedZoomMultiplier) +
            "px)" +
            "rotateX(" +
            0 +
            zoom / 10 +
            "deg)" +
            "rotateZ(" +
            (180 + Utils.roundDec(obj.rot, 2)) +
            "deg)"
          if (otherFrame) {
            northPointer.style.transform =
              "translate(" + Math.min(Math.max(npx, -borderWidth / 2 - 2), borderWidth / 2) + "px," + Math.min(Math.max(npy, 0), borderHeight) + "px)"
          }
          otherFrame = !otherFrame

        }

        // no cheating :D
        function hideCollectables(camera) {
          if (camera) {
            collGroup.attr({ opacity: 0 })
          } else {
            collGroup.attr({ opacity: 1 })
          }
        }

        function updatePlayerShape(key, data) {
          //console.log('updatePlayerShape', key)
          if (vehicleShapes[key]) vehicleShapes[key].remove()
          var isControlled = key == data.controlID
          //console.log(data)
          var obj = data.objects[key]

          if (isControlled) {
            //console.log(obj.type)
            if (obj.type == "Camera") {
              hideCollectables(true)
              vehicleShapes[key] = hu("<circle>", svg)
              vehicleShapes[key].attr("cx", 0)
              vehicleShapes[key].attr("cy", 0)
              vehicleShapes[key].attr("r", 8)
              vehicleShapes[key].css("fill", "#FD6A00")
            } else {
              hideCollectables(false)
              vehicleShapes[key] = hu("<use>", svg)
              vehicleShapes[key].attr({ "xlink:href": "#vehicleMarker" })
            }
          } else {
            vehicleShapes[key] = hu("<circle>", svg)
            vehicleShapes[key].attr("cx", 0)
            vehicleShapes[key].attr("cy", 0)
            vehicleShapes[key].attr("r", 10)
            vehicleShapes[key].css("stroke", "#FFFFFF")
            vehicleShapes[key].css("stroke-width", "3px")
            vehicleShapes[key].css("fill", "#A3D39C")
          }
        }

        function updateNavMap(data) {
          // player changed? update shapes?
          if (lastControlID != data.controlID) {
            if (lastControlID != -1) updatePlayerShape(lastControlID, data) // update shape of old vehicle
            updatePlayerShape(data.controlID, data) // update shape of new vehicle
            lastControlID = data.controlID
          }

          // update shape positions
          for (var key in data.objects) {
            var o = data.objects[key]

            if (vehicleShapes[key]) {
              var px = -o.pos[0] / mapScale
              var py = o.pos[1] / mapScale
              var rot = Math.floor(-o.rot)
              var iconScale = 1 //Math.min(3, 1 + lastSpeed * 0.5)

              vehicleShapes[key].attr({ transform: "translate(" + px + "," + py + ") scale(" + iconScale + "," + iconScale + ") rotate(" + rot + ")" })
            } else {
              updatePlayerShape(key, data)
            }
          }
          // delete missing vehicles
          for (var key in vehicleShapes) {
            if (!data.objects[key]) {
              vehicleShapes[key].remove()
              delete vehicleShapes[key]
            }
          }
        }

        function setupMap(data) {
          if (canvas == null) {
            //console.error('setupMap called before element is ready')
            return
          }
          if (data != null) {
            element.css({
              position: "relative",
              margin: "10px",
              perspective: "1000px",
              "background-color": "rgba(50, 50, 50, 0.6)",
              border: "2px solid rgba(180, 180, 180, 0.8)",
            })
            svg.style.transform = "scale(-1, -1)"

            if (data.terrainSize) {
              var terrainSizeX = Math.min(data.terrainSize[0] / Math.min(data.squareSize, 1) / mapScale, 20480)
              var terrainSizeY = Math.min(data.terrainSize[1] / Math.min(data.squareSize, 1) / mapScale, 20480)
              viewParams = [-terrainSizeX / 2, -terrainSizeY / 2, terrainSizeX, terrainSizeY]
            } else {
              viewParams = [-512, -512, 1024, 1024]
            }

            mapContainer.style.width = viewParams[2] + "px"
            mapContainer.style.height = viewParams[3] + "px"
            svg.setAttribute("viewBox", viewParams.join(" "))

            var ctx = canvas.getContext("2d")
            canvas.style.width = viewParams[2] * 2 + "px"
            canvas.style.height = viewParams[3] * 2 + "px"
            canvas.width = viewParams[2] * 2
            canvas.height = viewParams[3] * 2
            canvasWrapper.style.width = canvas.style.width
            canvasWrapper.style.height = canvas.style.height

            ctx.width = viewParams[2] * 2
            ctx.height = viewParams[3] * 2

            ctx.clearRect(0, 0, viewParams[2] * 2, viewParams[3] * 2)
            //ctx.stroke()

            let ctxR = routeCanvasCtx
            routeCanvas.style.width = viewParams[2] * 2 + "px"
            routeCanvas.style.height = viewParams[3] * 2 + "px"
            routeCanvas.width = viewParams[2] * 2 * routeScale
            routeCanvas.height = viewParams[3] * 2 * routeScale
            routeCanvasWrapper.style.width = routeCanvas.style.width
            routeCanvasWrapper.style.height = routeCanvas.style.height

            ctxR.width = viewParams[2] * 2 * routeScale
            ctxR.height = viewParams[3] * 2 * routeScale

            ctxR.clearRect(0, 0, viewParams[2] * 2 * routeScale, viewParams[3] * 2 * routeScale)
            //ctxR.stroke()

            // Draw the map elements
            var minX = 999,
              maxX = -999
            var minY = 999,
              maxY = -999

            var nodes = data.nodes

            // figure out dimensions of the road network
            for (var key in nodes) {
              var el = nodes[key]
              if (-el.pos[0] < minX) minX = -el.pos[0]
              if (-el.pos[0] > maxX) maxX = -el.pos[0]
              if (el.pos[1] < minY) minY = el.pos[1]
              if (el.pos[1] > maxY) maxY = el.pos[1]
            }

            // use background image if existing, otherwise draw a simple grid
            if (data.minimapImage && data.terrainOffset && data.terrainSize) {
              // mapcontainer.style.backgroundSize = "100%"
              // mapcontainer.style.backgroundImage = "url('/" + data.minimapImage + "')"
              var bgImage = hu("<image>", svg)
                .attr({
                  x: data.terrainOffset[0] / mapScale,
                  y: data.terrainOffset[1] / mapScale,
                  width: data.terrainSize[0] / mapScale,
                  height: data.terrainSize[1] / mapScale,
                  transform: "scale(-1,-1)",
                  "xlink:href": "/" + data.minimapImage,
                })
                .prependTo(svg)
            } else {
              // draw grid
              var distX = maxX - minX
              var dx = 50
              for (var x = minX; x <= maxX + 1; x += dx) {
                _createLine(canvasCtx, { x: x, y: minY, radius: 1 }, { x: x, y: maxY, radius: 1 }, "#FFFFFF55")
              }
              var distY = maxY - minY
              var dy = 50
              for (var y = minY; y <= maxY + 1; y += dy) {
                _createLine(canvasCtx, { x: minX, y: y, radius: 1 }, { x: maxX, y: y, radius: 1 }, "#FFFFFF55")
              }
            }

            function getDrivabilityColor(d) {
              if (d <= 0.1) return "#967864" //'#967864'
              if (d > 0.1 && d < 0.9) return "#969678" //'#969678'
              return "#DCDCDC" //#DCDCDC'
            }

            function drawRoads(drivabilityMin, drivabilityMax) {
              for (var key in nodes) {
                var el = nodes[key]
                // walk the links of the node
                if (el.links !== undefined) {
                  // links
                  var d = ""
                  var first = true
                  for (var key2 in el.links) {
                    var el2 = nodes[key2]
                    var drivability = el.links[key2].drivability
                    if (drivability >= drivabilityMin && drivability <= drivabilityMax) {
                      _createLine(
                        canvasCtx,
                        {
                          x: -el.pos[0] / mapScale + viewParams[2],
                          y: el.pos[1] / mapScale + viewParams[3],
                          radius: Math.min(Math.max(el.radius, 0), 5) * 3,
                        },
                        {
                          x: -el2.pos[0] / mapScale + viewParams[2],
                          y: el2.pos[1] / mapScale + viewParams[3],
                          radius: Math.min(Math.max(el2.radius, 0), 5) * 3, // prevents massive blobs due to waypoints having larger radius'
                        },
                        getDrivabilityColor(drivability)
                      )
                    }
                  }
                }
              }
            }
            drawRoads(0, 0.1)
            drawRoads(0.1, 0.9)
            drawRoads(0.9, 1)
            mapReady = true
          }
        }

        function setupStaticMarkers(data) {
          if (data.key === undefined) return
          if (staticMarkersDict[data.key] === undefined) {
            staticMarkersDict[data.key] = {}
          }
          let dict = staticMarkersDict[data.key]
          var mapSize = viewParams[2]

          // remove any existing collectable svgs
          for (var key in dict) {
            dict[key].marker.remove()
          }
          markerGroup = hu("<g>", svg)
          // draw collectable svgs
          for (var i = 0; i < data.items.length; i += 4) {
            /**
            let marker = hu('<image>', markerGroup)
            let icon = '/ui/modules/apps/navigation/missionIcons/'+data.items[i+3]+'.svg'
            marker.attr({
              x: -25, y:-25,
              width: 50, height: 50,
              style: style + "0px);",
              'xlink:href': icon
            })
            // store all collectable svgs
            **/

            let style = "transform: translate3d(" + -data.items[i + 0] + "px," + data.items[i + 1] + "px,"
            let marker = hu("<circle>", svg)
            marker.attr("cx", -data.items[i + 0])
            marker.attr("cy", data.items[i + 1])
            marker.attr("r", 8)
            marker.attr("fill", "#2C5CFF")
            marker.attr("style", style)
            marker.css("stroke", "#FFFFFF")
            marker.css("stroke-width", "3px")
            //marker.attr('visibility', 'hidden')

            dict[i / 4.0] = {
              marker: marker,

              screenX: -data.items[i + 0],
              screenY: data.items[i + 1],
              visible: false,
            }
          }
        }

        // need to draw collectables after roads have been drawn
        function setupCollectables(data) {
          var mapSize = viewParams[2]
          var perimeterScale = 0

          scope.collectableTotal = data.collectableAmount
          scope.collectableCurrent = data.collectableCurrent

          // Calculating the different radius' for the collectible containers
          // based on map size.
          switch (true) {
            case mapSize <= 1024: {
              perimeterScale = 130
              break
            }
            case mapSize > 1024: {
              perimeterScale = 125
              break
            }
            case mapSize >= 20480: {
              perimeterScale = 100
              break
            }
          }

          // remove any existing collectable svgs
          for (var key in collectableShapes) {
            collectableShapes[key].remove()
          }
          collGroup = hu("<g>", svg)
          // draw collectable svgs
          for (var item in data.collectableItems) {
            var offset = Math.random() * 50
            var coll = hu("<circle>", collGroup).attr({
              cx: -data.collectableItems[item][1] - (Math.max(Math.random() * 50), 50), // collectible will be located somewhere within this circle but never in the exact center.
              cy: data.collectableItems[item][2] - (Math.max(Math.random() * 50), 50),
              r: perimeterScale,
              fill: "rgba(255, 160, 0, 0.2)",
              stroke: "rgba(255, 160, 0, 0.6)",
              "stroke-width": 3,
            })
            // store all collectable svgs
            collectableShapes[item] = coll
          }
        }

        scope.openBigMap = function () {
          bngApi.engineLua(`if freeroam_bigMapMode then freeroam_bigMapMode.enterBigMap() end`)
        }

        bngApi.engineLua("extensions.ui_uiNavi.requestUIDashboardMap()")

        bngApi.engineLua(`extensions.core_collectables.sendUIState()`)
        bngApi.engineLua(`if gameplay_missions_missionEnter then gameplay_missions_missionEnter.sendMissionLocationsToMinimap() end`)
      },
    }
  },
])
