-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function setAllLightsEnabled(group, value)
  for i = 0, group:size() - 1 do
    local obj = Sim.upcast(group.obj:at(i))
    if obj then
      if obj.obj:isSubClassOf('LightBase') then
        obj.obj:setLightEnabled(value)
      end
    end
  end
end

local lastValue = nil

local function setCubemap(cubemapname)
  if cubemapname then
    local levelinf = scenetree.findObject("theLevelInfo")
    if levelinf then
      log("I", "setCubemap", "Enabling cubemap " ..cubemapname)
      levelinf:setField('globalEnviromentMap', 0, cubemapname)
      levelinf:postApply()
    else
      log("W", "setCubemap", "Enabling fallback cubemap " ..cubemapname)
      setConsoleVariable("$defaultLevelEnviromentMap", cubemapname)
    end
  end
end

local function setMaterialProperty(material, property, layer, value)
  if type(material) == "string" then
    material = scenetree.findObject(material)
  end

  if material.___type == "class<Material>" then
    if material:getField(property, layer) ~= value then
      material:setField(property, layer, value)
      --we do not want to flush materials
      --material:flush()
      material:reload()
    end
    return true
  else
    log('E', "setMaterialProperty", "Given object is not a material.")
    return false
  end
end

--this assume all layers got the same color!!!!
local lastColorR = nil
local lastColorG = nil
local lastColorB = nil

local function setCloudlayers(dtReal, colorR, colorG, colorB)
  if colorR and colorR ~= lastColorR then
    local cloudLayers = scenetree.findClassObjects('CloudLayer')
    --print("test1")
    local colorRSmoother = newTemporalSmoothing()
    local colorGSmoother = newTemporalSmoothing()
    local colorBSmoother = newTemporalSmoothing()
    colorRSmoother:set(lastColorR or 0.992)
    colorGSmoother:set(lastColorG or 0.996)
    colorBSmoother:set(lastColorB or 0.996)
    local colorRTarget = colorRSmoother:getWithRateUncapped(colorR, dtReal, 1)
    local colorGTarget = colorGSmoother:getWithRateUncapped(colorG, dtReal, 1)
    local colorBTarget = colorBSmoother:getWithRateUncapped(colorB, dtReal, 1)
    for i,v in pairs(cloudLayers) do
      local cloudLayer = scenetree.findObject(v)
      cloudLayer:setField('baseColor', 0, colorRTarget.." "..colorGTarget.." "..colorBTarget)
      lastColorR = colorRTarget
      lastColorG = colorGTarget
      lastColorB = colorBTarget
    end
  end
end

local function onUpdate(dtReal)
  local tod = scenetree.tod
  if not tod then return end

  if tod.time > 0.252 and tod.time < 0.755 then
    setCloudlayers(dtReal, 0.011, 0.019, 0.023)
  else
    setCloudlayers(dtReal, 0.992, 0.996, 0.996)
  end

  local value = false
  if tod.time > 0.24 and tod.time < 0.78 then
    value = true
  end

  if lastValue == value then return end
  lastValue = value
  if value == true then
    setMaterialProperty("lampadaire_verre", 'emissiveFactor', 0, "7.84313822 3.45882392 0")
    setCubemap("cubemap_streetsceneNight_reflection")
  else
    setMaterialProperty("lampadaire_verre", 'emissiveFactor', 0, "0 0 0")
    setCubemap("cubemap_streetscene_reflection")
  end

  if scenetree.night_lights then
    setAllLightsEnabled(scenetree.night_lights, value ,"")
  end
end

M.onUpdate = onUpdate

return M