--	------------------------------------------------------------
--		Lua Logic for Barbent Gambling Zone [gamzone]
--		Version 0.1
--	------------------------------------------------------------

local M = {}

-- Alle Lichter einer Gruppe setzen (true = on, false = off)
local function setLights(group, value)
    for i = 0, group.obj:getCount(), 1 do						-- Für alle Elemente dieser Gruppe
        local id = group.obj:idAt(i)							-- ID des Elements ermitteln
        local obj = scenetree.findObjectById(id)				-- Objekt aus der ID ermitteln
        if obj and obj.obj:isSubClassOf('LightBase') then		-- Gibt es das Objekt und it es ein Licht?
            obj.obj:setLightEnabled(value)						-- Lichstatus setzten
        end
    end
end

-- Hidden Status alle Objekte einer Gruppe ändern (true = hidden, false = unhidden)
local function hideObjects(group, value)
	for i = 0, group.obj:getCount(), 1 do						-- Für alle Elemente dieser Gruppe
        local id = group.obj:idAt(i)							-- ID des Elements ermitteln
        local obj = scenetree.findObjectById(id)				-- Objekt aus der ID ermitteln
        if obj then												-- Gibt es das Objekt?
			obj.hidden = value									-- Hidden-Status setzen
		end
	end
end

local triggerCarCount_Hangar = 0		-- Anzahl der Fahrzeuge, die im Airstrip-Hangar sind
---local state_Hangar = false				-- Zustand der Lichter im Airstrip-Hangar
local lastValue = nil

local function onUpdate(dt)
    local tod = scenetree.tod
    if not tod then return end

    local value = false
    if tod.time > 0.21 and tod.time < 0.78 then
        value = true
    end

    if lastValue == value then return end
    lastValue = value

	-- Lichtgruppen (Ordner im Scenetree)
	if scenetree.harbour_lights then
		setLights(scenetree.harbour_lights, value )
    end
    if scenetree.street_lights then
		setLights(scenetree.street_lights, value )
	end
    if scenetree.airstrip_lights then
		setLights(scenetree.airstrip_lights, value )
	end
    if scenetree.runway_lights then
		setLights(scenetree.runway_lights, value )
	end
	if scenetree.PartEmiter_CampfireDam then	-- Particle Emitter Campfire Dam
		scenetree.findObject('PartEmiter_CampfireDam').active = value
		if (value == true) then	--Night?
			scenetree.findObject('SFX_Campfire'):play()	-- Play the campfire sound
			-- (Looped only works if object has 0 as fade in/out time)
		else
			scenetree.findObject('SFX_Campfire'):stop()	-- Stop the campfire sound
		end
	end
end
--################################################################################################
-- LUA-Trigger-Objekte auswerten
local function onBeamNGTrigger(data)
	-- ********** Aitstrip Hangar Light Trigger
	if data.triggerName == 'Trigger_Hangar' then
		if data.event == 'enter' then	-- Ein Fahrzeug hat den Trigger betreten
			triggerCarCount_Hangar = triggerCarCount_Hangar + 1
			if triggerCarCount_Hangar == 1 then -- Das erste Fahrzeug?
				if scenetree.hangar_lights then
					setLights(scenetree.hangar_lights, true)			-- Echte Lichter einschalten
				end
				if scenetree.hangar_nLights_off then
					hideObjects(scenetree.hangar_nLights_off, true)		-- Ganze Gruppe der (Fake-)Neonröhren-OFFs hiden
				end
				if scenetree.hangar_nLights_on then
					hideObjects(scenetree.hangar_nLights_on, false)		-- und die Gruppe der (Fake-)Neonröhren-ONs unhiden
				end
				scenetree.findObject('FlickOfTheSwitch_hangar'):play()		-- Clack!
			end
		elseif data.event == 'exit' then	-- Ein Fahrzeug hat den Trigger verlassen
			triggerCarCount_Hangar = triggerCarCount_Hangar - 1
			if triggerCarCount_Hangar == 0 then -- Das letzte Fahrzeug?
				if scenetree.hangar_lights then
					setLights(scenetree.hangar_lights, false)			-- Echte Lichter ausschalten
				end
				if scenetree.hangar_nLights_off then
					hideObjects(scenetree.hangar_nLights_off, false)		-- Ganze Gruppe der (Fake-)Neonröhren-OFFs unhiden
				end
				if scenetree.hangar_nLights_on then
					hideObjects(scenetree.hangar_nLights_on, true)			-- und die Gruppe der (Fake-)Neonröhren-ONs hiden
				end
				scenetree.findObject('FlickOfTheSwitch_hangar'):play()		-- Clack!
			end
		end
	end
	
	local vehObj	-- Subject
	-- ********** Refilling
	if data.triggerName == 'Trigger_Refilling' then		-- Trigger must be ticking!!!
		vehObj = be:getObjectByID(data.subjectID)						-- Subjekt ermitteln
		local airspeed = vehObj:getVelocity():length()					-- Airspeed des Subjekts ermitteln
		if airspeed < 1 then	-- Subject (Fahrzeug) steht (fast) still
				
			---*************************Forum Fragen!!!


			--local eData = vehObj:getElectricsData(engineRunning)
			--debug(eData)
			-- funzt nicht
			--local result = vehObj:queueLuaCommand("local value = electrics.values.engineRunning")
			--ui_message(result, 5, "BSGT Message")				
			----------------------------------------------
				--vehObj:queueLuaCommand("electrics.toggle_warn_signal()")	-- funzt


			--if  eData < 1 then
				vehObj:queueLuaCommand("energyStorage.init()")	-- funzt
				
				ui_message("Vehicle refilled/recharged", 5, "BSGT Message")
			--end
				
--					vehObj:queueLuaCommand('fire.explodeVehicle()')					-- Sprengen
		end
	end
	
-------------------------------

end
M.onUpdate = onUpdate
M.onBeamNGTrigger = onBeamNGTrigger


return M