-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

-- In other words, if you are a modder feel free to reuse this code with above license

--If you reload Lua with CTRL+L use thise in the GE console `extensions.mainLevel.onClientStartMission()

local windowOpen = ui_imgui.BoolPtr(true)

local M = {}
M.dependencies = {"ui_imgui"}
local im = ui_imgui
local ffi = require("ffi")

--independent GUI
local showUI = nil
local tempFloat = nil
local pos = im.ImVec2(0, 0)
local imguiUtils = require('ui/imguiUtils')

--scenetree
local objects = nil

local shadowvalue = nil

local tod = nil

local light = nil

--underground parking
local outsideLevelPath = "/levels/kamuro/main.level.json"
local playerisintrigger = nil
local zoomSpeed = 0.5
local defaultFov = 48

--level data
local levelfolder = nil
local levelname =  nil
local emission = 0
local tool_version = "1.2 Lite"
local appTitle = " CK Map Controller - ".. tool_version .." - ".. "no-init" .." - ".. beamng_arch
local promptTitle = " Underground Parking"

local toolWindowName = 'map_controller'

local function onClientStartMission()
  log('I', '', 'Getting current level path' )
  levelname = getCurrentLevelIdentifier()
  --print(levelname)
  log('I', '', 'Level is loaded' )
  levelfolder = ("/levels/" .. levelname .. "/")
  appTitle = " CK Map Controller - ".. tool_version .." - ".. levelname .." - ".. beamng_arch
end

--get scene tree all objects
local function getSimObjects(fileName)
  local ret = {}
  local objs = scenetree.getAllObjects()
  --log('E', '', '# objects existing: ' .. tostring(#scenetree.getAllObjects()))
  for _, objName in ipairs(objs) do
    local o = scenetree.findObject(objName)
    if o and o.getFileName then
      if o:getFileName() == fileName then
        table.insert(ret, o)
      end
    end
  end
  return ret
  --log('E', '', '# objects left: ' .. tostring(#scenetree.getAllObjects()))
end

--Hide Elements of map

local function setHiddenRec(object, hidden)
  object.hidden = hidden
  if object:isSubClassOf("SimSet") then
    for i=0, object:size() - 1 do
      setHiddenRec(object:at(i), hidden)
    end
  end
end

local function hideGroup(groupName, hidden)
  if not groupName then
    log('E', "", "Group is missing, please contact level author")
    guihooks.trigger('Message', {ttl = 10, msg = 'Group is missing, please contact level author', icon = "goat"})
  else
  local group = scenetree.findObject(groupName)
  if group then setHiddenRec(group, hidden) end
  end
end

--Dynamic Lights
local function setAllLightsEnabled(group, value)
  if not group then
    log('E', "", "Garage lights group is missing, please contact level author")
    guihooks.trigger('Message', {ttl = 10, msg = 'Garage lights group is missing, please contact level author', icon = "goat"})
  else
  for i = 0, group.obj:getCount(), 1 do
      local id = group.obj:idAt(i)
      local obj = scenetree.findObjectById(id)
      if obj and obj.obj:isSubClassOf('LightBase') then
          obj.obj:setLightEnabled( value )
      end
  end
end
end

--DynamicShadows
local function setAllLightsShadowsEnabledDisabled(group, shadowvalue)
  if not group then
    log('E', "", "Garage Lights group is missing, please contact level author")
    guihooks.trigger('Message', {ttl = 10, msg = 'Garage Lights group is missing, please contact level author', icon = "goat"})
  else
  for i = 0, group.obj:getCount(), 1 do
    local id = group.obj:idAt(i)
    light = scenetree.findObjectById(id)
    light.castShadows = shadowvalue
  end
  guihooks.trigger('Message', {ttl = 10, msg = 'Shadows Changed', icon = "goat"})
end
end

--get player vehicle
local function getCurrentVehicle()
  local result = nil
  if gameplay_walk and gameplay_walk.isWalking() then
    return result
  end

  -- get the current vehicle to load it in the garage
  local vehicle = be:getPlayerVehicle(0)
  local playerVehicleData = core_vehicle_manager.getPlayerVehicleData()
  if vehicle and playerVehicleData then
    local config = serialize(playerVehicleData.config) -- when using "vehicle.partConfig" here, the color of the vehicle will be wrong if you use a custom default config
    local model = vehicle.JBeam
    result = { model, {config=config} }
  end
  return result
end

local function startGarageExit(job)
  -- move the camera
  job.sleep(0.5)
  core_camera.speedFactor = 1
  commands.setFreeCamera()
  core_camera.setFOV(0, 30)
  --get free camera, set position and then rotation x, y, z
  core_camera.setPosition(0, vec3(34.032020568848, -75.608245849609, 54.998992919922))
  core_camera.setRotation(0, quat(0.19684225320816, -0.00096008850960061, 0.0047819651663303, 0.98042303323746))
  --commands.getFreeCamera():setPosRot(34.032020568848, -75.608245849609, 54.998992919922, 0.19684225320816, -0.00096008850960061, 0.0047819651663303, 0.98042303323746)

  -- let the vehicle drive forward
  local playerVeh = be:getPlayerVehicle(0)
  playerVeh:queueLuaCommand('ai.driveUsingPath({wpTargetList = {"parkingexit"}})')
  job.sleep(3)

  -- fade to black
  ui_fadeScreen.start(1)
  job.sleep(1.5)

  -- load the test level
  freeroam_freeroam.startFreeroam(outsideLevelPath, nil, nil, getCurrentVehicle())
end

local function exitGarage()
  Engine.Audio.playOnce('AudioGui', "/levels/kamuropark/art/sound/door.ogg")
  playerisintrigger = 0
  guihooks.trigger('ShowApps', false)
  core_jobsystem.create(startGarageExit)
end

local function onBeamNGTrigger(data)
  -- dump(data)
  if data.triggerName == "BeamNGTrigger_1" and data.event == "enter" then
    --we need to react only to seated vehicle, not ai
    local veh = be:getPlayerVehicleID(0)
    if data.subjectID == veh then
      playerisintrigger = 1
    end
  end
  if data.triggerName == "BeamNGTrigger_1" and data.event == "exit" then
    --we need to react only to seated vehicle, not ai
    local veh = be:getPlayerVehicleID(0)
    if data.subjectID == veh then
      playerisintrigger = 0
    end
  end
end

local lastValue = nil

local function onUpdate()

   --imgui app
  im.Begin(appTitle, showUI)

  if levelname == nil then
    im.Text("No init, please restart the game")
    im.Text("Some features are not available")
    im.Text("")
    if im.Button("Fix level lua without restarting") then
      extensions.mainLevel.onClientStartMission()
    end
    im.Text("")
  else
    im.Text("Toggle Garage Lights Shadows")
    if im.Button("Disabled") then
      setAllLightsShadowsEnabledDisabled(scenetree.lights_main, false)
      setAllLightsShadowsEnabledDisabled(scenetree.lights_help, false)
      setAllLightsShadowsEnabledDisabled(scenetree.showroomdisabled_lights_main, false)
    end

    im.SameLine()
    if im.Button("Enabled (Default)") then
      setAllLightsShadowsEnabledDisabled(scenetree.lights_main, true)
      setAllLightsShadowsEnabledDisabled(scenetree.lights_help, true)
      setAllLightsShadowsEnabledDisabled(scenetree.showroomdisabled_lights_main, true)
    end
    im.Text("Toggle Garage Lights Setup")
    if im.Button("Disabled Main") then
      setAllLightsEnabled(scenetree.lights_main, false)
      setAllLightsEnabled(scenetree.showroomdisabled_lights_main, false)
    end

    im.SameLine()
    if im.Button("Enabled Main") then
      setAllLightsEnabled(scenetree.lights_main, true)
      setAllLightsEnabled(scenetree.showroomdisabled_lights_main, true)
    end
    if im.Button("Disabled Additional") then
      setAllLightsEnabled(scenetree.lights_help, false)
      setAllLightsEnabled(scenetree.lights_noshadow, false)
      setAllLightsEnabled(scenetree.showroomdisabled_lights_noshadow, false)
    end

    im.SameLine()
    if im.Button("Enabled Additional") then
      setAllLightsEnabled(scenetree.lights_help, true)
      setAllLightsEnabled(scenetree.lights_noshadow, true)
      setAllLightsEnabled(scenetree.showroomdisabled_lights_noshadow, true)
    end
    if im.Button("Disabled Showroom") then
      setAllLightsEnabled(scenetree.lights_shadows, false)
      hideGroup("showroom_panes", true)
      setAllLightsEnabled(scenetree.showroomdisabled_lights_noshadow, true)
      setAllLightsEnabled(scenetree.showroomdisabled_lights_main, true)
    end

    im.SameLine()
    if im.Button("Enabled Showroom") then
      setAllLightsEnabled(scenetree.lights_shadows, true)
      hideGroup("showroom_panes", false)
      setAllLightsEnabled(scenetree.showroomdisabled_lights_noshadow, false)
      setAllLightsEnabled(scenetree.showroomdisabled_lights_main, false)
    end
  end

  im.End()


  if playerisintrigger == 1 then

    --window api test
    --[[local result = messageBox("Underground Parking", "Do you want to enter the underground parking?", 4, 2)
    if result == 1 then
      editor.saveLevel()
    elseif result == 2 then
      Engine.cancelShutdown()
    end]]--
    --imgui2

    local addonmap = FS:fileExists("/levels/kamuro/info.json")
    local win = im.GetMainViewport()
    local image1 = imguiUtils.texObj('/levels/kamuro/kamuro_preview.PNG')
    local image1size = im.ImVec2(640, 339)
    local image2 = imguiUtils.texObj('/levels/kamuropark/kiryu.png')
    local image2size = im.ImVec2(640, 480)
    -- set position
    pos.x = win.Pos.x + win.Size.x / 2
    pos.y = win.Pos.y + win.Size.y / 2
    im.SetNextWindowPos(pos, im.ImGuiCond_Always, im.ImVec2(0.5, 0.5))
    im.SetNextWindowBgAlpha(0.7)

    im.Begin(promptTitle, nil, im.WindowFlags_AlwaysAutoResize+im.WindowFlags_NoResize+im.WindowFlags_NoMove+im.WindowFlags_NoCollapse+im.WindowFlags_NoDocking)
    im.PushFont3("cairo_bold")
    if addonmap == true then
      im.SetWindowFontScale(2.0)
      im.Text("Do you want to leave the carpark?")
      im.Text("This will load your vehicle into the Kamurocho map")
      im.Image(image1.texId, image1size, im.ImVec2(0, 0), im.ImVec2(1, 1), col)
      im.Text("")
      im.SetWindowFontScale(1.2)
      if im.Button("Yes, let me out", im.ImVec2(120, 0)) then
        exitGarage()
      end
      im.SameLine()
      if im.Button("No", im.ImVec2(120, 0)) then
        playerisintrigger = 0
      end
    else
      im.SetWindowFontScale(1.65)
      im.Text("This efature requires the Kamurocho map to work, please download it from the forums")
      im.Text("")
      im.Image(image2.texId, image2size, im.ImVec2(0, 0), im.ImVec2(1, 1), col)
      im.Text("")
      im.SetWindowFontScale(1.2)
      if im.Button("Download map (beamng.com)", im.ImVec2(120, 0)) then
        playerisintrigger = 0
        openWebBrowser("https://www.beamng.com/threads/kamurocho-tokyo-yakuza-0.83067/")
      end
      if im.IsItemHovered() then
        im.BeginTooltip()
        im.Text("Open BeamNG Forums in your web browser")
        im.EndTooltip()
      end
    end
    im.PopFont()
    im.SetWindowFontScale(1.0)
    im.End()
  end

end

local function onEditorInitialized()
  editor.addWindowMenuItem("Map Controller", onWindowMenuItem, {groupMenuName = 'Car_Killer Addons'})
  editor.registerWindow(toolWindowName, im.ImVec2(500, 200))

end


M.onClientStartMission = onClientStartMission
M.onUpdate = onUpdate
M.onBeamNGTrigger = onBeamNGTrigger
M.onEditorInitialized = onEditorInitialized

return M
--Written in Visual Studio Code with Yukino Yukinoshita theme by Car_Killer 2022