-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local im  = ui_imgui

local C = {}

C.name = 'Vehicle Id Validator'
C.description = 'Checks if the vehicle exists when given a table of vehicle ids and a preset count.'
C.category = 'once_instant'
C.color = im.ImVec4(1, 1, 0, 0.75)
C.author = 'BeamNG'
C.tmpSecondPassFlag = true
C.pinSchema = {
  {dir = 'in', type = 'table', tableType = 'vehicleIds', name = 'vehicleIds', description = 'Table of spawned vehicle ids.'},
}

C.tags = {}

function C:init()
  self.count = 1
end

function C:postInit()
  self:updatePins(0, self.count)
end

function C:drawCustomProperties()
  local reason
  im.PushID1("LAYOUT_COLUMNS")
  im.Columns(2, "layoutColumns")
  im.Text("Vehicle Count")
  im.NextColumn()
  local count = im.IntPtr(self.count)
  if im.InputInt('##count'..self.id, count) then
    if count[0] < 1 then count[0] = 1 end
    self:updatePins(self.count, count[0])
    reason = "Changed Value count to " .. count[0]
  end

  im.Columns(1)
  im.PopID()
  return reason
end

function C:updatePins(old, new)
  if new < old then
    for i = old, new + 1, -1 do
      for _, lnk in pairs(self.graph.links) do
        if lnk.sourcePin == self.pinOut['vehExists_'..i] or lnk.sourcePin == self.pinOut['vehId_'..i] then
          self.graph:deleteLink(lnk)
        end
      end
      self:removePin(self.pinOut['vehExists_'..i])
      self:removePin(self.pinOut['vehId_'..i])
    end
  else
    for i = old + 1, new do
      self:createPin('out', 'flow', 'vehExists_'..i)
      self:createPin('out', 'number', 'vehId_'..i)
    end
  end
  self.count = new
end

function C:_onSerialize(res)
  res.count = self.count
end

function C:_onDeserialized(res)
  self.count = res.count or 1
  self:updatePins(1, self.count)
end

function C:workOnce()
  for i = 1, self.count do
    self.pinOut['vehExists_'..i].value = false
    self.pinOut['vehId_'..i].value = 0
    local vehId = self.pinIn.vehicleIds.value[i]
    if vehId and be:getObjectByID(vehId) then
      self.pinOut['vehExists_'..i].value = true
      self.pinOut['vehId_'..i].value = vehId
    end
  end
end

return _flowgraph_createNode(C)
