-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local im  = ui_imgui

local C = {}

C.name = 'Get Rank String'
C.description = 'Returns the translated rank string of a given rank number (or placement) of a race.'
C.category = 'repeat_instant'
C.color = im.ImVec4(1, 1, 0, 0.75)
C.author = 'BeamNG'
C.tmpSecondPassFlag = true
C.pinSchema = {
  {dir = 'in', type = 'number', name = 'placement', description = 'Race placement number.'},
  {dir = 'out', type = 'string', name = 'rankStr', description = 'Translated rank string.'}
}

C.tags = {}

function C:work()
  self.pinOut.rankStr.value = translateLanguage('missions.aiRace.general.rank'..self.pinIn.placement.value, tostring(self.pinIn.placement.value))
end

return _flowgraph_createNode(C)
