local M = {}

local function setAllLightsEnabled(group, value)
    for i = 0, group.obj:getCount(), 1 do
        local id = group.obj:idAt(i)
        local obj = scenetree.findObjectById(id)
        if obj and obj.obj:isSubClassOf('LightBase') then
            obj.obj:setLightEnabled( value )
        else
			obj.obj:setHidden( value )
		end
    end
end

local lastValue1 = nil
local lastValue2 = nil
local lastValue3 = nil

local function onUpdate()
    local tod = scenetree.tod
    if not tod then return end

	-- first group
    local value1 = false
    if tod.time > 0.24 and tod.time < 0.77 then
        value1 = true
    end

    if lastValue1 ~= value1 then
		if scenetree.DynamicLights_on then
		  setAllLightsEnabled(scenetree.DynamicLights_on, value1 )
		end
	end

	-- second group
    local value2 = true
    if tod.time > 0.24 and tod.time < 0.77 then
        value2 = false
    end

    if lastValue2 ~= value2 then
		if scenetree.DynamicLights_off then
		  setAllLightsEnabled(scenetree.DynamicLights_off, value2 )
		end
	end
end

M.onUpdate = onUpdate

return M