		--------------------------------------
-- MotorsportsComplex DragLights script --
	-- Made by 2FastRacing | www.2fast.racing --
		--------------------------------------

local M = {}

local function setAllLightsEnabled(group, value)
    for i = 0, group.obj:getCount(), 1 do
        local id = group.obj:idAt(i)
        local obj = scenetree.findObjectById(id)
        if obj and obj.obj:isSubClassOf('LightBase') then
            obj.obj:setLightEnabled( value )
        end
    end
end

local function onUpdate(dtReal, dtSim, dtRaw)
	local tod = scenetree.tod
    if not tod then return end

    local value = false
    if tod.time > 0.22 and tod.time < 0.77 then
        value = true
    end

    if lastValue == value then return end
    lastValue = value
print('DynamicLights Loaded!')
    if scenetree.NightLights then
      setAllLightsEnabled(scenetree.NightLights, value )
    end
    if scenetree.LightPosts then
      setAllLightsEnabled(scenetree.LightPosts, value )
    end
end

M.onClientPostStartMission = onClientPostStartMission
M.onExtensionLoaded = onExtensionLoaded
M.onBeamNGTrigger = onBeamNGTrigger
M.onUpdate = onUpdate

return M
